/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurableBase;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.apache.hadoop.hdds.conf.ReconfigurationChangeCallback;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.ratis.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigurationHandler
extends ReconfigurableBase
implements ReconfigureProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigurationHandler.class);
    private final String name;
    private final CheckedConsumer<String, IOException> requireAdminPrivilege;
    private final Map<String, UnaryOperator<String>> properties = new ConcurrentHashMap<String, UnaryOperator<String>>();
    private final List<ReconfigurationChangeCallback> completeCallbacks = new ArrayList<ReconfigurationChangeCallback>();
    private BiConsumer<ReconfigurationTaskStatus, Configuration> reconfigurationStatusListener;

    public void registerCompleteCallback(ReconfigurationChangeCallback callback) {
        this.completeCallbacks.add(callback);
    }

    public void setReconfigurationCompleteCallback(BiConsumer<ReconfigurationTaskStatus, Configuration> statusListener) {
        this.reconfigurationStatusListener = statusListener;
    }

    public BiConsumer<ReconfigurationTaskStatus, Configuration> defaultLoggingCallback() {
        return (status, conf) -> {
            if (status.getStatus() != null && !status.getStatus().isEmpty()) {
                LOG.info("Reconfiguration completed with {} updated properties.", (Object)status.getStatus().size());
            } else {
                LOG.info("Reconfiguration complete. No properties were changed.");
            }
        };
    }

    private void triggerCompleteCallbacks(ReconfigurationTaskStatus status, Configuration newConf) {
        if (status.getStatus() != null && !status.getStatus().isEmpty()) {
            HashMap<String, Boolean> changedKeys = new HashMap<String, Boolean>();
            for (ReconfigurationUtil.PropertyChange change : status.getStatus().keySet()) {
                boolean deleted = change.newVal == null;
                changedKeys.put(change.prop, !deleted);
            }
            for (ReconfigurationChangeCallback callback : this.completeCallbacks) {
                callback.onPropertiesChanged(changedKeys, newConf);
            }
        }
        if (this.reconfigurationStatusListener != null) {
            this.reconfigurationStatusListener.accept(status, newConf);
        }
    }

    public ReconfigurationHandler(String name, OzoneConfiguration config, CheckedConsumer<String, IOException> requireAdminPrivilege) {
        super((Configuration)config);
        this.name = name;
        this.requireAdminPrivilege = requireAdminPrivilege;
        this.addReconfigurationCompleteCallback(status -> {
            Configuration newConf = this.getNewConf();
            this.triggerCompleteCallbacks((ReconfigurationTaskStatus)status, newConf);
        });
    }

    public ReconfigurationHandler register(String property, UnaryOperator<String> reconfigureFunction) {
        this.properties.put(property, reconfigureFunction);
        return this;
    }

    public ReconfigurationHandler register(ReconfigurableConfig config) {
        config.reconfigurableProperties().forEach(prop -> this.properties.put((String)prop, newValue -> {
            config.reconfigureProperty(prop, newValue);
            return newValue;
        }));
        return this;
    }

    @Override
    protected Configuration getNewConf() {
        return new OzoneConfiguration();
    }

    public Set<String> getReconfigurableProperties() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public String reconfigurePropertyImpl(String property, String newValue) throws ReconfigurationException {
        String oldValue = this.getConf().get(property);
        try {
            return (String)this.properties.getOrDefault(property, UnaryOperator.identity()).apply(newValue);
        }
        catch (Exception e) {
            throw new ReconfigurationException(property, newValue, oldValue, (Throwable)e);
        }
    }

    @Override
    public String getServerName() {
        return this.name;
    }

    @Override
    public void startReconfigure() throws IOException {
        this.requireAdminPrivilege.accept((Object)"startReconfiguration");
        this.startReconfigurationTask();
    }

    @Override
    public ReconfigurationTaskStatus getReconfigureStatus() throws IOException {
        this.requireAdminPrivilege.accept((Object)"getReconfigurationStatus");
        return this.getReconfigurationTaskStatus();
    }

    @Override
    public List<String> listReconfigureProperties() throws IOException {
        this.requireAdminPrivilege.accept((Object)"listReconfigurableProperties");
        return new ArrayList<String>(new TreeSet(this.getReconfigurableProperties()));
    }

    @Override
    public void close() throws IOException {
        this.shutdownReconfigurationTask();
    }
}

