/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.DecayRpcSchedulerUtil;
import org.apache.hadoop.hdds.utils.UgiMetricsUtil;
import org.apache.hadoop.metrics2.MetricsTag;

public final class PrometheusMetricsSinkUtil {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!(^|[A-Z_]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    private static final Pattern REPLACE_PATTERN = Pattern.compile("[^a-zA-Z0-9]+");

    private PrometheusMetricsSinkUtil() {
    }

    public static List<MetricsTag> addTags(String key, String username, String servername, Collection<MetricsTag> unmodifiableTags) {
        ArrayList<MetricsTag> metricTags = new ArrayList<MetricsTag>(unmodifiableTags);
        Stream.of(DecayRpcSchedulerUtil.createUsernameTag(username), UgiMetricsUtil.createServernameTag(key, servername)).forEach(metricsTag -> metricsTag.ifPresent(mt -> PrometheusMetricsSinkUtil.addTag(mt, metricTags)));
        return metricTags;
    }

    private static void addTag(MetricsTag metricsTag, List<MetricsTag> metricsTags) {
        metricsTags.add(metricsTag);
    }

    public static String prometheusName(String recordName, String metricName) {
        if (StringUtils.isNotEmpty((CharSequence)recordName) && recordName.startsWith("Rocksdb_")) {
            return PrometheusMetricsSinkUtil.normalizeName(recordName) + "_" + metricName.toLowerCase();
        }
        String baseName = StringUtils.capitalize((String)recordName) + StringUtils.capitalize((String)metricName);
        return PrometheusMetricsSinkUtil.normalizeName(baseName);
    }

    private static String normalizeName(String baseName) {
        CharSequence[] parts = SPLIT_PATTERN.split(baseName);
        String result = String.join((CharSequence)"_", parts).toLowerCase();
        return REPLACE_PATTERN.matcher(result).replaceAll("_");
    }

    public static String getMetricName(String recordName, String metricName) {
        return DecayRpcSchedulerUtil.splitMetricNameIfNeeded(recordName, metricName);
    }

    public static String getUsername(String recordName, String metricName) {
        return DecayRpcSchedulerUtil.checkMetricNameForUsername(recordName, metricName);
    }
}

