/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority.profile;

import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.DefaultProfile;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.PKIProfile;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;

public class DefaultCAProfile
extends DefaultProfile {
    private static final BiPredicate<Extension, PKIProfile> VALIDATE_BASIC_CONSTRAINTS = DefaultCAProfile::validateBasicExtensions;

    private static boolean validateBasicExtensions(Extension ext, PKIProfile pkiProfile) {
        BasicConstraints constraints = BasicConstraints.getInstance((Object)ext.getParsedValue());
        return constraints.isCA() && pkiProfile.isCA();
    }

    @Override
    public boolean isCA() {
        return true;
    }

    @Override
    public Map<ASN1ObjectIdentifier, BiPredicate<Extension, PKIProfile>> getExtensionsMap() {
        EXTENSIONS_MAP.putIfAbsent(Extension.basicConstraints, VALIDATE_BASIC_CONSTRAINTS);
        return EXTENSIONS_MAP;
    }

    @Override
    public KeyUsage getKeyUsage() {
        return new KeyUsage(190);
    }
}

