/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocolPB;

import com.google.common.collect.Maps;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ReconfigureProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolDatanodePB;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolOmPB;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolPB;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ReconfigureProtocolClientSideTranslatorPB
implements ProtocolMetaInterface,
ReconfigureProtocol,
ProtocolTranslator {
    public static final Logger LOG = LoggerFactory.getLogger(ReconfigureProtocolClientSideTranslatorPB.class);
    private static final RpcController NULL_CONTROLLER = null;
    private static final ReconfigureProtocolProtos.GetServerNameRequestProto VOID_GET_SERVER_NAME = ReconfigureProtocolProtos.GetServerNameRequestProto.newBuilder().build();
    private static final ReconfigureProtocolProtos.StartReconfigureRequestProto VOID_START_RECONFIG = ReconfigureProtocolProtos.StartReconfigureRequestProto.newBuilder().build();
    private static final ReconfigureProtocolProtos.ListReconfigurePropertiesRequestProto VOID_LIST_RECONFIGURABLE_PROPERTIES = ReconfigureProtocolProtos.ListReconfigurePropertiesRequestProto.newBuilder().build();
    private static final ReconfigureProtocolProtos.GetReconfigureStatusRequestProto VOID_GET_RECONFIG_STATUS = ReconfigureProtocolProtos.GetReconfigureStatusRequestProto.newBuilder().build();
    private final ReconfigureProtocolPB rpcProxy;

    public ReconfigureProtocolClientSideTranslatorPB(HddsProtos.NodeType nodeType, InetSocketAddress addr, UserGroupInformation ugi, OzoneConfiguration conf) throws IOException {
        this.rpcProxy = ReconfigureProtocolClientSideTranslatorPB.createReconfigureProtocolProxy(nodeType, addr, ugi, conf);
    }

    static ReconfigureProtocolPB createReconfigureProtocolProxy(HddsProtos.NodeType nodeType, InetSocketAddress addr, UserGroupInformation ugi, OzoneConfiguration conf) throws IOException {
        Configuration hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)conf);
        if (nodeType == HddsProtos.NodeType.OM) {
            RPC.setProtocolEngine((Configuration)OzoneConfiguration.of((OzoneConfiguration)conf), ReconfigureProtocolOmPB.class, ProtobufRpcEngine.class);
            return (ReconfigureProtocolPB)RPC.getProtocolProxy(ReconfigureProtocolOmPB.class, (long)RPC.getProtocolVersion(ReconfigureProtocolOmPB.class), (InetSocketAddress)addr, (UserGroupInformation)ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf)).getProxy();
        }
        if (nodeType == HddsProtos.NodeType.DATANODE) {
            RPC.setProtocolEngine((Configuration)OzoneConfiguration.of((OzoneConfiguration)conf), ReconfigureProtocolDatanodePB.class, ProtobufRpcEngine.class);
            return (ReconfigureProtocolPB)RPC.getProtocolProxy(ReconfigureProtocolDatanodePB.class, (long)RPC.getProtocolVersion(ReconfigureProtocolDatanodePB.class), (InetSocketAddress)addr, (UserGroupInformation)ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf)).getProxy();
        }
        RPC.setProtocolEngine((Configuration)OzoneConfiguration.of((OzoneConfiguration)conf), ReconfigureProtocolPB.class, ProtobufRpcEngine.class);
        return (ReconfigureProtocolPB)RPC.getProtocolProxy(ReconfigureProtocolPB.class, (long)RPC.getProtocolVersion(ReconfigureProtocolPB.class), (InetSocketAddress)addr, (UserGroupInformation)ugi, (Configuration)hadoopConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)hadoopConf)).getProxy();
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public String getServerName() throws IOException {
        try {
            ReconfigureProtocolProtos.GetServerNameResponseProto response = this.rpcProxy.getServerName(NULL_CONTROLLER, VOID_GET_SERVER_NAME);
            return response.getName();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void startReconfigure() throws IOException {
        try {
            this.rpcProxy.startReconfigure(NULL_CONTROLLER, VOID_START_RECONFIG);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public ReconfigurationTaskStatus getReconfigureStatus() throws IOException {
        try {
            ReconfigureProtocolProtos.GetReconfigureStatusResponseProto response = this.rpcProxy.getReconfigureStatus(NULL_CONTROLLER, VOID_GET_RECONFIG_STATUS);
            return this.getReconfigureStatus(response);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    private ReconfigurationTaskStatus getReconfigureStatus(ReconfigureProtocolProtos.GetReconfigureStatusResponseProto response) {
        HashMap statusMap = null;
        long endTime = 0L;
        long startTime = response.getStartTime();
        if (response.hasEndTime()) {
            endTime = response.getEndTime();
        }
        if (response.getChangesCount() > 0) {
            statusMap = Maps.newHashMap();
            for (ReconfigureProtocolProtos.GetConfigurationChangeProto change : response.getChangesList()) {
                ReconfigurationUtil.PropertyChange pc = new ReconfigurationUtil.PropertyChange(change.getName(), change.getNewValue(), change.getOldValue());
                String errorMessage = null;
                if (change.hasErrorMessage()) {
                    errorMessage = change.getErrorMessage();
                }
                statusMap.put(pc, Optional.ofNullable(errorMessage));
            }
        }
        return new ReconfigurationTaskStatus(startTime, endTime, (Map)statusMap);
    }

    @Override
    public List<String> listReconfigureProperties() throws IOException {
        try {
            ReconfigureProtocolProtos.ListReconfigurePropertiesResponseProto response = this.rpcProxy.listReconfigureProperties(NULL_CONTROLLER, VOID_LIST_RECONFIGURABLE_PROPERTIES);
            return response.getNameList();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, ReconfigureProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ReconfigureProtocolPB.class), (String)methodName);
    }
}

