/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurableBase;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.ratis.util.function.CheckedConsumer;

public class ReconfigurationHandler
extends ReconfigurableBase
implements ReconfigureProtocol {
    private final String name;
    private final CheckedConsumer<String, IOException> requireAdminPrivilege;
    private final Map<String, UnaryOperator<String>> properties = new ConcurrentHashMap<String, UnaryOperator<String>>();

    public ReconfigurationHandler(String name, OzoneConfiguration config, CheckedConsumer<String, IOException> requireAdminPrivilege) {
        super((Configuration)config);
        this.name = name;
        this.requireAdminPrivilege = requireAdminPrivilege;
    }

    public ReconfigurationHandler register(String property, UnaryOperator<String> reconfigureFunction) {
        this.properties.put(property, reconfigureFunction);
        return this;
    }

    public ReconfigurationHandler register(ReconfigurableConfig config) {
        config.reconfigurableProperties().forEach(prop -> this.properties.put((String)prop, newValue -> {
            config.reconfigureProperty(prop, newValue);
            return newValue;
        }));
        return this;
    }

    protected Configuration getNewConf() {
        return new OzoneConfiguration();
    }

    public Set<String> getReconfigurableProperties() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public String reconfigurePropertyImpl(String property, String newValue) throws ReconfigurationException {
        String oldValue = this.getConf().get(property);
        try {
            return (String)this.properties.getOrDefault(property, UnaryOperator.identity()).apply(newValue);
        }
        catch (Exception e) {
            throw new ReconfigurationException(property, newValue, oldValue, (Throwable)e);
        }
    }

    @Override
    public String getServerName() {
        return this.name;
    }

    @Override
    public void startReconfigure() throws IOException {
        this.requireAdminPrivilege.accept((Object)"startReconfiguration");
        this.startReconfigurationTask();
    }

    @Override
    public ReconfigurationTaskStatus getReconfigureStatus() throws IOException {
        this.requireAdminPrivilege.accept((Object)"getReconfigurationStatus");
        return this.getReconfigurationTaskStatus();
    }

    @Override
    public List<String> listReconfigureProperties() throws IOException {
        this.requireAdminPrivilege.accept((Object)"listReconfigurableProperties");
        return new ArrayList<String>(new TreeSet(this.getReconfigurableProperties()));
    }

    @Override
    public void close() throws IOException {
        this.shutdownReconfigurationTask();
    }
}

