/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.keyvalue.impl.Buffers;
import org.apache.hadoop.ozone.container.keyvalue.impl.StreamDataChannelBase;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.util.ReferenceCountedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStreamDataChannel
extends StreamDataChannelBase {
    public static final Logger LOG = LoggerFactory.getLogger(KeyValueStreamDataChannel.class);
    private final Buffers buffers = new Buffers(0x100000);
    private final AtomicBoolean closed = new AtomicBoolean();

    KeyValueStreamDataChannel(File file, ContainerData containerData, ContainerMetrics metrics) throws StorageContainerException {
        super(file, containerData, metrics);
    }

    @Override
    ContainerProtos.Type getType() {
        return ContainerProtos.Type.StreamWrite;
    }

    public int write(ReferenceCountedObject<ByteBuffer> referenceCounted) throws IOException {
        this.getMetrics().incContainerOpsMetrics(this.getType());
        this.assertOpen();
        return KeyValueStreamDataChannel.writeBuffers(referenceCounted, this.buffers, this::writeFileChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int writeBuffers(ReferenceCountedObject<ByteBuffer> src, Buffers buffers, WriteMethod writeMethod) throws IOException {
        for (ReferenceCountedObject<ByteBuffer> b : buffers.offer(src)) {
            try {
                KeyValueStreamDataChannel.writeFully((ByteBuffer)b.get(), writeMethod);
            }
            finally {
                b.release();
            }
        }
        return ((ByteBuffer)src.get()).remaining();
    }

    static void writeFully(ByteBuffer b, WriteMethod writeMethod) throws IOException {
        while (b.remaining() > 0) {
            int written = writeMethod.applyAsInt(b);
            if (written > 0) continue;
            throw new IOException("Unable to write");
        }
    }

    void assertOpen() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Already closed: " + this);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.writeBuffers();
            }
            finally {
                super.close();
            }
        }
    }

    @Override
    protected void cleanupInternal() throws IOException {
        this.buffers.cleanUpAll();
        if (this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    private void writeBuffers() throws IOException {
        ReferenceCountedObject<ByteBuf> ref = this.buffers.pollAll();
        ByteBuf buf = (ByteBuf)ref.retain();
        try {
            KeyValueStreamDataChannel.setEndIndex(buf);
            KeyValueStreamDataChannel.writeFully(buf.nioBuffer(), x$0 -> super.writeFileChannel(x$0));
        }
        finally {
            ref.release();
        }
    }

    static int readProtoLength(ByteBuf b, int lengthIndex) {
        int readerIndex = b.readerIndex();
        LOG.debug("{}, lengthIndex = {}, readerIndex = {}", new Object[]{b, lengthIndex, readerIndex});
        if (lengthIndex > readerIndex) {
            b.readerIndex(lengthIndex);
        } else {
            Preconditions.checkState((lengthIndex == readerIndex ? 1 : 0) != 0);
        }
        RatisHelper.debug((ByteBuf)b, (String)"readProtoLength", (Logger)LOG);
        return b.nioBuffer().getInt();
    }

    static void setEndIndex(ByteBuf b) {
        int readerIndex = b.readerIndex();
        int lengthIndex = readerIndex + b.readableBytes() - 4;
        int protoLength = KeyValueStreamDataChannel.readProtoLength(b.duplicate(), lengthIndex);
        int protoIndex = lengthIndex - protoLength;
        b.writerIndex(protoIndex);
    }

    static interface WriteMethod {
        public int applyAsInt(ByteBuffer var1) throws IOException;
    }
}

