/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.protocolPB.ContainerCommandResponseBuilders;
import org.apache.hadoop.hdds.scm.utils.ClientCommandsUtils;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.utils.FaultInjector;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.common.ChunkBufferToByteString;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.common.utils.BufferUtils;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerLayoutVersion;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.report.IncrementalReportSender;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.utils.ContainerLogger;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeChoosingPolicyFactory;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.ChunkUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.container.keyvalue.impl.BlockManagerImpl;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerFactory;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.apache.hadoop.util.Time;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueHandler
extends Handler {
    public static final Logger LOG = LoggerFactory.getLogger(KeyValueHandler.class);
    private final BlockManager blockManager;
    private final ChunkManager chunkManager;
    private final VolumeChoosingPolicy volumeChoosingPolicy;
    private final long maxContainerSize;
    private final long maxDeleteLockWaitMs;
    private final Function<ByteBuffer, ByteString> byteBufferToByteString;
    private final boolean validateChunkChecksumData;
    private final Striped<Lock> containerCreationLocks;
    private static FaultInjector injector;
    private final Clock clock;

    public KeyValueHandler(ConfigurationSource config, String datanodeId, ContainerSet contSet, VolumeSet volSet, ContainerMetrics metrics, IncrementalReportSender<Container> icrSender) {
        this(config, datanodeId, contSet, volSet, metrics, icrSender, Clock.systemUTC());
    }

    public KeyValueHandler(ConfigurationSource config, String datanodeId, ContainerSet contSet, VolumeSet volSet, ContainerMetrics metrics, IncrementalReportSender<Container> icrSender, Clock clock) {
        super(config, datanodeId, contSet, volSet, metrics, icrSender);
        this.clock = clock;
        this.blockManager = new BlockManagerImpl(config);
        this.validateChunkChecksumData = ((DatanodeConfiguration)((Object)this.conf.getObject(DatanodeConfiguration.class))).isChunkDataValidationCheck();
        this.chunkManager = ChunkManagerFactory.createChunkManager(config, this.blockManager, volSet);
        try {
            this.volumeChoosingPolicy = VolumeChoosingPolicyFactory.getPolicy(this.conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.maxContainerSize = (long)config.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        DatanodeConfiguration dnConf = (DatanodeConfiguration)((Object)this.conf.getObject(DatanodeConfiguration.class));
        this.maxDeleteLockWaitMs = dnConf.getDeleteContainerTimeoutMs();
        int threadCountPerDisk = this.conf.getInt("hdds.container.ratis.num.write.chunk.threads.per.volume", 10);
        int numberOfDisks = HddsServerUtil.getDatanodeStorageDirs((ConfigurationSource)this.conf).size();
        this.containerCreationLocks = Striped.lazyWeakLock((int)(threadCountPerDisk * numberOfDisks));
        boolean isUnsafeByteBufferConversionEnabled = this.conf.getBoolean("ozone.UnsafeByteOperations.enabled", true);
        this.byteBufferToByteString = ByteStringConversion.createByteBufferConversion((boolean)isUnsafeByteBufferConversionEnabled);
        if (ContainerLayoutVersion.getConfiguredVersion(this.conf) == ContainerLayoutVersion.FILE_PER_CHUNK) {
            LOG.warn("FILE_PER_CHUNK layout is not supported. Falling back to default : {}.", (Object)ContainerLayoutVersion.DEFAULT_LAYOUT.name());
            OzoneConfiguration.of((ConfigurationSource)this.conf).set("ozone.scm.container.layout", ContainerLayoutVersion.DEFAULT_LAYOUT.name());
        }
    }

    @VisibleForTesting
    public VolumeChoosingPolicy getVolumeChoosingPolicyForTesting() {
        return this.volumeChoosingPolicy;
    }

    @Override
    public StateMachine.DataChannel getStreamDataChannel(Container container, ContainerProtos.ContainerCommandRequestProto msg) throws StorageContainerException {
        KeyValueContainer kvContainer = (KeyValueContainer)container;
        this.checkContainerOpen(kvContainer);
        if (msg.hasWriteChunk()) {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)msg.getWriteChunk().getBlockID());
            return this.chunkManager.getStreamDataChannel(kvContainer, blockID, this.metrics);
        }
        throw new StorageContainerException("Malformed request.", ContainerProtos.Result.IO_EXCEPTION);
    }

    @Override
    public void stop() {
        this.chunkManager.shutdown();
        this.blockManager.shutdown();
    }

    @Override
    public ContainerProtos.ContainerCommandResponseProto handle(ContainerProtos.ContainerCommandRequestProto request, Container container, DispatcherContext dispatcherContext) {
        try {
            return KeyValueHandler.dispatchRequest(this, request, (KeyValueContainer)container, dispatcherContext);
        }
        catch (RuntimeException e) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException((Throwable)e, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR), request);
        }
    }

    @VisibleForTesting
    static ContainerProtos.ContainerCommandResponseProto dispatchRequest(KeyValueHandler handler, ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ContainerProtos.Type cmdType = request.getCmdType();
        if (kvContainer != null) {
            try {
                handler.validateRequestDatanodeId(kvContainer.getContainerData().getReplicaIndex(), request.getDatanodeUuid());
            }
            catch (StorageContainerException e) {
                return ContainerUtils.logAndReturnError(LOG, e, request);
            }
        }
        switch (cmdType) {
            case CreateContainer: {
                return handler.handleCreateContainer(request, kvContainer);
            }
            case ReadContainer: {
                return handler.handleReadContainer(request, kvContainer);
            }
            case UpdateContainer: {
                return handler.handleUpdateContainer(request, kvContainer);
            }
            case DeleteContainer: {
                return handler.handleDeleteContainer(request, kvContainer);
            }
            case ListContainer: {
                return handler.handleUnsupportedOp(request);
            }
            case CloseContainer: {
                return handler.handleCloseContainer(request, kvContainer);
            }
            case PutBlock: {
                return handler.handlePutBlock(request, kvContainer, dispatcherContext);
            }
            case GetBlock: {
                return handler.handleGetBlock(request, kvContainer);
            }
            case DeleteBlock: {
                return handler.handleDeleteBlock(request, kvContainer);
            }
            case ListBlock: {
                return handler.handleListBlock(request, kvContainer);
            }
            case ReadChunk: {
                return handler.handleReadChunk(request, kvContainer, dispatcherContext);
            }
            case DeleteChunk: {
                return handler.handleDeleteChunk(request, kvContainer);
            }
            case WriteChunk: {
                return handler.handleWriteChunk(request, kvContainer, dispatcherContext);
            }
            case StreamInit: {
                return handler.handleStreamInit(request, kvContainer, dispatcherContext);
            }
            case ListChunk: {
                return handler.handleUnsupportedOp(request);
            }
            case CompactChunk: {
                return handler.handleUnsupportedOp(request);
            }
            case PutSmallFile: {
                return handler.handlePutSmallFile(request, kvContainer, dispatcherContext);
            }
            case GetSmallFile: {
                return handler.handleGetSmallFile(request, kvContainer);
            }
            case GetCommittedBlockLength: {
                return handler.handleGetCommittedBlockLength(request, kvContainer);
            }
            case FinalizeBlock: {
                return handler.handleFinalizeBlock(request, kvContainer);
            }
            case Echo: {
                return handler.handleEcho(request, kvContainer);
            }
        }
        return null;
    }

    @VisibleForTesting
    public ChunkManager getChunkManager() {
        return this.chunkManager;
    }

    @VisibleForTesting
    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    ContainerProtos.ContainerCommandResponseProto handleStreamInit(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        if (!request.hasWriteChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed {} request. trace ID: {}", (Object)request.getCmdType(), (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.WriteChunkRequestProto writeChunk = request.getWriteChunk();
        BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)writeChunk.getBlockID());
        String path = null;
        try {
            this.checkContainerOpen(kvContainer);
            path = this.chunkManager.streamInit(kvContainer, blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponseBuilder((ContainerProtos.ContainerCommandRequestProto)request).setMessage(path).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerProtos.ContainerCommandResponseProto handleCreateContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasCreateContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Create Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        if (kvContainer != null) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Container creation failed because key value container already exists", null, ContainerProtos.Result.CONTAINER_ALREADY_EXISTS), request);
        }
        try {
            this.validateRequestDatanodeId(request.getCreateContainer().hasReplicaIndex() ? Integer.valueOf(request.getCreateContainer().getReplicaIndex()) : null, request.getDatanodeUuid());
        }
        catch (StorageContainerException e) {
            return ContainerUtils.logAndReturnError(LOG, e, request);
        }
        long containerID = request.getContainerID();
        ContainerProtos.ContainerDataProto.State containerState = request.getCreateContainer().getState();
        if (containerState != ContainerProtos.ContainerDataProto.State.RECOVERING) {
            try {
                this.containerSet.ensureContainerNotMissing(containerID, containerState);
            }
            catch (StorageContainerException ex) {
                return ContainerUtils.logAndReturnError(LOG, ex, request);
            }
        }
        ContainerLayoutVersion layoutVersion = ContainerLayoutVersion.getConfiguredVersion(this.conf);
        KeyValueContainerData newContainerData = new KeyValueContainerData(containerID, layoutVersion, this.maxContainerSize, request.getPipelineID(), this.getDatanodeId());
        ContainerProtos.ContainerDataProto.State state = request.getCreateContainer().getState();
        if (state != null) {
            newContainerData.setState(state);
        }
        newContainerData.setReplicaIndex(request.getCreateContainer().getReplicaIndex());
        KeyValueContainer newContainer = new KeyValueContainer(newContainerData, this.conf);
        boolean created = false;
        Lock containerIdLock = (Lock)this.containerCreationLocks.get((Object)containerID);
        containerIdLock.lock();
        try {
            if (this.containerSet.getContainer(containerID) == null) {
                newContainer.create(this.volumeSet, this.volumeChoosingPolicy, this.clusterId);
                created = ContainerProtos.ContainerDataProto.State.RECOVERING == newContainer.getContainerState() ? this.containerSet.addContainerByOverwriteMissingContainer(newContainer) : this.containerSet.addContainer(newContainer);
            } else {
                LOG.debug("Container already exists. container Id {}", (Object)containerID);
            }
        }
        catch (StorageContainerException ex) {
            ContainerProtos.ContainerCommandResponseProto containerCommandResponseProto = ContainerUtils.logAndReturnError(LOG, ex, request);
            return containerCommandResponseProto;
        }
        finally {
            containerIdLock.unlock();
        }
        if (created) {
            ContainerLogger.logOpen(newContainerData);
            try {
                this.sendICR(newContainer);
            }
            catch (StorageContainerException ex) {
                return ContainerUtils.logAndReturnError(LOG, ex, request);
            }
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateContainerPathFields(KeyValueContainer container, HddsVolume hddsVolume) throws IOException {
        this.volumeSet.readLock();
        try {
            String idDir = VersionedDatanodeFeatures.ScmHA.chooseContainerPathID(hddsVolume, this.clusterId);
            container.populatePathFields(idDir, hddsVolume);
        }
        finally {
            this.volumeSet.readUnlock();
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleReadContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasReadContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Read Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        KeyValueContainerData containerData = kvContainer.getContainerData();
        return ContainerCommandResponseBuilders.getReadContainerResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.ContainerDataProto)containerData.getProtoBufMessage());
    }

    ContainerProtos.ContainerCommandResponseProto handleUpdateContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasUpdateContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Update Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        boolean forceUpdate = request.getUpdateContainer().getForceUpdate();
        List keyValueList = request.getUpdateContainer().getMetadataList();
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (ContainerProtos.KeyValue keyValue : keyValueList) {
            metadata.put(keyValue.getKey(), keyValue.getValue());
        }
        try {
            if (!metadata.isEmpty()) {
                kvContainer.update(metadata, forceUpdate);
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleDeleteContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasDeleteContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Delete container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        boolean forceDelete = request.getDeleteContainer().getForceDelete();
        try {
            this.deleteInternal(kvContainer, forceDelete);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleCloseContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasCloseContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Update Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.markContainerForClose(kvContainer);
            this.closeContainer(kvContainer);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Close Container failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handlePutBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ContainerProtos.BlockData blockDataProto;
        if (!request.hasPutBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Put Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            ContainerProtos.BlockData data = request.getPutBlock().getBlockData();
            BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)data);
            Preconditions.checkNotNull((Object)blockData);
            boolean endOfBlock = false;
            if (!request.getPutBlock().hasEof() || request.getPutBlock().getEof()) {
                if (!request.getPutBlock().getBlockData().getChunksList().isEmpty() || blockData.getMetadata().containsKey("incremental")) {
                    this.chunkManager.finishWriteChunks(kvContainer, blockData);
                }
                endOfBlock = true;
            }
            long bcsId = dispatcherContext == null ? 0L : dispatcherContext.getLogIndex();
            blockData.setBlockCommitSequenceId(bcsId);
            this.blockManager.putBlock(kvContainer, blockData, endOfBlock);
            blockDataProto = blockData.getProtoBufMessage();
            long numBytes = blockDataProto.getSerializedSize();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.PutBlock, numBytes);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Put Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.putBlockResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)blockDataProto);
    }

    ContainerProtos.ContainerCommandResponseProto handleFinalizeBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        ContainerProtos.BlockData responseData;
        ContainerProtos.ContainerCommandResponseProto responseProto = this.checkFaultInjector(request);
        if (responseProto != null) {
            return responseProto;
        }
        if (!request.hasFinalizeBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Finalize block request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            if (!VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.HBASE_SUPPORT)) {
                throw new StorageContainerException("DataNode has not finalized upgrading to a version that supports block finalization.", ContainerProtos.Result.UNSUPPORTED_REQUEST);
            }
            this.checkContainerOpen(kvContainer);
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getFinalizeBlock().getBlockID());
            Preconditions.checkNotNull((Object)blockID);
            LOG.info("Finalized Block request received {} ", (Object)blockID);
            responseData = this.blockManager.getBlock(kvContainer, blockID).getProtoBufMessage();
            this.chunkManager.finalizeWriteChunk(kvContainer, blockID);
            this.blockManager.finalizeBlock(kvContainer, blockID);
            kvContainer.getContainerData().addToFinalizedBlockSet(blockID.getLocalID());
            LOG.info("Block has been finalized {} ", (Object)blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Finalize Block failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getFinalizeBlockResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)responseData);
    }

    ContainerProtos.ContainerCommandResponseProto handleEcho(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        return ContainerCommandResponseBuilders.getEchoResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        ContainerProtos.BlockData responseData;
        if (!request.hasGetBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getGetBlock().getBlockID());
            BlockUtils.verifyReplicaIdx(kvContainer, blockID);
            responseData = this.blockManager.getBlock(kvContainer, blockID).getProtoBufMessage();
            long numBytes = responseData.getSerializedSize();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.GetBlock, numBytes);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Get Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getBlockDataResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)responseData);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetCommittedBlockLength(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        long blockLength;
        ContainerProtos.ContainerCommandResponseProto responseProto = this.checkFaultInjector(request);
        if (responseProto != null) {
            return responseProto;
        }
        if (!request.hasGetCommittedBlockLength()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getGetCommittedBlockLength().getBlockID());
            BlockUtils.verifyBCSId(kvContainer, blockID);
            blockLength = this.blockManager.getCommittedBlockLength(kvContainer, blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("GetCommittedBlockLength failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getBlockLengthResponse((ContainerProtos.ContainerCommandRequestProto)request, (long)blockLength);
    }

    ContainerProtos.ContainerCommandResponseProto handleListBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasListBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed list block request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ArrayList<ContainerProtos.BlockData> returnData = new ArrayList<ContainerProtos.BlockData>();
        try {
            int count = request.getListBlock().getCount();
            long startLocalId = -1L;
            if (request.getListBlock().hasStartLocalID()) {
                startLocalId = request.getListBlock().getStartLocalID();
            }
            List<BlockData> responseData = this.blockManager.listBlock(kvContainer, startLocalId, count);
            for (BlockData responseDatum : responseData) {
                returnData.add(responseDatum.getProtoBufMessage());
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("List blocks failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getListBlockResponse((ContainerProtos.ContainerCommandRequestProto)request, returnData);
    }

    @Deprecated
    ContainerProtos.ContainerCommandResponseProto handleDeleteBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        throw new UnsupportedOperationException("Datanode handles block deletion using BlockDeletingService");
    }

    ContainerProtos.ContainerCommandResponseProto handleReadChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ChunkBufferToByteString data;
        if (!request.hasReadChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Read Chunk request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            boolean isReadChunkV0;
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getReadChunk().getBlockID());
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)request.getReadChunk().getChunkData());
            Preconditions.checkNotNull((Object)chunkInfo);
            BlockUtils.verifyReplicaIdx(kvContainer, blockID);
            BlockUtils.verifyBCSId(kvContainer, blockID);
            if (dispatcherContext == null) {
                dispatcherContext = DispatcherContext.getHandleReadChunk();
            }
            if (isReadChunkV0 = ClientCommandsUtils.getReadChunkVersion((ContainerProtos.ReadChunkRequestProto)request.getReadChunk()).equals((Object)ContainerProtos.ReadChunkVersion.V0)) {
                chunkInfo.setReadDataIntoSingleBuffer(true);
            }
            data = this.chunkManager.readChunk(kvContainer, blockID, chunkInfo, dispatcherContext);
            LOG.debug("read chunk from block {} chunk {}", (Object)blockID, (Object)chunkInfo);
            if (DispatcherContext.op(dispatcherContext).readFromTmpFile()) {
                this.validateChunkChecksumData(data, chunkInfo);
                this.metrics.incBytesReadStateMachine(chunkInfo.getLen());
                this.metrics.incNumReadStateMachine();
            }
            this.metrics.incContainerBytesStats(ContainerProtos.Type.ReadChunk, chunkInfo.getLen());
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Read Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        Preconditions.checkNotNull((Object)data, (Object)"Chunk data is null");
        return ContainerCommandResponseBuilders.getReadChunkResponse((ContainerProtos.ContainerCommandRequestProto)request, (ChunkBufferToByteString)data, this.byteBufferToByteString);
    }

    @Deprecated
    ContainerProtos.ContainerCommandResponseProto handleDeleteChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        throw new UnsupportedOperationException("Datanode handles chunk deletion using BlockDeletingService");
    }

    private void validateChunkChecksumData(ChunkBufferToByteString data, ChunkInfo info) throws StorageContainerException {
        if (this.validateChunkChecksumData) {
            try {
                if (data instanceof ChunkBuffer) {
                    ChunkBuffer b = (ChunkBuffer)data;
                    Checksum.verifyChecksum((ChunkBuffer)b.duplicate(b.position(), b.limit()), (ChecksumData)info.getChecksumData(), (int)0);
                } else {
                    Checksum.verifyChecksum((ByteString)data.toByteString(this.byteBufferToByteString), (ChecksumData)info.getChecksumData(), (int)0);
                }
            }
            catch (OzoneChecksumException ex) {
                throw ChunkUtils.wrapInStorageContainerException((Exception)((Object)ex));
            }
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleWriteChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        if (!request.hasWriteChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Write Chunk request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.BlockData blockDataProto = null;
        try {
            boolean isWrite;
            this.checkContainerOpen(kvContainer);
            ContainerProtos.WriteChunkRequestProto writeChunk = request.getWriteChunk();
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)writeChunk.getBlockID());
            ContainerProtos.ChunkInfo chunkInfoProto = writeChunk.getChunkData();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            ChunkBuffer data = null;
            if (dispatcherContext == null) {
                dispatcherContext = DispatcherContext.getHandleWriteChunk();
            }
            if (isWrite = dispatcherContext.getStage().isWrite()) {
                data = ChunkBuffer.wrap((List)writeChunk.getData().asReadOnlyByteBufferList());
                this.validateChunkChecksumData((ChunkBufferToByteString)data, chunkInfo);
            }
            this.chunkManager.writeChunk((Container)kvContainer, blockID, chunkInfo, data, dispatcherContext);
            boolean isCommit = dispatcherContext.getStage().isCommit();
            if (isCommit && writeChunk.hasBlock()) {
                long startTime = Time.monotonicNowNanos();
                this.metrics.incContainerOpsMetrics(ContainerProtos.Type.PutBlock);
                BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)writeChunk.getBlock().getBlockData());
                blockData.setBlockCommitSequenceId(dispatcherContext.getLogIndex());
                boolean eob = writeChunk.getBlock().getEof();
                if (eob) {
                    this.chunkManager.finishWriteChunks(kvContainer, blockData);
                }
                this.blockManager.putBlock(kvContainer, blockData, eob);
                blockDataProto = blockData.getProtoBufMessage();
                long numBytes = blockDataProto.getSerializedSize();
                this.metrics.incContainerBytesStats(ContainerProtos.Type.PutBlock, numBytes);
                this.metrics.incContainerOpsLatencies(ContainerProtos.Type.PutBlock, Time.monotonicNowNanos() - startTime);
            }
            if (isWrite) {
                this.metrics.incContainerBytesStats(ContainerProtos.Type.WriteChunk, writeChunk.getChunkData().getLen());
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Write Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getWriteChunkResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, blockDataProto);
    }

    ContainerProtos.ContainerCommandResponseProto handlePutSmallFile(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ContainerProtos.BlockData blockDataProto;
        if (!request.hasPutSmallFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Put Small File request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.PutSmallFileRequestProto putSmallFileReq = request.getPutSmallFile();
        try {
            this.checkContainerOpen(kvContainer);
            BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)putSmallFileReq.getBlock().getBlockData());
            Preconditions.checkNotNull((Object)blockData);
            ContainerProtos.ChunkInfo chunkInfoProto = putSmallFileReq.getChunkInfo();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            ChunkBuffer data = ChunkBuffer.wrap((List)putSmallFileReq.getData().asReadOnlyByteBufferList());
            if (dispatcherContext == null) {
                dispatcherContext = DispatcherContext.getHandlePutSmallFile();
            }
            BlockID blockID = blockData.getBlockID();
            this.validateChunkChecksumData((ChunkBufferToByteString)data, chunkInfo);
            this.chunkManager.writeChunk((Container)kvContainer, blockID, chunkInfo, data, dispatcherContext);
            this.chunkManager.finishWriteChunks(kvContainer, blockData);
            LinkedList<ContainerProtos.ChunkInfo> chunks = new LinkedList<ContainerProtos.ChunkInfo>();
            chunks.add(chunkInfoProto);
            blockData.setChunks(chunks);
            blockData.setBlockCommitSequenceId(dispatcherContext.getLogIndex());
            this.blockManager.putBlock(kvContainer, blockData);
            blockDataProto = blockData.getProtoBufMessage();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.PutSmallFile, chunkInfo.getLen());
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Read Chunk failed", (Throwable)ex, ContainerProtos.Result.PUT_SMALL_FILE_ERROR), request);
        }
        return ContainerCommandResponseBuilders.getPutFileResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)blockDataProto);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetSmallFile(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasGetSmallFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Small File request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.GetSmallFileRequestProto getSmallFileReq = request.getGetSmallFile();
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)getSmallFileReq.getBlock().getBlockID());
            BlockData responseData = this.blockManager.getBlock(kvContainer, blockID);
            ContainerProtos.ChunkInfo chunkInfoProto = null;
            ArrayList dataBuffers = new ArrayList();
            DispatcherContext dispatcherContext = DispatcherContext.getHandleGetSmallFile();
            for (ContainerProtos.ChunkInfo chunk : responseData.getChunks()) {
                ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunk);
                boolean isReadChunkV0 = ClientCommandsUtils.getReadChunkVersion((ContainerProtos.GetSmallFileRequestProto)request.getGetSmallFile()).equals((Object)ContainerProtos.ReadChunkVersion.V0);
                if (isReadChunkV0) {
                    chunkInfo.setReadDataIntoSingleBuffer(true);
                }
                ChunkBufferToByteString data = this.chunkManager.readChunk(kvContainer, blockID, chunkInfo, dispatcherContext);
                dataBuffers.addAll(data.toByteStringList(this.byteBufferToByteString));
                chunkInfoProto = chunk;
            }
            this.metrics.incContainerBytesStats(ContainerProtos.Type.GetSmallFile, BufferUtils.getBuffersLen(dataBuffers));
            return ContainerCommandResponseBuilders.getGetSmallFileResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, dataBuffers, chunkInfoProto);
        }
        catch (StorageContainerException e) {
            return ContainerUtils.logAndReturnError(LOG, e, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Write Chunk failed", (Throwable)ex, ContainerProtos.Result.GET_SMALL_FILE_ERROR), request);
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleUnsupportedOp(ContainerProtos.ContainerCommandRequestProto request) {
        return ContainerCommandResponseBuilders.unsupportedRequest((ContainerProtos.ContainerCommandRequestProto)request);
    }

    private void checkContainerOpen(KeyValueContainer kvContainer) throws StorageContainerException {
        ContainerProtos.Result result;
        ContainerProtos.ContainerDataProto.State containerState = kvContainer.getContainerState();
        if (containerState == ContainerProtos.ContainerDataProto.State.OPEN || containerState == ContainerProtos.ContainerDataProto.State.CLOSING || containerState == ContainerProtos.ContainerDataProto.State.RECOVERING) {
            return;
        }
        switch (containerState) {
            case QUASI_CLOSED: {
                result = ContainerProtos.Result.CLOSED_CONTAINER_IO;
                break;
            }
            case CLOSED: {
                result = ContainerProtos.Result.CLOSED_CONTAINER_IO;
                break;
            }
            case UNHEALTHY: {
                result = ContainerProtos.Result.CONTAINER_UNHEALTHY;
                break;
            }
            case INVALID: {
                result = ContainerProtos.Result.INVALID_CONTAINER_STATE;
                break;
            }
            default: {
                result = ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
            }
        }
        String msg = "Requested operation not allowed as ContainerState is " + containerState;
        throw new StorageContainerException(msg, result);
    }

    @Override
    public Container importContainer(ContainerData originalContainerData, InputStream rawContainerStream, TarContainerPacker packer) throws IOException {
        Preconditions.checkState((boolean)(originalContainerData instanceof KeyValueContainerData), (Object)"Should be KeyValueContainerData instance");
        KeyValueContainerData containerData = new KeyValueContainerData((KeyValueContainerData)originalContainerData);
        KeyValueContainer container = new KeyValueContainer(containerData, this.conf);
        HddsVolume targetVolume = originalContainerData.getVolume();
        this.populateContainerPathFields(container, targetVolume);
        container.importContainerData(rawContainerStream, packer);
        ContainerLogger.logImported(containerData);
        this.sendICR(container);
        return container;
    }

    @Override
    public void exportContainer(Container container, OutputStream outputStream, TarContainerPacker packer) throws IOException {
        KeyValueContainer kvc = (KeyValueContainer)container;
        kvc.exportContainerData(outputStream, packer);
        ContainerLogger.logExported(container.getContainerData());
    }

    @Override
    public void markContainerForClose(Container container) throws IOException {
        container.writeLock();
        try {
            ContainerProtos.ContainerDataProto.State state = container.getContainerState();
            if (HddsUtils.isOpenToWriteState((ContainerProtos.ContainerDataProto.State)state)) {
                if (state == ContainerProtos.ContainerDataProto.State.RECOVERING) {
                    this.containerSet.removeRecoveringContainer(((ContainerData)container.getContainerData()).getContainerID());
                    ContainerLogger.logRecovered(container.getContainerData());
                }
                container.markContainerForClose();
                ContainerLogger.logClosing(container.getContainerData());
                this.sendICR(container);
            }
        }
        finally {
            container.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markContainerUnhealthy(Container container, Container.ScanResult reason) throws StorageContainerException {
        container.writeLock();
        try {
            long containerID = ((ContainerData)container.getContainerData()).getContainerID();
            if (container.getContainerState() == ContainerProtos.ContainerDataProto.State.UNHEALTHY) {
                LOG.debug("Call to mark already unhealthy container {} as unhealthy", (Object)containerID);
                return;
            }
            HddsVolume containerVolume = ((ContainerData)container.getContainerData()).getVolume();
            if (containerVolume.isFailed()) {
                LOG.debug("Ignoring unhealthy container {} detected on an already failed volume {}", (Object)containerID, (Object)containerVolume);
                return;
            }
            try {
                container.markContainerUnhealthy();
            }
            catch (StorageContainerException ex) {
                LOG.warn("Unexpected error while marking container {} unhealthy", (Object)containerID, (Object)ex);
            }
            finally {
                ContainerLogger.logUnhealthy(container.getContainerData(), reason);
                this.sendICR(container);
            }
        }
        finally {
            container.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quasiCloseContainer(Container container, String reason) throws IOException {
        container.writeLock();
        try {
            ContainerProtos.ContainerDataProto.State state = container.getContainerState();
            if (state == ContainerProtos.ContainerDataProto.State.QUASI_CLOSED) {
                return;
            }
            if (state != ContainerProtos.ContainerDataProto.State.CLOSING) {
                ContainerProtos.Result error = state == ContainerProtos.ContainerDataProto.State.INVALID ? ContainerProtos.Result.INVALID_CONTAINER_STATE : ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
                throw new StorageContainerException("Cannot quasi close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", error);
            }
            container.quasiClose();
            ContainerLogger.logQuasiClosed(container.getContainerData(), reason);
            this.sendICR(container);
        }
        finally {
            container.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeContainer(Container container) throws IOException {
        container.writeLock();
        try {
            ContainerProtos.ContainerDataProto.State state = container.getContainerState();
            if (state == ContainerProtos.ContainerDataProto.State.CLOSED) {
                return;
            }
            if (state == ContainerProtos.ContainerDataProto.State.UNHEALTHY) {
                throw new StorageContainerException("Cannot close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", ContainerProtos.Result.CONTAINER_UNHEALTHY);
            }
            if (state != ContainerProtos.ContainerDataProto.State.CLOSING && state != ContainerProtos.ContainerDataProto.State.QUASI_CLOSED) {
                ContainerProtos.Result error = state == ContainerProtos.ContainerDataProto.State.INVALID ? ContainerProtos.Result.INVALID_CONTAINER_STATE : ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
                throw new StorageContainerException("Cannot close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", error);
            }
            container.close();
            ContainerLogger.logClosed(container.getContainerData());
            this.sendICR(container);
        }
        finally {
            container.writeUnlock();
        }
    }

    @Override
    public void deleteContainer(Container container, boolean force) throws IOException {
        this.deleteInternal(container, force);
    }

    @Override
    public void deleteBlock(Container container, BlockData blockData) throws IOException {
        this.chunkManager.deleteChunks(container, blockData);
        if (LOG.isDebugEnabled()) {
            for (ContainerProtos.ChunkInfo chunkInfo : blockData.getChunks()) {
                ChunkInfo info = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfo);
                LOG.debug("block {} chunk {} deleted", (Object)blockData.getBlockID(), (Object)info);
            }
        }
    }

    @Override
    public void deleteUnreferenced(Container container, long localID) throws IOException {
        StringBuilder prefixBuilder = new StringBuilder();
        ContainerLayoutVersion layoutVersion = ((ContainerData)container.getContainerData()).getLayoutVersion();
        long containerID = ((ContainerData)container.getContainerData()).getContainerID();
        switch (layoutVersion) {
            case FILE_PER_BLOCK: {
                prefixBuilder.append(localID).append(".block");
                break;
            }
            case FILE_PER_CHUNK: {
                prefixBuilder.append(localID).append("_chunk_");
                break;
            }
            default: {
                throw new IOException("Unsupported container layout version " + (Object)((Object)layoutVersion) + " for the container " + containerID);
            }
        }
        String prefix = prefixBuilder.toString();
        File chunkDir = ContainerUtils.getChunkDir(container.getContainerData());
        String[] chunkNames = this.getFilesWithPrefix(prefix, chunkDir);
        if (chunkNames.length == 0) {
            LOG.warn("Missing delete block(Container = {}, Block = {}", (Object)containerID, (Object)localID);
            return;
        }
        for (String name : chunkNames) {
            File file = new File(chunkDir, name);
            if (!file.isFile()) continue;
            FileUtil.fullyDelete((File)file);
            LOG.info("Deleted unreferenced chunk/block {} in container {}", (Object)name, (Object)containerID);
        }
    }

    @Override
    public void addFinalizedBlock(Container container, long localID) {
        KeyValueContainer keyValueContainer = (KeyValueContainer)container;
        keyValueContainer.getContainerData().addToFinalizedBlockSet(localID);
    }

    @Override
    public boolean isFinalizedBlockExist(Container container, long localID) {
        KeyValueContainer keyValueContainer = (KeyValueContainer)container;
        return keyValueContainer.getContainerData().isFinalizedBlockExist(localID);
    }

    private String[] getFilesWithPrefix(String prefix, File chunkDir) {
        FilenameFilter filter = (dir, name) -> name.startsWith(prefix);
        return chunkDir.list(filter);
    }

    private boolean logBlocksIfNonZero(Container container) throws IOException {
        boolean nonZero = false;
        try (DBHandle dbHandle = BlockUtils.getDB((KeyValueContainerData)container.getContainerData(), this.conf);){
            StringBuilder stringBuilder = new StringBuilder();
            try (BlockIterator<BlockData> blockIterator = dbHandle.getStore().getBlockIterator(((ContainerData)container.getContainerData()).getContainerID());){
                while (blockIterator.hasNext()) {
                    nonZero = true;
                    stringBuilder.append(blockIterator.nextBlock());
                    if (!((double)stringBuilder.length() > StorageUnit.KB.toBytes(32.0))) continue;
                    break;
                }
            }
            if (nonZero) {
                LOG.error("blocks in rocksDB on container delete: {}", (Object)stringBuilder.toString());
            }
        }
        return nonZero;
    }

    private boolean logBlocksFoundOnDisk(Container container) throws IOException {
        File chunksPath = new File(((ContainerData)container.getContainerData()).getChunksPath());
        Preconditions.checkArgument((boolean)chunksPath.isDirectory());
        boolean notEmpty = false;
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(chunksPath.toPath());){
            StringBuilder stringBuilder = new StringBuilder();
            for (Path block : dir) {
                if (notEmpty) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(block);
                notEmpty = true;
                if (!((double)stringBuilder.length() > StorageUnit.KB.toBytes(16.0))) continue;
                break;
            }
            if (notEmpty) {
                LOG.error("Files still part of the container on delete: {}", (Object)stringBuilder.toString());
            }
        }
        return notEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInternal(Container container, boolean force) throws StorageContainerException {
        block16: {
            long startTime = this.clock.millis();
            container.writeLock();
            try {
                HddsVolume hddsVolume;
                KeyValueContainerData keyValueContainerData;
                block17: {
                    if (((ContainerData)container.getContainerData()).getVolume().isFailed()) {
                        LOG.info("Delete container issued on containerID {} which is in a failed volume. Skipping", (Object)((ContainerData)container.getContainerData()).getContainerID());
                        return;
                    }
                    if (!force) {
                        if (((ContainerData)container.getContainerData()).isOpen()) {
                            throw new StorageContainerException("Deletion of Open Container is not allowed.", ContainerProtos.Result.DELETE_ON_OPEN_CONTAINER);
                        }
                        if (container.hasBlocks()) {
                            this.metrics.incContainerDeleteFailedNonEmpty();
                            LOG.error("Received container deletion command for container {} but the container is not empty with blockCount {}", (Object)((ContainerData)container.getContainerData()).getContainerID(), (Object)((ContainerData)container.getContainerData()).getBlockCount());
                            this.logBlocksIfNonZero(container);
                            this.logBlocksFoundOnDisk(container);
                            throw new StorageContainerException("Non-force deletion of non-empty container is not allowed.", ContainerProtos.Result.DELETE_ON_NON_EMPTY_CONTAINER);
                        }
                    } else {
                        this.metrics.incContainersForceDelete();
                    }
                    if (!(container.getContainerData() instanceof KeyValueContainerData)) break block16;
                    keyValueContainerData = (KeyValueContainerData)container.getContainerData();
                    hddsVolume = keyValueContainerData.getVolume();
                    long waitTime = this.clock.millis() - startTime;
                    if (waitTime <= this.maxDeleteLockWaitMs) break block17;
                    LOG.warn("An attempt to delete container {} took {} ms acquiring locks and pre-checks. The delete has been skipped and should be retried automatically by SCM.", (Object)((ContainerData)container.getContainerData()).getContainerID(), (Object)waitTime);
                    return;
                }
                try {
                    container.markContainerForDelete();
                    long containerId = ((ContainerData)container.getContainerData()).getContainerID();
                    this.containerSet.removeContainer(containerId);
                    ContainerLogger.logDeleted(container.getContainerData(), force);
                    KeyValueContainerUtil.removeContainer(keyValueContainerData, this.conf);
                }
                catch (IOException ioe) {
                    LOG.error("Failed to move container under " + hddsVolume.getDeletedContainerDir());
                    String errorMsg = "Failed to move container" + ((ContainerData)container.getContainerData()).getContainerID();
                    this.triggerVolumeScanAndThrowException(container, errorMsg, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
                }
            }
            catch (StorageContainerException e) {
                throw e;
            }
            catch (IOException e) {
                LOG.error("Could not determine if the container {} is empty", (Object)((ContainerData)container.getContainerData()).getContainerID(), (Object)e);
                String errorMsg = "Failed to read container dir" + ((ContainerData)container.getContainerData()).getContainerID();
                this.triggerVolumeScanAndThrowException(container, errorMsg, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
            }
            finally {
                container.writeUnlock();
            }
        }
        this.sendICR(container);
        container.delete();
    }

    private void triggerVolumeScanAndThrowException(Container container, String msg, ContainerProtos.Result result) throws StorageContainerException {
        StorageVolumeUtil.onFailure(((ContainerData)container.getContainerData()).getVolume());
        throw new StorageContainerException(msg, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerProtos.ContainerCommandResponseProto checkFaultInjector(ContainerProtos.ContainerCommandRequestProto request) {
        if (injector != null) {
            FaultInjector faultInjector = injector;
            synchronized (faultInjector) {
                ContainerProtos.Type type = injector.getType();
                if (request.getCmdType().equals((Object)type) || type == null) {
                    Throwable ex = injector.getException();
                    if (ex != null) {
                        if (type == null) {
                            injector = null;
                        }
                        return ContainerUtils.logAndReturnError(LOG, (StorageContainerException)ex, request);
                    }
                    try {
                        injector.pause();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static Logger getLogger() {
        return LOG;
    }

    @VisibleForTesting
    public static FaultInjector getInjector() {
        return injector;
    }

    @VisibleForTesting
    public static void setInjector(FaultInjector instance) {
        injector = instance;
    }

    private boolean validateRequestDatanodeId(Integer containerReplicaIdx, String requestDatanodeUUID) throws StorageContainerException {
        if (containerReplicaIdx != null && containerReplicaIdx > 0 && !requestDatanodeUUID.equals(this.getDatanodeId())) {
            throw new StorageContainerException(String.format("Request is trying to write to node with uuid : %s but the current nodeId is: %s .", requestDatanodeUUID, this.getDatanodeId()), ContainerProtos.Result.INVALID_ARGUMENT);
        }
        return true;
    }
}

