/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.hadoop.ozone.common.ChunkBufferToByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;

class ChunkBufferToByteStringByByteBufs
implements ChunkBufferToByteString {
    private final List<ByteBuf> buffers;
    private volatile List<ByteString> byteStrings;
    private volatile ByteString concatenated;

    ChunkBufferToByteStringByByteBufs(List<ByteBuf> buffers) {
        this.buffers = buffers == null || buffers.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(buffers);
    }

    @Override
    public void release() {
        for (ByteBuf buf : this.buffers) {
            buf.release();
        }
    }

    @Override
    public ByteString toByteStringImpl(Function<ByteBuffer, ByteString> f) {
        if (this.concatenated != null) {
            return this.concatenated;
        }
        this.initByteStrings(f);
        return Objects.requireNonNull(this.concatenated, "concatenated == null");
    }

    @Override
    public List<ByteString> toByteStringListImpl(Function<ByteBuffer, ByteString> f) {
        if (this.byteStrings != null) {
            return this.byteStrings;
        }
        return this.initByteStrings(f);
    }

    private synchronized List<ByteString> initByteStrings(Function<ByteBuffer, ByteString> f) {
        if (this.byteStrings != null) {
            return this.byteStrings;
        }
        if (this.buffers.isEmpty()) {
            this.byteStrings = Collections.emptyList();
            this.concatenated = ByteString.EMPTY;
            return this.byteStrings;
        }
        ArrayList<ByteString> array = new ArrayList<ByteString>();
        this.concatenated = ChunkBufferToByteStringByByteBufs.convert(this.buffers, array, f);
        this.byteStrings = Collections.unmodifiableList(array);
        return this.byteStrings;
    }

    static ByteString convert(List<ByteBuf> bufs, List<ByteString> byteStrings, Function<ByteBuffer, ByteString> f) {
        ByteString concatenated = ByteString.EMPTY;
        for (ByteBuf buf : bufs) {
            for (ByteBuffer b : buf.nioBuffers()) {
                ByteString s = f.apply(b);
                byteStrings.add(s);
                concatenated = concatenated.concat(s);
            }
        }
        return concatenated;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":n=" + this.buffers.size();
    }
}

