/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.net.NetUtils;

public abstract class NodeDetails {
    private String serviceId;
    private final String nodeId;
    private String hostAddress;
    private int rpcPort;
    private int ratisPort;
    private String httpAddress;
    private String httpsAddress;
    private InetSocketAddress rpcAddress;

    public NodeDetails(String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort, String httpAddress, String httpsAddress) {
        this.serviceId = serviceId;
        this.nodeId = nodeId;
        this.rpcAddress = rpcAddress;
        if (rpcAddress != null) {
            this.hostAddress = rpcAddress.getHostName();
            this.rpcPort = rpcAddress.getPort();
        }
        this.ratisPort = ratisPort;
        this.httpAddress = httpAddress;
        this.httpsAddress = httpsAddress;
    }

    public NodeDetails(String serviceId, String nodeId, String hostAddr, int rpcPort, int ratisPort, String httpAddress, String httpsAddress) {
        this.serviceId = serviceId;
        this.nodeId = nodeId;
        this.hostAddress = hostAddr;
        this.rpcPort = rpcPort;
        this.ratisPort = ratisPort;
        this.httpAddress = httpAddress;
        this.httpsAddress = httpsAddress;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String threadNamePrefix() {
        return HddsUtils.threadNamePrefix(this.nodeId);
    }

    public InetSocketAddress getRpcAddress() {
        if (this.rpcAddress == null) {
            this.rpcAddress = NetUtils.createSocketAddr((String)this.hostAddress, (int)this.rpcPort);
        }
        return this.rpcAddress;
    }

    public boolean isHostUnresolved() {
        return this.getRpcAddress().isUnresolved();
    }

    public InetAddress getInetAddress() {
        return this.getRpcAddress().getAddress();
    }

    public String getHostName() {
        return this.getRpcAddress().getHostName();
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getRatisHostPortStr() {
        StringBuilder hostPort = new StringBuilder();
        hostPort.append(this.getHostName()).append(":").append(this.ratisPort);
        return hostPort.toString();
    }

    public int getRatisPort() {
        return this.ratisPort;
    }

    public String getRpcAddressString() {
        return NetUtils.getHostPortString((InetSocketAddress)this.getRpcAddress());
    }

    public String getHttpAddress() {
        return this.httpAddress;
    }

    public String getHttpsAddress() {
        return this.httpsAddress;
    }
}

