/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.context.WebContextsService;

public class WebBeansConfigurationListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansConfigurationListener.class);
    protected ContainerLifecycle lifeCycle = null;
    protected FailOverService failoverService = null;
    private WebBeansContext webBeansContext = WebBeansContext.getInstance();

    public WebBeansConfigurationListener() {
        this.failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
    }

    public void contextInitialized(ServletContextEvent event) {
        this.lifeCycle = (ContainerLifecycle)this.webBeansContext.getService(ContainerLifecycle.class);
        try {
            this.lifeCycle.startApplication((Object)event);
        }
        catch (Exception e) {
            logger.error("ERROR_0018", new Object[]{event.getServletContext().getContextPath()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.lifeCycle.stopApplication((Object)event);
        this.lifeCycle = null;
        this.cleanupRequestThreadLocals();
    }

    public void requestDestroyed(ServletRequestEvent event) {
        ELContextStore elStore;
        HttpServletRequest httpRequest;
        HttpSession session;
        ServletRequest request;
        if (logger.wblWillLogDebug()) {
            logger.debug("Destroying a request : [{0}]", new Object[]{event.getServletRequest().getRemoteAddr()});
        }
        if (this.failoverService != null && this.failoverService.isSupportFailOver() && (request = event.getServletRequest()) instanceof HttpServletRequest && (session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
            this.failoverService.sessionIsIdle(session);
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        this.lifeCycle.getContextService().endContext(RequestScoped.class, (Object)event);
        this.cleanupRequestThreadLocals();
    }

    private void cleanupRequestThreadLocals() {
        InjectionPointBean.removeThreadLocal();
        WebContextsService.removeThreadLocals();
    }

    public void requestInitialized(ServletRequestEvent event) {
        try {
            if (logger.wblWillLogDebug()) {
                logger.debug("Starting a new request : [{0}]", new Object[]{event.getServletRequest().getRemoteAddr()});
            }
            this.lifeCycle.getContextService().startContext(RequestScoped.class, (Object)event);
        }
        catch (Exception e) {
            logger.error("ERROR_0019", new Object[]{event.getServletRequest()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.wblWillLogDebug()) {
                logger.debug("Starting a session with session id : [{0}]", new Object[]{event.getSession().getId()});
            }
            this.lifeCycle.getContextService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.error("ERROR_0020", new Object[]{event.getSession()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.wblWillLogDebug()) {
            logger.debug("Destroying a session with session id : [{0}]", new Object[]{event.getSession().getId()});
        }
        this.lifeCycle.getContextService().endContext(SessionScoped.class, (Object)event.getSession());
        ConversationManager conversationManager = WebBeansContext.getInstance().getConversationManager();
        conversationManager.destroyConversationContextWithSessionId(event.getSession().getId());
    }
}

