/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.lifecycle;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.corespi.ServiceLoader;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.lifecycle.AbstractLifeCycle;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;

public final class WebContainerLifecycle
extends AbstractLifeCycle {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebContainerLifecycle.class);
    private ScheduledExecutorService service = null;

    public WebContainerLifecycle() {
        super(null, logger);
    }

    public void startApplication(Object startupObject) throws Exception {
        ServletContext servletContext = this.getServletContext(startupObject);
        super.startApplication((Object)servletContext);
    }

    public void stopApplication(Object endObject) {
        ServletContext servletContext = this.getServletContext(endObject);
        super.stopApplication((Object)servletContext);
    }

    protected void afterStartApplication(Object startupObject) throws Exception {
        String strDelay = OpenWebBeansConfiguration.getInstance().getProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", "150000");
        long delay = Long.parseLong(strDelay);
        this.service = Executors.newScheduledThreadPool(1);
        this.service.scheduleWithFixedDelay(new ConversationCleaner(), delay, delay, TimeUnit.MILLISECONDS);
        ELAdaptor elAdaptor = (ELAdaptor)ServiceLoader.getService(ELAdaptor.class);
        ELResolver resolver = elAdaptor.getOwbELResolver();
        ELContextListener elContextListener = elAdaptor.getOwbELContextListener();
        if (OpenWebBeansConfiguration.getInstance().isJspApplication()) {
            logger.debug("Application is configured as JSP. Adding EL Resolver.");
            JspApplicationContext applicationCtx = JspFactory.getDefaultFactory().getJspApplicationContext((ServletContext)startupObject);
            applicationCtx.addELResolver(resolver);
            logger.debug("Application is configured as JSP. Adding EL Listener.");
            applicationCtx.addELContextListener(elContextListener);
        }
        ServletContext servletContext = (ServletContext)startupObject;
        servletContext.setAttribute(BeanManager.class.getName(), (Object)this.getBeanManager());
    }

    protected void beforeStartApplication(Object startupObject) {
        this.scannerService.init(startupObject);
    }

    protected void beforeStopApplication(Object stopObject) throws Exception {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    protected void afterStopApplication(Object stopObject) throws Exception {
        ServletContext servletContext = null;
        servletContext = stopObject instanceof ServletContext ? (ServletContext)stopObject : this.getServletContext(stopObject);
        ResourceInjectionService injectionServices = (ResourceInjectionService)ServiceLoader.getService(ResourceInjectionService.class);
        if (injectionServices != null) {
            injectionServices.clear();
        }
        ContextFactory.cleanUpContextFactory();
        if (logger.wblWillLogInfo()) {
            logger.info("INFO_0002", new Object[]{servletContext != null ? servletContext.getContextPath() : "null"});
        }
    }

    private ServletContext getServletContext(Object object) {
        if (object != null) {
            if (object instanceof ServletContextEvent) {
                object = ((ServletContextEvent)object).getServletContext();
                return (ServletContext)object;
            }
            throw new WebBeansException(logger.getTokenString("EXCEPT_0002"));
        }
        throw new IllegalArgumentException("Must give ServletContext object but found null");
    }

    private static class ConversationCleaner
    implements Runnable {
        @Override
        public void run() {
            ConversationManager.getInstance().destroyWithRespectToTimout();
        }
    }
}

