/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.spi.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class ResourceReference<X, T extends Annotation> {
    private final T annotation;
    private final Class<X> resourceType;
    private final Class<?> ownerClass;
    private final String name;
    private String jndiName;

    public ResourceReference(Class<?> ownerClass, String name, Class<X> resourceType, T annotation) {
        this.resourceType = resourceType;
        this.annotation = annotation;
        this.ownerClass = ownerClass;
        this.name = name;
    }

    public boolean supports(Class<?> resourceAnnoation) {
        return this.annotation.annotationType().equals(resourceAnnoation);
    }

    public <Y extends Annotation> Y getAnnotation(Class<Y> resourceAnnoation) {
        if (this.annotation.annotationType().equals(resourceAnnoation)) {
            return (Y)((Annotation)resourceAnnoation.cast(this.annotation));
        }
        return null;
    }

    public Class<X> getResourceType() {
        return this.resourceType;
    }

    public Class<?> getOwnerClass() {
        return this.ownerClass;
    }

    public String getName() {
        return this.name;
    }

    public String getJndiName() {
        if (this.jndiName == null) {
            this.jndiName = this.getResourceName();
        }
        return this.normalize(this.jndiName);
    }

    private Method getNameMethod(Class cls) {
        try {
            return cls.getMethod("name", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private String getResourceName() {
        String value = null;
        Method nameMethod = this.getNameMethod(this.annotation.getClass());
        if (nameMethod != null) {
            try {
                value = (String)nameMethod.invoke(this.annotation, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value == null || value.equals("")) {
            value = this.ownerClass.getName() + "/" + this.name;
        }
        return value;
    }

    private String normalize(String refName) {
        if (refName.startsWith("java:")) {
            return refName;
        }
        return "java:comp/env/" + refName;
    }
}

