/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.slf4j;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

class Slf4jLogger
extends java.util.logging.Logger {
    private final Logger logger;
    private final LocationAwareLogger locationAwareLogger;

    Slf4jLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.logger = LoggerFactory.getLogger((String)name);
        this.locationAwareLogger = LocationAwareLogger.class.isInstance(this.logger) ? (LocationAwareLogger)LocationAwareLogger.class.cast(this.logger) : null;
    }

    @Override
    public void log(LogRecord record) {
        if (this.isLoggable(record.getLevel())) {
            this.doLog(record);
        }
    }

    @Override
    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            this.doLog(new LogRecord(level, msg));
        }
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setParameters(new Object[]{param1});
            this.doLog(lr);
        }
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(new Object[]{param1});
            this.doLog(lr);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr);
        }
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            this.doLog(lr, bundleName);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(new Object[]{param1});
            this.doLog(lr, bundleName);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setParameters(params);
            this.doLog(lr, bundleName);
        }
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr, bundleName);
        }
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
        }
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", param1);
        }
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (this.isLoggable(Level.FINER)) {
            String msg = "ENTRY";
            if (params == null) {
                this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
                return;
            }
            StringBuilder builder = new StringBuilder("ENTRY");
            for (int i = 0; i < params.length; ++i) {
                builder.append(" {");
                builder.append(i);
                builder.append('}');
            }
            this.logp(Level.FINER, sourceClass, sourceMethod, builder.toString(), params);
        }
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
        }
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (this.isLoggable(Level.FINER)) {
            this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", result);
        }
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.isLoggable(Level.FINER)) {
            LogRecord lr = new LogRecord(Level.FINER, "THROW");
            lr.setSourceClassName(sourceClass);
            lr.setSourceMethodName(sourceMethod);
            lr.setThrown(thrown);
            this.doLog(lr);
        }
    }

    @Override
    public void severe(String msg) {
        if (this.isLoggable(Level.SEVERE)) {
            this.doLog(new LogRecord(Level.SEVERE, msg));
        }
    }

    @Override
    public void warning(String msg) {
        if (this.isLoggable(Level.WARNING)) {
            this.doLog(new LogRecord(Level.WARNING, msg));
        }
    }

    @Override
    public void info(String msg) {
        if (this.isLoggable(Level.INFO)) {
            this.doLog(new LogRecord(Level.INFO, msg));
        }
    }

    @Override
    public void config(String msg) {
        if (this.isLoggable(Level.CONFIG)) {
            this.doLog(new LogRecord(Level.CONFIG, msg));
        }
    }

    @Override
    public void fine(String msg) {
        if (this.isLoggable(Level.FINE)) {
            this.doLog(new LogRecord(Level.FINE, msg));
        }
    }

    @Override
    public void finer(String msg) {
        if (this.isLoggable(Level.FINER)) {
            this.doLog(new LogRecord(Level.FINER, msg));
        }
    }

    @Override
    public void finest(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            this.doLog(new LogRecord(Level.FINEST, msg));
        }
    }

    @Override
    public void setLevel(Level newLevel) {
    }

    private void doLog(LogRecord lr) {
        lr.setLoggerName(this.getName());
        String rbname = this.getResourceBundleName();
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.getResourceBundle());
        }
        this.internalLog(lr);
    }

    private void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.getName());
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(Slf4jLogger.loadResourceBundle(rbname));
        }
        this.internalLog(lr);
    }

    private void internalLog(LogRecord record) {
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(record)) {
            return;
        }
        String msg = this.formatMessage(record);
        this.internalLogFormatted(msg, record);
    }

    private String formatMessage(LogRecord record) {
        ResourceBundle catalog = record.getResourceBundle();
        String format = record.getMessage();
        if (catalog != null) {
            try {
                format = catalog.getString(record.getMessage());
            }
            catch (MissingResourceException ex) {
                format = record.getMessage();
            }
        }
        try {
            Object[] parameters = record.getParameters();
            if (parameters == null || parameters.length == 0) {
                return format;
            }
            if (format.contains("{0") || format.contains("{1") || format.contains("{2") || format.contains("{3")) {
                return MessageFormat.format(format, parameters);
            }
            return format;
        }
        catch (Exception ex) {
            return format;
        }
    }

    private static ResourceBundle loadResourceBundle(String resourceBundleName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null != cl) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), cl);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (null != (cl = ClassLoader.getSystemClassLoader())) {
            try {
                return ResourceBundle.getBundle(resourceBundleName, Locale.getDefault(), cl);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Level getLevel() {
        if (this.logger.isTraceEnabled()) {
            return Level.FINEST;
        }
        if (this.logger.isDebugEnabled()) {
            return Level.FINER;
        }
        if (this.logger.isInfoEnabled()) {
            return Level.INFO;
        }
        if (this.logger.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.logger.isErrorEnabled()) {
            return Level.SEVERE;
        }
        return Level.OFF;
    }

    @Override
    public boolean isLoggable(Level level) {
        int i = level.intValue();
        if (i == Level.OFF.intValue()) {
            return false;
        }
        if (i >= Level.SEVERE.intValue()) {
            return this.logger.isErrorEnabled();
        }
        if (i >= Level.WARNING.intValue()) {
            return this.logger.isWarnEnabled();
        }
        if (i >= Level.INFO.intValue()) {
            return this.logger.isInfoEnabled();
        }
        if (i >= Level.FINER.intValue()) {
            return this.logger.isDebugEnabled();
        }
        return this.logger.isTraceEnabled();
    }

    private void internalLogFormatted(String msg, LogRecord record) {
        Level level = record.getLevel();
        Throwable t = record.getThrown();
        Handler[] targets = this.getHandlers();
        if (targets != null) {
            for (Handler h : targets) {
                h.publish(record);
            }
        }
        if (!this.getUseParentHandlers()) {
            return;
        }
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg, t);
            } else {
                this.locationAwareLogger.log(null, java.util.logging.Logger.class.getName(), 10, msg, null, t);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(msg, t);
            } else {
                this.locationAwareLogger.log(null, java.util.logging.Logger.class.getName(), 20, msg, null, t);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(msg, t);
            } else {
                this.locationAwareLogger.log(null, java.util.logging.Logger.class.getName(), 30, msg, null, t);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg, t);
            } else {
                this.locationAwareLogger.log(null, java.util.logging.Logger.class.getName(), 10, msg, null, t);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg, t);
            } else {
                this.locationAwareLogger.log(null, java.util.logging.Logger.class.getName(), 0, msg, null, t);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg, t);
            } else {
                this.locationAwareLogger.log(null, java.util.logging.Logger.class.getName(), 40, msg, null, t);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg, t);
            } else {
                this.locationAwareLogger.log(null, java.util.logging.Logger.class.getName(), 40, msg, null, t);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg, t);
            } else {
                this.locationAwareLogger.log(null, java.util.logging.Logger.class.getName(), 10, msg, null, t);
            }
        }
    }
}

