/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.osgi.scanner;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.xbean.finder.BundleAssignableClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.ClassDiscoveryFilter;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OsgiMetaDataScannerService
implements ScannerService {
    private WebBeansLogger logger = WebBeansLogger.getLogger(OsgiMetaDataScannerService.class);
    protected ServletContext servletContext = null;
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    private Set<Class<?>> beanClasses = new HashSet();
    private Set<String> beanXMLs = new HashSet<String>();
    private Set<String> beanArchiveJarNames = new HashSet<String>();
    private Map<String, Set<String>> classAnnotations = new HashMap<String, Set<String>>();

    public void init(Object object) {
        if (object instanceof ServletContext) {
            this.servletContext = (ServletContext)object;
        }
    }

    public void release() {
        this.beanClasses = new HashSet();
        this.beanXMLs = new HashSet<String>();
        this.beanArchiveJarNames = new HashSet<String>();
        this.classAnnotations.clear();
    }

    public void scan() throws WebBeansDeploymentException {
        this.logger.info("Using OsgiMetaDataScannerService!");
        Bundle mainBundle = BundleUtils.getContextBundle((boolean)true);
        ServiceReference reference = mainBundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        try {
            PackageAdmin packageAdmin = (PackageAdmin)mainBundle.getBundleContext().getService(reference);
            this.findBeansXml(mainBundle, packageAdmin);
            this.findBeanClasses(mainBundle, packageAdmin);
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException("problem while scanning OSGi bundle", (Throwable)e);
        }
        finally {
            mainBundle.getBundleContext().ungetService(reference);
        }
    }

    private void findBeanClasses(Bundle mainBundle, PackageAdmin packageAdmin) {
        BundleAssignableClassFinder bundleClassFinder = new BundleAssignableClassFinder(packageAdmin, mainBundle, new Class[]{Object.class}, new ClassDiscoveryFilter(){

            public boolean directoryDiscoveryRequired(String directory) {
                return true;
            }

            public boolean jarFileDiscoveryRequired(String jarUrl) {
                boolean isValidBeanArchive = OsgiMetaDataScannerService.this.beanArchiveJarNames.contains(jarUrl);
                return isValidBeanArchive;
            }

            public boolean packageDiscoveryRequired(String packageName) {
                return true;
            }

            public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                return discoveryRange.equals((Object)DiscoveryRange.BUNDLE_CLASSPATH);
            }
        });
        Set acceptedClassNames = bundleClassFinder.find();
        for (String clsName : acceptedClassNames) {
            try {
                Class cls = mainBundle.loadClass(clsName);
                this.classAnnotations.put(clsName, this.collectAnnotations(cls));
                this.beanClasses.add(cls);
            }
            catch (Exception e) {
                this.logger.info("cannot load class from bundle: " + clsName);
            }
        }
    }

    private Set<String> collectAnnotations(Class<?> cls) {
        Method[] methods;
        Field[] fields;
        Constructor<?>[] constructors;
        HashSet<String> annotations = new HashSet<String>();
        this.addAnnotations(annotations, cls.getAnnotations());
        for (Constructor<?> c : constructors = cls.getDeclaredConstructors()) {
            this.addAnnotations(annotations, c.getAnnotations());
        }
        for (Field f : fields = cls.getDeclaredFields()) {
            this.addAnnotations(annotations, f.getAnnotations());
        }
        for (Method m : methods = cls.getDeclaredMethods()) {
            Annotation[][] paramsAnns;
            this.addAnnotations(annotations, m.getAnnotations());
            for (Annotation[] pAnns : paramsAnns = m.getParameterAnnotations()) {
                this.addAnnotations(annotations, pAnns);
            }
        }
        return annotations;
    }

    private void addAnnotations(Set<String> annStrings, Annotation[] annotations) {
        for (Annotation ann : annotations) {
            annStrings.add(ann.getClass().getSimpleName());
        }
    }

    private void findBeansXml(Bundle mainBundle, PackageAdmin packageAdmin) throws Exception {
        BundleResourceFinder brfXmlJar = new BundleResourceFinder(packageAdmin, mainBundle, "", META_INF_BEANS_XML);
        BundleResourceFinder.ResourceFinderCallback rfCallback = new BundleResourceFinder.ResourceFinderCallback(){

            public void foundInDirectory(Bundle bundle, String basePath, URL url) throws Exception {
                OsgiMetaDataScannerService.this.logger.info("adding the following beans.xml URL: " + url);
                OsgiMetaDataScannerService.this.beanXMLs.add(url.toExternalForm());
            }

            public void foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
                URL jarURL = bundle.getEntry(jarName);
                String beansUrlPath = "jar:" + jarURL.toString() + "!/" + entry.getName();
                OsgiMetaDataScannerService.this.logger.info("adding the following beans.xml URL: " + beansUrlPath);
                OsgiMetaDataScannerService.this.beanXMLs.add(beansUrlPath);
                OsgiMetaDataScannerService.this.beanArchiveJarNames.add(jarName);
            }
        };
        brfXmlJar.find(rfCallback);
        Enumeration urls = mainBundle.findEntries("", "beans.xml", true);
        boolean webBeansXmlFound = false;
        while (urls != null && urls.hasMoreElements()) {
            URL webBeansXml = (URL)urls.nextElement();
            if (!webBeansXml.toExternalForm().endsWith("/WEB-INF/beans.xml")) continue;
            if (webBeansXmlFound) {
                throw new WebBeansDeploymentException("found more than WEB-INF/beans.xml file!" + webBeansXml);
            }
            this.logger.info("adding the following WEB-INF/beans.xml URL: " + webBeansXml);
            this.beanXMLs.add(webBeansXml.toExternalForm());
            webBeansXmlFound = true;
        }
    }

    public Set<String> getBeanXmls() {
        return this.beanXMLs;
    }

    public Set<Class<?>> getBeanClasses() {
        return this.beanClasses;
    }

    public Set<String> getAllAnnotations(String className) {
        return this.classAnnotations.get(className);
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return false;
    }
}

