/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jsf;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.BusyConversationException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.NonexistentConversationException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.jsf.JSFUtil;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContextsService;

public class WebBeansPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansPhaseListener.class);
    private Boolean owbApplication = null;
    private WebBeansContext webBeansContext = WebBeansContext.getInstance();
    private ConversationManager conversationManager = this.webBeansContext.getConversationManager();
    private ContextsService contextsService = this.webBeansContext.getContextsService();

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE) || phaseEvent.getFacesContext().getResponseComplete()) {
            if (!this.isOwbApplication()) {
                return;
            }
            ConversationManager conversationManager = this.webBeansContext.getConversationManager();
            Conversation conversation = conversationManager.getConversationBeanReference();
            if (conversation.isTransient()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Destroying the conversation context with cid : [{0}]", conversation.getId());
                }
                this.contextsService.endContext(ConversationScoped.class, null);
            } else {
                ConversationImpl owbConversation = (ConversationImpl)conversation;
                owbConversation.updateTimeOut();
                owbConversation.iDontUseItAnymore();
            }
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW) && this.isOwbApplication()) {
            Conversation conversation = this.conversationManager.getConversationBeanReference();
            String propagation = JSFUtil.getConversationPropagation();
            boolean createNew = "none".equals(propagation);
            if (createNew) {
                this.contextsService.startContext(ConversationScoped.class, this.getRequest(phaseEvent));
            } else if (conversation.isTransient()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Creating a new transitional conversation with cid : [{0}]", conversation.getId());
                }
                this.contextsService.startContext(ConversationScoped.class, this.getRequest(phaseEvent));
                String cid = JSFUtil.getConversationId();
                if (cid != null && !cid.equals("")) {
                    throw new NonexistentConversationException("Propogated conversation with cid=" + cid + " is not restored. It creates a new transient conversation.");
                }
            } else {
                ConversationImpl owbConversation;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Restoring conversation with cid : [{0}]", conversation.getId());
                }
                if ((owbConversation = (ConversationImpl)conversation).iUseIt() > 1) {
                    this.contextsService.startContext(ConversationScoped.class, this.getRequest(phaseEvent));
                    throw new BusyConversationException("Propogated conversation with cid=" + JSFUtil.getConversationId() + " is used by other request. It creates a new transient conversation");
                }
                ConversationContext conversationContext = this.conversationManager.getConversationContext(conversation);
                this.contextsService.startContext(ConversationScoped.class, (Object)conversationContext);
            }
        }
    }

    private Object getRequest(PhaseEvent phaseEvent) {
        ExternalContext externalContext;
        FacesContext facesContext = phaseEvent.getFacesContext();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            return externalContext.getRequest();
        }
        return null;
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private boolean isOwbApplication() {
        if (this.owbApplication == null) {
            this.owbApplication = WebBeansContext.getInstance().getBeanManagerImpl().isInUse();
        }
        return this.owbApplication;
    }
}

