/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.util.Asserts;

public final class JSFUtil {
    private JSFUtil() {
    }

    public static FacesContext getCurrentFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public static ExternalContext getExternalContext() {
        FacesContext context = JSFUtil.getCurrentFacesContext();
        if (context != null) {
            return context.getExternalContext();
        }
        return null;
    }

    public static HttpSession getSession() {
        ExternalContext externalContext = JSFUtil.getExternalContext();
        if (externalContext != null) {
            return (HttpSession)externalContext.getSession(true);
        }
        return null;
    }

    public static boolean isPostBack() {
        return JSFUtil.getCurrentFacesContext().getRenderKit().getResponseStateManager().isPostback(JSFUtil.getCurrentFacesContext());
    }

    public static String getViewId() {
        UIViewRoot viewRoot = JSFUtil.getCurrentFacesContext().getViewRoot();
        if (viewRoot == null) {
            return null;
        }
        return viewRoot.getViewId();
    }

    public static ViewHandler getViewHandler() {
        return JSFUtil.getCurrentFacesContext().getApplication().getViewHandler();
    }

    public static Application getApplication() {
        return JSFUtil.getCurrentFacesContext().getApplication();
    }

    public static void addInfoMessage(String message) {
        FacesMessage fm = new FacesMessage(FacesMessage.SEVERITY_INFO, message, "");
        JSFUtil.getCurrentFacesContext().addMessage(null, fm);
    }

    public static String getRedirectViewIdWithCid(String redirectId, String cid) {
        Asserts.assertNotNull((Object)redirectId, (String)"redirectId parameter can not be null");
        StringBuffer buffer = new StringBuffer(redirectId);
        int index = buffer.lastIndexOf("/");
        String remainder = buffer.substring(index + 1, buffer.length());
        int indexOfQuery = remainder.indexOf(63);
        StringBuffer result = new StringBuffer();
        if (indexOfQuery != -1) {
            result.append(buffer.substring(0, index + 1));
            result.append(remainder.substring(0, indexOfQuery + 1));
            result.append("cid");
            result.append("=");
            result.append(cid);
            result.append("&");
            result.append(remainder.substring(indexOfQuery + 1, remainder.length()));
        } else {
            int pathIndex = remainder.indexOf("#");
            if (pathIndex == -1) {
                result.append(buffer.substring(0, index + 1));
                result.append(remainder.substring(0));
                result.append("?");
                result.append("cid");
                result.append("=");
                result.append(cid);
            } else {
                result.append(buffer.substring(0, index + 1));
                result.append(remainder.substring(0, pathIndex));
                result.append("?");
                result.append("cid");
                result.append("=");
                result.append(cid);
                result.append(remainder.substring(pathIndex, remainder.length()));
            }
        }
        return result.toString();
    }

    public static UIViewRoot getViewRoot() {
        FacesContext context = JSFUtil.getCurrentFacesContext();
        if (context != null) {
            return context.getViewRoot();
        }
        return null;
    }

    public static String getJSFRequestParameter(String parameterName) {
        ExternalContext ec = JSFUtil.getExternalContext();
        if (ec != null) {
            return (String)ec.getRequestParameterMap().get(parameterName);
        }
        return null;
    }

    public static String getConversationId() {
        String cid = JSFUtil.getJSFRequestParameter("cid");
        return cid;
    }
}

