/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jsf;

import javax.enterprise.context.BusyConversationException;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.NonexistentConversationException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.JSFUtil;

public class WebBeansPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansPhaseListener.class);
    private static final ConversationManager conversationManager = ConversationManager.getInstance();

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE) || JSFUtil.getCurrentFacesContext().getResponseComplete()) {
            Conversation conversation = conversationManager.getConversationBeanReference();
            if (conversation.isTransient()) {
                logger.info("INFO_0014", new Object[]{conversation.getId()});
                ContextFactory.destroyConversationContext();
            } else {
                ConversationImpl owbConversation = (ConversationImpl)conversation;
                owbConversation.updateTimeOut();
                owbConversation.setInUsed(false);
            }
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            Conversation conversation = conversationManager.getConversationBeanReference();
            String cid = JSFUtil.getConversationId();
            if (conversation.isTransient()) {
                logger.info("INFO_0016", new Object[]{conversation.getId()});
                ContextFactory.initConversationContext(null);
                if (cid != null && !cid.equals("")) {
                    throw new NonexistentConversationException("Propogated conversation with cid=" + cid + " is not restored. It creates a new transient conversation.");
                }
            } else {
                logger.info("INFO_0015", new Object[]{conversation.getId()});
                ConversationImpl owbConversation = (ConversationImpl)conversation;
                if (!owbConversation.getInUsed().compareAndSet(false, true)) {
                    ContextFactory.initConversationContext(null);
                    throw new BusyConversationException("Propogated conversation with cid=" + cid + " is used by other request. It creates a new transient conversation");
                }
                ConversationContext conversationContext = conversationManager.getConversationContext(conversation);
                ContextFactory.initConversationContext((ConversationContext)conversationContext);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

