/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InterceptionFactory;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.configurator.TrackingAnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.util.WebBeansUtil;

public class InterceptionFactoryImpl<T>
implements InterceptionFactory<T> {
    private final CreationalContextImpl<T> creationalContext;
    private final Set<Annotation> qualifiers;
    private final WebBeansContext context;
    private final AnnotatedType<T> at;
    private TrackingAnnotatedTypeConfiguratorImpl<T> configurator;
    private boolean ignoreFinals;
    private volatile boolean called;

    public InterceptionFactoryImpl(WebBeansContext context, AnnotatedType<T> at, Set<Annotation> qualifiers, CreationalContextImpl<T> cc) {
        this.context = context;
        this.configurator = null;
        this.qualifiers = qualifiers;
        this.creationalContext = cc;
        this.at = at;
    }

    public InterceptionFactory<T> ignoreFinalMethods() {
        this.ignoreFinals = true;
        return this;
    }

    public AnnotatedTypeConfigurator<T> configure() {
        if (this.configurator == null) {
            AnnotatedTypeConfiguratorImpl<T> realConfig = new AnnotatedTypeConfiguratorImpl<T>(this.context, this.at);
            this.configurator = new TrackingAnnotatedTypeConfiguratorImpl<T>(realConfig);
        }
        return this.configurator;
    }

    public T createInterceptedInstance(T originalInstance) {
        this.check();
        ClassLoader classLoader = Optional.ofNullable(originalInstance.getClass().getClassLoader()).orElseGet(WebBeansUtil::getCurrentClassLoader);
        AnnotatedType<T> newAnnotatedType = this.configurator == null ? this.at : this.configurator.getNewAnnotatedType();
        newAnnotatedType.getTypeClosure();
        String passivationId = InterceptionFactory.class.getName() + ">>" + newAnnotatedType + "<<" + this.ignoreFinals;
        if (this.configurator != null) {
            passivationId = passivationId + ">>" + this.configurator.getPassivationId();
        }
        InterceptorResolutionService interceptorResolutionService = this.context.getInterceptorResolutionService();
        InterceptionFactoryCacheEntry cache = this.context.getWebBeansUtil().getInterceptionFactoryCache().computeIfAbsent(passivationId, () -> {
            InterceptorResolutionService.BeanInterceptorInfo interceptorInfo = interceptorResolutionService.calculateInterceptorInfo(newAnnotatedType.getTypeClosure(), this.qualifiers, newAnnotatedType, !this.ignoreFinals);
            InterceptorDecoratorProxyFactory factory = this.context.getInterceptorDecoratorProxyFactory();
            return new InterceptionFactoryCacheEntry(factory.createProxyClass(interceptorInfo, newAnnotatedType, classLoader), interceptorInfo);
        });
        Map<Interceptor<?>, Object> interceptorInstances = interceptorResolutionService.createInterceptorInstances(cache.interceptorInfo, this.creationalContext);
        Map<Method, List<Interceptor<?>>> methodInterceptors = interceptorResolutionService.createMethodInterceptors(cache.interceptorInfo);
        return (T)interceptorResolutionService.createProxiedInstance(originalInstance, this.creationalContext, this.creationalContext, cache.interceptorInfo, cache.proxyClass, methodInterceptors, passivationId, interceptorInstances, c -> false, (a, d) -> d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        boolean ok = false;
        if (!this.called) {
            InterceptionFactoryImpl interceptionFactoryImpl = this;
            synchronized (interceptionFactoryImpl) {
                if (!this.called) {
                    this.called = true;
                    ok = true;
                }
            }
        }
        if (!ok) {
            throw new IllegalStateException("createInterceptedInstance() can be called only once");
        }
    }

    private static class InterceptionFactoryCacheEntry {
        private final Class<?> proxyClass;
        private final InterceptorResolutionService.BeanInterceptorInfo interceptorInfo;

        private InterceptionFactoryCacheEntry(Class<?> proxyClass, InterceptorResolutionService.BeanInterceptorInfo interceptorInfo) {
            this.proxyClass = proxyClass;
            this.interceptorInfo = interceptorInfo;
        }
    }

    public static class InterceptionFactoryCache {
        private final Map<String, InterceptionFactoryCacheEntry> cache = new ConcurrentHashMap<String, InterceptionFactoryCacheEntry>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InterceptionFactoryCacheEntry computeIfAbsent(String interceptionFactoryCacheKey, Supplier<InterceptionFactoryCacheEntry> compute) {
            InterceptionFactoryCacheEntry entry = this.cache.get(interceptionFactoryCacheKey);
            if (entry == null) {
                InterceptionFactoryCache interceptionFactoryCache = this;
                synchronized (interceptionFactoryCache) {
                    entry = this.cache.get(interceptionFactoryCacheKey);
                    if (entry == null) {
                        entry = compute.get();
                        this.cache.putIfAbsent(interceptionFactoryCacheKey, entry);
                    }
                }
            }
            return entry;
        }

        public int size() {
            return this.cache.size();
        }
    }
}

