/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.portable.AbstractAnnotated;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;

public class AnnotatedTypeImpl<X>
extends AbstractAnnotated
implements AnnotatedType<X> {
    private final AnnotatedType<? super X> supertype;
    private final Class<X> annotatedClass;
    private volatile State state;

    AnnotatedTypeImpl(WebBeansContext webBeansContext, Class<X> annotatedClass, AnnotatedType<? super X> supertype) {
        super(webBeansContext, annotatedClass);
        this.supertype = supertype;
        this.annotatedClass = annotatedClass;
        if (supertype == null) {
            this.setAnnotations(annotatedClass.getDeclaredAnnotations());
        } else {
            BeanManagerImpl bm = webBeansContext.getBeanManagerImpl();
            HashSet<Class<? extends Annotation>> annotationTypes = new HashSet<Class<? extends Annotation>>();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            boolean hasScope = false;
            for (Annotation annotation : annotatedClass.getDeclaredAnnotations()) {
                if (bm.isScope(annotation.annotationType())) {
                    hasScope = true;
                }
                annotations.add(annotation);
                annotationTypes.add(annotation.annotationType());
            }
            for (Annotation annotation : supertype.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.isAnnotationPresent(Inherited.class) || annotationTypes.contains(annotationType) || bm.isScope(annotationType) && hasScope) continue;
                annotations.add(annotation);
                annotationTypes.add(annotationType);
            }
            this.setAnnotations(annotations.toArray(new Annotation[annotations.size()]));
        }
    }

    public AnnotatedTypeImpl(WebBeansContext webBeansContext, AnnotatedType otherAnnotatedType) {
        super(webBeansContext, (Annotated)otherAnnotatedType);
        this.annotatedClass = otherAnnotatedType.getJavaClass();
        if (otherAnnotatedType instanceof AnnotatedTypeImpl) {
            AnnotatedTypeImpl annotatedTypeImpl = (AnnotatedTypeImpl)otherAnnotatedType;
            this.supertype = annotatedTypeImpl.supertype;
            if (annotatedTypeImpl.state != null) {
                this.state = new State(annotatedTypeImpl.state);
            }
        } else {
            this.supertype = null;
        }
    }

    public Class<X> getJavaClass() {
        return this.annotatedClass;
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.getState().constructors;
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return this.getState().fields;
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.getState().methods;
    }

    @Override
    protected Class<?> getOwningClass() {
        return this.getJavaClass();
    }

    @Override
    protected Class<?> getDeclaringClass() {
        return this.getJavaClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        Class<?> otherClass = o.getClass();
        if (this.getClass() == otherClass) {
            return false;
        }
        if (AnnotatedType.class.isInstance(o)) {
            return o.equals(this);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State getState() {
        State result = this.state;
        if (result == null) {
            AnnotatedTypeImpl annotatedTypeImpl = this;
            synchronized (annotatedTypeImpl) {
                result = this.state;
                if (result == null) {
                    this.state = result = new State();
                }
            }
        }
        return result;
    }

    private class State {
        private final Set<AnnotatedConstructor<X>> constructors;
        private final Set<AnnotatedField<? super X>> fields;
        private final Set<AnnotatedMethod<? super X>> methods;

        private State() {
            Field[] decFields;
            Constructor constructor;
            Constructor[] decCtxs = AnnotatedTypeImpl.this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredConstructors(AnnotatedTypeImpl.this.annotatedClass);
            HashSet constructors = new HashSet();
            HashSet fields = new HashSet();
            HashSet methods = new HashSet();
            this.constructors = Collections.unmodifiableSet(constructors);
            this.fields = Collections.unmodifiableSet(fields);
            this.methods = Collections.unmodifiableSet(methods);
            for (Constructor ct : decCtxs) {
                if (ct.isSynthetic()) continue;
                AnnotatedConstructorImpl ac = new AnnotatedConstructorImpl(AnnotatedTypeImpl.this.getWebBeansContext(), ct, AnnotatedTypeImpl.this);
                constructors.add(ac);
            }
            if (constructors.isEmpty() && (constructor = AnnotatedTypeImpl.this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredConstructor(AnnotatedTypeImpl.this.annotatedClass, new Class[0])) != null) {
                constructors.add(new AnnotatedConstructorImpl(AnnotatedTypeImpl.this.getWebBeansContext(), constructor, AnnotatedTypeImpl.this));
            }
            for (Field f : decFields = AnnotatedTypeImpl.this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredFields(AnnotatedTypeImpl.this.annotatedClass)) {
                if (f.isSynthetic()) continue;
                AnnotatedFieldImpl af = new AnnotatedFieldImpl(AnnotatedTypeImpl.this.getWebBeansContext(), f, AnnotatedTypeImpl.this);
                fields.add(af);
            }
            Method[] decMethods = AnnotatedTypeImpl.this.getWebBeansContext().getSecurityService().doPrivilegedGetDeclaredMethods(AnnotatedTypeImpl.this.annotatedClass);
            for (Method m : decMethods) {
                if (m.isSynthetic() || m.isBridge()) continue;
                AnnotatedMethodImpl am = new AnnotatedMethodImpl(AnnotatedTypeImpl.this.getWebBeansContext(), m, AnnotatedTypeImpl.this);
                methods.add(am);
            }
            if (AnnotatedTypeImpl.this.supertype != null) {
                for (AnnotatedField field : AnnotatedTypeImpl.this.supertype.getFields()) {
                    fields.add(new AnnotatedFieldImpl(AnnotatedTypeImpl.this.getWebBeansContext(), field.getJavaMember(), AnnotatedTypeImpl.this));
                }
                for (AnnotatedMethod method : AnnotatedTypeImpl.this.supertype.getMethods()) {
                    methods.add(new AnnotatedMethodImpl(AnnotatedTypeImpl.this.getWebBeansContext(), method.getJavaMember(), AnnotatedTypeImpl.this));
                }
            }
        }

        private State(State otherState) {
            this.constructors = otherState.constructors.stream().map(ac -> new AnnotatedConstructorImpl(AnnotatedTypeImpl.this.getWebBeansContext(), ac, AnnotatedTypeImpl.this)).collect(Collectors.toSet());
            this.fields = otherState.fields.stream().map(af -> new AnnotatedFieldImpl(AnnotatedTypeImpl.this.getWebBeansContext(), af.getJavaMember(), AnnotatedTypeImpl.this)).collect(Collectors.toSet());
            this.methods = otherState.methods.stream().map(am -> new AnnotatedMethodImpl(AnnotatedTypeImpl.this.getWebBeansContext(), am, AnnotatedTypeImpl.this)).collect(Collectors.toSet());
        }
    }
}

