/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.service;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.inject.Inject;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.spi.InjectionPointService;
import org.apache.webbeans.util.ClassUtil;

public class DefaultInjectionPointService
implements InjectionPointService {
    private final BeanManagerImpl manager;
    private final boolean implicitSupport;
    private final List<InjectionPointService> delegates;

    public DefaultInjectionPointService(WebBeansContext context) {
        this.manager = context.getBeanManagerImpl();
        this.implicitSupport = Boolean.parseBoolean(context.getOpenWebBeansConfiguration().getProperty(DefaultInjectionPointService.class.getName() + ".implicitSupport"));
        this.delegates = Optional.ofNullable(context.getOpenWebBeansConfiguration().getProperty(DefaultInjectionPointService.class.getName() + ".delegateClasses")).map(Stream::of).orElseGet(Stream::empty).flatMap(it -> Stream.of(it.split(","))).map(String::trim).filter(it -> !it.isEmpty()).map(ClassUtil::getClassFromName).filter(Objects::nonNull).map(context::getService).map(InjectionPointService.class::cast).sorted(Comparator.comparing(it -> Optional.ofNullable(it.getClass().getAnnotation(Priority.class)).map(Priority::value).orElse(Integer.MAX_VALUE))).collect(Collectors.toList());
    }

    public boolean hasInjection(Annotated annotated) {
        if (annotated.isAnnotationPresent(Inject.class)) {
            return true;
        }
        if (!this.implicitSupport) {
            return false;
        }
        if (annotated.getAnnotations().stream().anyMatch(a -> this.manager.isQualifier(a.annotationType())) && annotated.getAnnotations().stream().noneMatch(it -> it.annotationType() == Produces.class)) {
            return true;
        }
        if (this.delegates.isEmpty()) {
            return false;
        }
        return this.delegates.stream().anyMatch(d -> d.hasInjection(annotated));
    }
}

