/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.ContextException;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.spi.ContextsService;

public abstract class AbstractContextsService
implements ContextsService {
    protected final WebBeansContext webBeansContext;
    protected boolean supportsConversation;

    protected AbstractContextsService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.supportsConversation = webBeansContext.getOpenWebBeansConfiguration().supportsConversation();
    }

    public void destroy(Object destroyObject) {
    }

    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
    }

    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        return null;
    }

    public Context getCurrentContext(Class<? extends Annotation> scopeType, boolean createIfNotExists) {
        return this.getCurrentContext(scopeType);
    }

    public void init(Object initializeObject) {
    }

    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
    }

    public void removeThreadLocals() {
    }

    public void setSupportConversations(boolean supportConversations) {
        this.supportsConversation = supportConversations;
    }

    public void destroyOutdatedConversations(ConversationContext currentConversationContext) {
        Set<ConversationContext> conversationContexts;
        ConversationManager conversationManager = null;
        Context sessionContext = this.getCurrentContext(SessionScoped.class, false);
        if (sessionContext != null && sessionContext.isActive() && (conversationContexts = (conversationManager = this.webBeansContext.getConversationManager()).getSessionConversations(sessionContext, false)) != null) {
            Iterator<ConversationContext> convIt = conversationContexts.iterator();
            while (convIt.hasNext()) {
                ConversationContext conversationContext = convIt.next();
                ConversationImpl conv = conversationContext.getConversation();
                if (!conversationManager.conversationTimedOut(conv)) continue;
                conversationManager.destroyConversationContext(conversationContext);
                convIt.remove();
            }
        }
        if (currentConversationContext != null) {
            currentConversationContext.getConversation().iDontUseItAnymore();
            if (currentConversationContext.getConversation().isTransient()) {
                conversationManager = conversationManager != null ? conversationManager : this.webBeansContext.getConversationManager();
                conversationManager.destroyConversationContext(currentConversationContext);
            }
        }
    }

    public boolean isSupportsConversation() {
        return this.supportsConversation;
    }
}

