/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Decorated;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionFactory;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import javax.enterprise.inject.spi.ProcessSyntheticBean;
import javax.enterprise.inject.spi.ProcessSyntheticObserverMethod;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Named;
import javax.interceptor.Interceptor;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.NewLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.BeanManagerBean;
import org.apache.webbeans.component.BeanMetadataBean;
import org.apache.webbeans.component.ConversationBean;
import org.apache.webbeans.component.DecoratorMetadataBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.EventBean;
import org.apache.webbeans.component.EventMetadataBean;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.InstanceBean;
import org.apache.webbeans.component.InterceptedOrDecoratedBeanMetadataBean;
import org.apache.webbeans.component.InterceptionFactoryBean;
import org.apache.webbeans.component.InterceptorMetadataBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewManagedBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.PrincipalBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.ExtensionBeanBuilder;
import org.apache.webbeans.component.creation.ManagedBeanBuilder;
import org.apache.webbeans.component.creation.ObserverMethodsBuilder;
import org.apache.webbeans.component.creation.ProducerFieldBeansBuilder;
import org.apache.webbeans.component.creation.ProducerMethodBeansBuilder;
import org.apache.webbeans.config.OwbParametrizedTypeImpl;
import org.apache.webbeans.config.OwbWildcardTypeImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.AnnotatedTypeWrapper;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.control.RequestContextControllerBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.portable.ProducerFieldProducer;
import org.apache.webbeans.portable.events.ProcessBeanAttributesImpl;
import org.apache.webbeans.portable.events.discovery.ErrorStack;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessBean;
import org.apache.webbeans.portable.events.generics.GProcessBeanAttributes;
import org.apache.webbeans.portable.events.generics.GProcessInjectionPoint;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.portable.events.generics.GProcessManagedBean;
import org.apache.webbeans.portable.events.generics.GProcessObserverMethod;
import org.apache.webbeans.portable.events.generics.GProcessProducer;
import org.apache.webbeans.portable.events.generics.GProcessProducerField;
import org.apache.webbeans.portable.events.generics.GProcessProducerMethod;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.portable.events.generics.GProcessSyntheticAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessSyntheticBean;
import org.apache.webbeans.portable.events.generics.GProcessSyntheticObserverMethod;
import org.apache.webbeans.spi.InjectionPointService;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;

public final class WebBeansUtil {
    private final WebBeansContext webBeansContext;
    private final ConcurrentMap<Type, Boolean> noTypeVariables = new ConcurrentHashMap<Type, Boolean>();
    private final ConcurrentMap<EventCacheKey, Boolean> validEventType = new ConcurrentHashMap<EventCacheKey, Boolean>();
    private final ConcurrentMap<Type, Boolean> notContainerEvents = new ConcurrentHashMap<Type, Boolean>();
    private InstanceBean instanceBean;
    private EventBean eventBean;
    private static final Set<Type> EXTENSION_BEAN_EVENT_TYPES = new HashSet<Class>(Arrays.asList(GProcessAnnotatedType.class, GProcessSyntheticAnnotatedType.class, GProcessInjectionPoint.class, GProcessInjectionTarget.class, GProcessBeanAttributes.class, GProcessManagedBean.class, GProcessSessionBean.class, GProcessBean.class, GProcessSyntheticBean.class));
    private static final Set<Type> DEFAULT_EXTENSION_BEAN_EVENT_TYPE = new HashSet<Class>(Arrays.asList(ProcessAnnotatedType.class, ProcessSyntheticAnnotatedType.class, ProcessInjectionPoint.class, ProcessInjectionTarget.class, ProcessBeanAttributes.class, ProcessManagedBean.class, ProcessBean.class, ProcessSessionBean.class, ProcessSyntheticBean.class));
    private static final Set<Type> EXTENSION_PRODUCER_OR_OBSERVER_EVENT_TYPE = new HashSet<Class>(Arrays.asList(GProcessProducer.class, GProcessProducerField.class, GProcessProducerMethod.class, GProcessObserverMethod.class, GProcessSyntheticObserverMethod.class));
    private static final Set<Type> DEFAULT_EXTENSION_PRODUCER_OR_OBSERVER_EVENT_TYPE = new HashSet<Class>(Arrays.asList(ProcessProducer.class, ProcessProducerField.class, ProcessProducerMethod.class, ProcessObserverMethod.class, ProcessSyntheticObserverMethod.class));
    private static final Class[] CONTAINER_EVENT_CLASSES = new Class[]{AfterBeanDiscovery.class, AfterDeploymentValidation.class, AfterTypeDiscovery.class, BeforeBeanDiscovery.class, BeforeShutdown.class, ProcessAnnotatedType.class, ProcessBean.class, ProcessBeanAttributes.class, ProcessSyntheticBean.class, ProcessInjectionPoint.class, ProcessInjectionTarget.class, ProcessManagedBean.class, ProcessObserverMethod.class, ProcessProducer.class, ProcessProducerField.class, ProcessProducerMethod.class, ProcessSessionBean.class, ProcessSyntheticAnnotatedType.class};
    private static final Set<Class> CONTAINER_EVENT_CLASSES_SET = new HashSet<Class>(Arrays.asList(CONTAINER_EVENT_CLASSES));

    public WebBeansUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.instanceBean = new InstanceBean(webBeansContext);
        this.eventBean = new EventBean(webBeansContext);
    }

    public static ClassLoader getCurrentClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = WebBeansUtil.class.getClassLoader();
        }
        return loader;
    }

    public static void checkGenericType(Class<?> clazz, Class<? extends Annotation> scope) {
        Asserts.assertNotNull(clazz);
        if (clazz.getTypeParameters().length > 0 && !scope.equals(Dependent.class)) {
            throw new WebBeansConfigurationException("Generic type may only defined with scope @Dependent for ManagedBean class : " + clazz.getName());
        }
    }

    public static void checkProducerGenericType(Bean<?> bean, Member member) {
        Type type;
        Asserts.assertNotNull(bean, "Bean");
        if (bean instanceof ProducerMethodBean) {
            type = ((ProducerMethodBean)bean).getCreatorMethod().getGenericReturnType();
        } else if (bean instanceof ProducerFieldBean) {
            type = ((ProducerFieldBean)bean).getCreatorField().getGenericType();
        } else {
            throw new IllegalArgumentException("Bean must be Producer Field or Method Bean instance : " + bean);
        }
        String messageTemplate = "Producer Field/Method Bean with name : %s in bean class : %s";
        String memberName = member.getName();
        String declaringClassName = member.getDeclaringClass().getName();
        if (WebBeansUtil.checkGenericForProducers(type, messageTemplate, memberName, declaringClassName) && !bean.getScope().equals(Dependent.class)) {
            String message = WebBeansUtil.format(messageTemplate, memberName, declaringClassName);
            throw new WebBeansConfigurationException(message + " scope must bee @Dependent");
        }
    }

    private static boolean checkGenericForProducers(Type type, String messageTemplate, Object ... errorMessageArgs) {
        boolean result = false;
        if (type instanceof TypeVariable) {
            String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
            throw new WebBeansConfigurationException(message + " return type can not be type variable");
        }
        if (ClassUtil.isParametrizedType(type)) {
            Type[] actualTypes = ClassUtil.getActualTypeArguments(type);
            if (actualTypes.length == 0) {
                String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
                throw new WebBeansConfigurationException(message + " return type must define actual type arguments or type variable");
            }
            for (Type actualType : actualTypes) {
                if (ClassUtil.isWildCardType(actualType)) {
                    String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
                    throw new WebBeansConfigurationException(message + " return type can not define wildcard actual type argument");
                }
                if (!ClassUtil.isTypeVariable(actualType)) continue;
                result = true;
            }
        }
        return result;
    }

    public void checkManagedBean(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz, "Class is null");
        int modifier = clazz.getModifiers();
        if (!Modifier.isStatic(modifier) && ClassUtil.isInnerClazz(clazz)) {
            throw new WebBeansConfigurationException("Skipping CDI bean detection for non-static inner class: " + clazz.getName());
        }
        if (Extension.class.isAssignableFrom(clazz)) {
            throw new WebBeansConfigurationException("Skipping CDI bean detection for CDI Extension class" + clazz.getName());
        }
        List<OpenWebBeansPlugin> plugins = this.webBeansContext.getPluginLoader().getPlugins();
        for (OpenWebBeansPlugin plugin : plugins) {
            try {
                plugin.isManagedBean(clazz);
            }
            catch (Exception e) {
                PluginLoader.throwsException(e);
            }
        }
    }

    public void checkManagedBeanCondition(Class<?> clazz) throws WebBeansConfigurationException {
        if (AnnotationUtil.hasClassAnnotation(clazz, javax.decorator.Decorator.class) && AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + clazz.getName() + " may not annotated with both @Interceptor and @Decorator annotation");
        }
        if (!AnnotationUtil.hasClassAnnotation(clazz, javax.decorator.Decorator.class) && !AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            this.webBeansContext.getInterceptorUtil().checkSimpleWebBeansInterceptorConditions(clazz);
        }
    }

    public boolean supportsJavaEeComponentInjections(Class<?> clazz) {
        if (clazz.isInterface() || clazz.isAnnotation() || clazz.isEnum()) {
            return false;
        }
        List<OpenWebBeansPlugin> plugins = this.webBeansContext.getPluginLoader().getPlugins();
        for (OpenWebBeansPlugin plugin : plugins) {
            if (!(plugin instanceof OpenWebBeansEjbPlugin)) {
                if (!plugin.supportsJavaEeComponentInjections(clazz)) continue;
                return true;
            }
            return ((OpenWebBeansEjbPlugin)plugin).isSessionBean(clazz);
        }
        return false;
    }

    public boolean isConstructorOk(AnnotatedType<?> annotatedType) throws WebBeansConfigurationException {
        Class clazz = annotatedType.getJavaClass();
        return this.getNoArgConstructor(clazz) != null || this.getInjectedConstructor(annotatedType) != null;
    }

    public <T> AnnotatedConstructor<T> getInjectedConstructor(AnnotatedType<T> type) {
        Set constructors = type.getConstructors();
        if (constructors.isEmpty()) {
            return null;
        }
        for (AnnotatedConstructor constructor : constructors) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return constructor;
        }
        InjectionPointService service = this.webBeansContext.getService(InjectionPointService.class);
        for (AnnotatedConstructor constructor : constructors) {
            if (!constructor.getParameters().stream().anyMatch(arg_0 -> ((InjectionPointService)service).hasInjection(arg_0))) continue;
            return constructor;
        }
        return null;
    }

    public <T> Bean<T> createNewComponent(Class<T> type) {
        Asserts.nullCheckForClass(type);
        OpenWebBeansEjbPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbPlugin();
        if (ejbPlugin != null && ejbPlugin.isNewSessionBean(type)) {
            return ejbPlugin.defineNewSessionBean(type);
        }
        AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(type);
        BeanAttributesImpl<T> defaultBeanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedType).build();
        BeanAttributesImpl newBeanAttributes = new BeanAttributesImpl(defaultBeanAttributes.getTypes(), Collections.singleton(new NewLiteral(type)));
        ManagedBeanBuilder beanBuilder = new ManagedBeanBuilder(this.webBeansContext, annotatedType, newBeanAttributes, false);
        NewManagedBean<T> newBean = new NewManagedBean<T>(this.webBeansContext, WebBeansType.MANAGED, annotatedType, newBeanAttributes, type, ((AbstractOwbBean)beanBuilder.getBean()).getInjectionPoints());
        return newBean;
    }

    public <T> NewManagedBean<T> createNewComponent(OwbBean<T> bean, Class<T> type) {
        Asserts.assertNotNull(bean, "bean");
        if (!EnumSet.of(WebBeansType.MANAGED, WebBeansType.ENTERPRISE, WebBeansType.PRODUCERMETHOD, WebBeansType.PRODUCERFIELD).contains((Object)bean.getWebBeansType())) {
            throw new WebBeansConfigurationException("@New annotation on type : " + bean.getBeanClass() + " must defined as a simple or an enterprise web bean");
        }
        AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(type);
        BeanAttributesImpl newBeanAttributes = new BeanAttributesImpl(bean.getTypes(), Collections.singleton(new NewLiteral(type)));
        NewManagedBean<T> newBean = new NewManagedBean<T>(bean.getWebBeansContext(), bean.getWebBeansType(), annotatedType, newBeanAttributes, type, bean.getInjectionPoints());
        return newBean;
    }

    public <T> ExtensionBean<T> createExtensionComponent(Class<T> clazz) {
        Asserts.nullCheckForClass(clazz);
        ExtensionBeanBuilder<T> extensionBeanBuilder = new ExtensionBeanBuilder<T>(this.webBeansContext, clazz);
        ExtensionBean<T> bean = extensionBeanBuilder.getBean();
        new ObserverMethodsBuilder<T>(this.webBeansContext, extensionBeanBuilder.getAnnotatedType()).defineObserverMethods(bean);
        return bean;
    }

    public BeanManagerBean getManagerBean() {
        return new BeanManagerBean(this.webBeansContext);
    }

    public RequestContextControllerBean getRequestContextControllerBean() {
        return new RequestContextControllerBean(this.webBeansContext);
    }

    public <T> InstanceBean<T> getInstanceBean() {
        return this.instanceBean;
    }

    public <T> EventBean<T> getEventBean() {
        return this.eventBean;
    }

    public EventMetadataBean getEventMetadataBean() {
        return new EventMetadataBean(this.webBeansContext);
    }

    public <T> BeanMetadataBean<T> getBeanMetadataBean() {
        return new BeanMetadataBean(this.webBeansContext);
    }

    public PrincipalBean getPrincipalBean() {
        return new PrincipalBean(this.webBeansContext, Boolean.parseBoolean(this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.component.PrincipalBean.proxy", "true")));
    }

    public <T> InterceptorMetadataBean<T> getInterceptorMetadataBean() {
        return new InterceptorMetadataBean(this.webBeansContext);
    }

    public <T> DecoratorMetadataBean<T> getDecoratorMetadataBean() {
        return new DecoratorMetadataBean(this.webBeansContext);
    }

    public <T> InterceptedOrDecoratedBeanMetadataBean<T> getInterceptedOrDecoratedBeanMetadataBean() {
        return new InterceptedOrDecoratedBeanMetadataBean(this.webBeansContext);
    }

    public ConversationBean getConversationBean() {
        ConversationBean conversationComp = new ConversationBean(this.webBeansContext);
        return conversationComp;
    }

    public InjectionPointBean getInjectionPointBean() {
        return new InjectionPointBean(this.webBeansContext);
    }

    public <T> Constructor<T> getNoArgConstructor(Class<T> clazz) {
        return this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredConstructor(clazz, new Class[0]);
    }

    public static boolean checkObtainsInjectionPointConditions(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        Class<Instance> candidateClazz = ClassUtil.getClass(type);
        if (!candidateClazz.isAssignableFrom(Instance.class) || Object.class == candidateClazz) {
            return false;
        }
        if (ClassUtil.isParametrizedType(injectionPoint.getType())) {
            ParameterizedType pt = (ParameterizedType)injectionPoint.getType();
            Class rawType = (Class)pt.getRawType();
            Type[] typeArgs = pt.getActualTypeArguments();
            if (!rawType.isAssignableFrom(Instance.class)) {
                throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must have type javax.inject.Instance");
            }
            if (typeArgs.length != 1) {
                throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must not have more than one actual type argument");
            }
        } else {
            throw new IllegalArgumentException("<Instance> field injection " + injectionPoint.toString() + " must be defined as ParameterizedType with one actual type argument");
        }
        return true;
    }

    public static void checkNullInstance(Object instance, Class<?> scopeType, String errorMessage, Object ... errorMessageArgs) {
        if (instance == null && !scopeType.equals(Dependent.class)) {
            String message = WebBeansUtil.format(errorMessage, errorMessageArgs);
            throw new IllegalProductException(message);
        }
    }

    public void checkSerializableScopeType(Class<? extends Annotation> scopeType, boolean isSerializable, String errorMessage, Object ... errorMessageArgs) {
        if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(scopeType) && !isSerializable) {
            String message = WebBeansUtil.format(errorMessage, errorMessageArgs);
            throw new IllegalProductException(message);
        }
    }

    public static Bean<?> getMostSpecializedBean(BeanManager manager, Bean<?> component) {
        Set<Bean> beans;
        if (component instanceof EnterpriseBeanMarker) {
            beans = new HashSet();
            Set allBeans = manager.getBeans(Object.class, AnnotationUtil.asArray(component.getQualifiers()));
            for (Bean candidateBean : allBeans) {
                Class candidateSuperClass;
                if (!(candidateBean instanceof EnterpriseBeanMarker) || !(candidateSuperClass = candidateBean.getBeanClass().getSuperclass()).equals(component.getBeanClass())) continue;
                beans.add(candidateBean);
            }
        } else {
            beans = manager.getBeans((Type)component.getBeanClass(), AnnotationUtil.asArray(component.getQualifiers()));
        }
        for (Bean bean : beans) {
            Bean find = bean;
            if (find.equals(component) || !AnnotationUtil.hasClassAnnotation(find.getBeanClass(), Specializes.class)) continue;
            return WebBeansUtil.getMostSpecializedBean(manager, find);
        }
        return component;
    }

    public <T> GProcessAnnotatedType fireProcessAnnotatedTypeEvent(AnnotatedType<T> annotatedType) {
        GProcessAnnotatedType processAnnotatedEvent = new GProcessAnnotatedType(this.webBeansContext, (AnnotatedType)annotatedType);
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processAnnotatedEvent, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        if (processAnnotatedEvent.isModifiedAnnotatedType()) {
            this.webBeansContext.getAnnotatedElementFactory().setAnnotatedType(processAnnotatedEvent.getAnnotatedType());
        }
        return processAnnotatedEvent;
    }

    public <T> GProcessSyntheticAnnotatedType fireProcessSyntheticAnnotatedTypeEvent(AnnotatedType<T> annotatedType) {
        Extension source = AnnotatedTypeWrapper.class.isInstance(annotatedType) ? ((AnnotatedTypeWrapper)AnnotatedTypeWrapper.class.cast(annotatedType)).getSource() : null;
        GProcessSyntheticAnnotatedType gProcessSyntheticAnnotatedType = new GProcessSyntheticAnnotatedType(this.webBeansContext, source, annotatedType);
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)gProcessSyntheticAnnotatedType, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        if (gProcessSyntheticAnnotatedType.isModifiedAnnotatedType()) {
            this.webBeansContext.getAnnotatedElementFactory().setAnnotatedType(gProcessSyntheticAnnotatedType.getAnnotatedType());
        }
        return gProcessSyntheticAnnotatedType;
    }

    public GProcessInjectionPoint fireProcessInjectionPointEvent(InjectionPoint injectionPoint) {
        GProcessInjectionPoint event = new GProcessInjectionPoint(injectionPoint);
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)event, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return event;
    }

    public <T> GProcessInjectionTarget fireProcessInjectionTargetEvent(InjectionTargetImpl<T> injectionTarget, AnnotatedType<T> annotatedType) {
        GProcessInjectionTarget processInjectionTargetEvent = new GProcessInjectionTarget(injectionTarget, annotatedType);
        return this.fireProcessInjectionTargetEvent(processInjectionTargetEvent);
    }

    private GProcessInjectionTarget fireProcessInjectionTargetEvent(GProcessInjectionTarget processInjectionTargetEvent) {
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processInjectionTargetEvent, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return processInjectionTargetEvent;
    }

    public <T> GProcessInjectionTarget fireProcessInjectionTargetEventForJavaEeComponents(Class<T> componentClass) {
        AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(componentClass);
        InjectionTargetImpl injectionTarget = (InjectionTargetImpl)InjectionTargetImpl.class.cast(this.webBeansContext.getBeanManagerImpl().createInjectionTarget(annotatedType));
        GProcessInjectionTarget processInjectionTargetEvent = new GProcessInjectionTarget(injectionTarget, annotatedType);
        return this.fireProcessInjectionTargetEvent(processInjectionTargetEvent);
    }

    public <T> Producer<T> fireProcessProducerEvent(Producer<T> producer, AnnotatedMember<?> annotatedMember) {
        GProcessProducer processProducerEvent = new GProcessProducer((Producer<?>)producer, annotatedMember);
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processProducerEvent, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by ProcessProducer event observers. Look at logs for further details");
        Producer prod = processProducerEvent.getProducer();
        processProducerEvent.setStarted();
        return prod;
    }

    public void fireProcessProducerMethodBeanEvent(Map<ProducerMethodBean<?>, AnnotatedMethod<?>> annotatedMethods, AnnotatedType<?> annotatedType) {
        WebBeansContext webBeansContext = this.webBeansContext;
        AnnotationManager annotationManager = webBeansContext.getAnnotationManager();
        for (Map.Entry<ProducerMethodBean<?>, AnnotatedMethod<?>> beanEntry : annotatedMethods.entrySet()) {
            GProcessProducerMethod processProducerMethodEvent;
            ProducerMethodBean<?> bean = beanEntry.getKey();
            AnnotatedMethod<?> annotatedMethod = beanEntry.getValue();
            Annotation[] annotationsFromSet = AnnotationUtil.asArray(bean.getQualifiers());
            Method disposal = annotationManager.getDisposalWithGivenAnnotatedMethod(annotatedType, bean.getReturnType(), annotationsFromSet);
            if (disposal != null) {
                AnnotatedMethod<?> disposalAnnotated = webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(disposal, annotatedType);
                processProducerMethodEvent = new GProcessProducerMethod(bean, annotatedMethod, (AnnotatedParameter)disposalAnnotated.getParameters().get(0));
            } else {
                processProducerMethodEvent = new GProcessProducerMethod(bean, annotatedMethod, null);
            }
            webBeansContext.getBeanManagerImpl().fireEvent((Object)processProducerMethodEvent, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
            processProducerMethodEvent.setStarted();
        }
    }

    public void fireProcessProducerFieldBeanEvent(Map<ProducerFieldBean<?>, AnnotatedField<?>> annotatedFields) {
        for (Map.Entry<ProducerFieldBean<?>, AnnotatedField<?>> beanEntry : annotatedFields.entrySet()) {
            ProducerFieldProducer fieldProducer;
            AnnotatedMethod dm;
            ProducerFieldBean<?> bean = beanEntry.getKey();
            AnnotatedField<?> field = beanEntry.getValue();
            Producer producer = bean.getProducer();
            AnnotatedParameter param = null;
            if (ProducerFieldProducer.class.isInstance(producer) && (dm = (fieldProducer = (ProducerFieldProducer)ProducerFieldProducer.class.cast(producer)).getDisposerMethod()) != null && dm.getParameters() != null && !dm.getParameters().isEmpty()) {
                param = (AnnotatedParameter)dm.getParameters().iterator().next();
            }
            GProcessProducerField processProducerFieldEvent = new GProcessProducerField(bean, field, (AnnotatedParameter<?>)param);
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processProducerFieldEvent, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
            processProducerFieldEvent.setStarted();
        }
    }

    public static void checkInjectionPointNamedQualifier(InjectionPoint injectionPoint) {
        Member member;
        String value;
        Set qualifierset = injectionPoint.getQualifiers();
        Named namedQualifier = null;
        for (Annotation qualifier : qualifierset) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            namedQualifier = (Named)qualifier;
            break;
        }
        if (namedQualifier != null && ((value = namedQualifier.value()) == null || value.isEmpty()) && !((member = injectionPoint.getMember()) instanceof Field)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " can not define @Named qualifier without value!");
        }
    }

    public void setInjectionTargetBeanEnableFlag(InjectionTargetBean<?> bean) {
        bean.setEnabled(this.isBeanEnabled(bean.getAnnotatedType(), bean.getStereotypes()));
    }

    public boolean isBeanEnabled(BeanAttributes<?> beanAttributes, AnnotatedType<?> at, Set<Class<? extends Annotation>> stereotypes) {
        boolean isAlternative = beanAttributes.isAlternative();
        return !isAlternative || this.isBeanEnabled(at, stereotypes);
    }

    public boolean isBeanEnabled(AnnotatedType<?> at, Set<Class<? extends Annotation>> stereotypes) {
        boolean isAlternative = WebBeansUtil.isAlternative(at, stereotypes);
        if (!isAlternative) {
            return true;
        }
        AlternativesManager alternativesManager = this.webBeansContext.getAlternativesManager();
        if (alternativesManager.isAlternative(at.getJavaClass(), stereotypes)) {
            return true;
        }
        if (stereotypes != null && !stereotypes.isEmpty() && at.getAnnotation(Priority.class) != null) {
            for (Class<? extends Annotation> stereotype : stereotypes) {
                if (!alternativesManager.isAlternativeStereotype(stereotype)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAlternative(Annotated annotated, Set<Class<? extends Annotation>> stereotypes) {
        Asserts.assertNotNull(annotated, "annotated");
        Asserts.assertNotNull(stereotypes, "stereotypes");
        boolean alternative = false;
        if (annotated.getAnnotation(Alternative.class) != null) {
            alternative = true;
        }
        if (!alternative) {
            for (Class<? extends Annotation> stereoType : stereotypes) {
                if (!AnnotationUtil.hasClassAnnotation(stereoType, Alternative.class)) continue;
                alternative = true;
                break;
            }
        }
        return alternative;
    }

    public void setBeanEnableFlagForProducerBean(InjectionTargetBean<?> parent, AbstractProducerBean<?> producer, Annotation[] annotations) {
        Asserts.assertNotNull(parent, "parent");
        Asserts.assertNotNull(producer, "producer");
        Set<Class<? extends Annotation>> stereotypes = producer.getStereotypes();
        boolean alternative = false;
        if (parent.getAnnotatedType().getAnnotation(Priority.class) == null) {
            if (AnnotationUtil.hasAnnotation(annotations, Alternative.class)) {
                alternative = true;
            }
            if (!alternative) {
                for (Class<Annotation> clazz : stereotypes) {
                    if (!AnnotationUtil.hasClassAnnotation(clazz, Alternative.class)) continue;
                    alternative = true;
                    break;
                }
            }
        }
        if (alternative) {
            producer.setEnabled(WebBeansUtil.isAlternative(parent.getAnnotatedType(), parent.getStereotypes()) && this.webBeansContext.getAlternativesManager().isAlternative(parent) || WebBeansUtil.isAlternative(parent.getAnnotatedType(), stereotypes) && this.webBeansContext.getAlternativesManager().isAlternative(producer));
        } else {
            producer.setEnabled(parent.isEnabled());
        }
    }

    public static boolean isExtensionBeanEventType(Type type) {
        return EXTENSION_BEAN_EVENT_TYPES.contains(type);
    }

    public static boolean isDefaultExtensionBeanEventType(Class<?> clazz) {
        return DEFAULT_EXTENSION_BEAN_EVENT_TYPE.contains(clazz);
    }

    public static boolean isExtensionProducerOrObserverEventType(Type type) {
        return EXTENSION_PRODUCER_OR_OBSERVER_EVENT_TYPE.contains(type);
    }

    public static boolean isDefaultExtensionProducerOrObserverEventType(Class<?> clazz) {
        return DEFAULT_EXTENSION_PRODUCER_OR_OBSERVER_EVENT_TYPE.contains(clazz);
    }

    public static boolean isDependent(Bean<?> bean) {
        if (!(bean instanceof OwbBean)) {
            return bean.getScope().equals(Dependent.class);
        }
        return ((OwbBean)bean).isDependent();
    }

    public void inspectDefinitionErrorStack(String logMessage) {
        ErrorStack stack = this.webBeansContext.getBeanManagerImpl().getErrorStack();
        try {
            if (stack.hasErrors()) {
                stack.logErrors();
                if (stack.iterator().next() instanceof DeploymentException) {
                    throw new WebBeansDeploymentException(logMessage);
                }
                throw new WebBeansConfigurationException(logMessage);
            }
        }
        finally {
            stack.clear();
        }
    }

    public void inspectDeploymentErrorStack(String logMessage) {
        ErrorStack stack = this.webBeansContext.getBeanManagerImpl().getErrorStack();
        try {
            if (stack.hasErrors()) {
                stack.logErrors();
                if (stack.iterator().next() instanceof DefinitionException) {
                    throw new WebBeansConfigurationException(logMessage);
                }
                throw new WebBeansDeploymentException(logMessage);
            }
        }
        finally {
            stack.clear();
        }
    }

    public static String getPassivationId(Contextual<?> contextual) {
        if (contextual instanceof Bean) {
            if (contextual instanceof AbstractOwbBean) {
                if (((AbstractOwbBean)contextual).isPassivationCapable()) {
                    return ((AbstractOwbBean)contextual).getId();
                }
            } else if (contextual instanceof PassivationCapable) {
                PassivationCapable pc = (PassivationCapable)contextual;
                return pc.getId();
            }
        } else if (contextual instanceof PassivationCapable && contextual instanceof Serializable) {
            PassivationCapable pc = (PassivationCapable)contextual;
            return pc.getId();
        }
        return null;
    }

    public <T> ManagedBean<T> defineManagedBeanWithoutFireEvents(AnnotatedType<T> type) {
        BeanAttributesImpl<T> beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(type).build();
        ManagedBeanBuilder managedBeanCreator = new ManagedBeanBuilder(this.webBeansContext, type, beanAttributes, false);
        this.setInjectionTargetBeanEnableFlag((InjectionTargetBean<?>)managedBeanCreator.getBean());
        Object managedBean = managedBeanCreator.getBean();
        new ProducerMethodBeansBuilder(((AbstractOwbBean)managedBean).getWebBeansContext(), ((InjectionTargetBean)managedBean).getAnnotatedType()).defineProducerMethods(managedBean, new ProducerFieldBeansBuilder(((AbstractOwbBean)managedBean).getWebBeansContext(), ((InjectionTargetBean)managedBean).getAnnotatedType()).defineProducerFields(managedBean));
        new ObserverMethodsBuilder(this.webBeansContext, ((InjectionTargetBean)managedBean).getAnnotatedType()).defineObserverMethods(managedBean);
        if (((InjectionTargetBean)managedBean).getProducer() instanceof AbstractProducer) {
            AbstractProducer producer = (AbstractProducer)((InjectionTargetBean)managedBean).getProducer();
            producer.defineInterceptorStack(managedBean, ((InjectionTargetBean)managedBean).getAnnotatedType(), this.webBeansContext);
        }
        return managedBean;
    }

    public boolean isPassivationCapableDependency(InjectionPoint injectionPoint) {
        if (injectionPoint.isDelegate()) {
            return true;
        }
        InjectionResolver instance = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
        Bean<?> bean = instance.getInjectionPointBean(injectionPoint);
        if (bean instanceof EnterpriseBeanMarker || bean instanceof ResourceBean || bean instanceof InstanceBean || bean instanceof EventBean || bean instanceof InjectionPointBean || bean instanceof BeanManagerBean) {
            return true;
        }
        if (this.webBeansContext.getBeanManagerImpl().isNormalScope(bean.getScope())) {
            return true;
        }
        return WebBeansUtil.getPassivationId(bean) != null;
    }

    public static void throwRuntimeExceptions(Exception e) {
        if (RuntimeException.class.isAssignableFrom(e.getClass())) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static boolean isDecorator(AnnotatedType<?> annotatedType) {
        return annotatedType.isAnnotationPresent(javax.decorator.Decorator.class);
    }

    public boolean isAnnotatedTypeDecoratorOrInterceptor(AnnotatedType<?> annotatedType) {
        if (WebBeansUtil.isDecorator(annotatedType) || WebBeansUtil.isCdiInterceptor(annotatedType)) {
            return true;
        }
        if (this.webBeansContext.getInterceptorsManager().isInterceptorClassEnabled(annotatedType.getJavaClass())) {
            return true;
        }
        return this.webBeansContext.getDecoratorsManager().isDecoratorEnabled(annotatedType.getJavaClass());
    }

    public static boolean isCdiInterceptor(AnnotatedType<?> annotatedType) {
        return annotatedType.isAnnotationPresent(Interceptor.class);
    }

    public <X> void checkManagedBeanCondition(AnnotatedType<X> type) throws WebBeansConfigurationException {
        int modifier = type.getJavaClass().getModifiers();
        if (type.isAnnotationPresent(javax.decorator.Decorator.class) && type.isAnnotationPresent(Interceptor.class)) {
            throw new WebBeansConfigurationException("Annotated type " + type + " may not annotated with both @Interceptor and @Decorator annotation");
        }
        if (!type.isAnnotationPresent(javax.decorator.Decorator.class) && !type.isAnnotationPresent(Interceptor.class)) {
            this.checkManagedWebBeansInterceptorConditions(type);
        }
        if (Modifier.isInterface(modifier)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + type.getJavaClass().getName() + " may not defined as interface");
        }
    }

    private <X> void checkManagedWebBeansInterceptorConditions(AnnotatedType<X> type) {
        Annotation[] anns = AnnotationUtil.asArray(type.getAnnotations());
        Class clazz = type.getJavaClass();
        boolean hasClassInterceptors = false;
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        if (annotationManager.getInterceptorBindingMetaAnnotations(anns).length > 0) {
            hasClassInterceptors = true;
        } else {
            Annotation[] stereoTypes = annotationManager.getStereotypeMetaAnnotations(anns);
            for (Annotation stero : stereoTypes) {
                if (!annotationManager.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                hasClassInterceptors = true;
                break;
            }
        }
        if (Modifier.isFinal(clazz.getModifiers()) && hasClassInterceptors) {
            throw new WebBeansDeploymentException("Final managed bean class with name : " + clazz.getName() + " can not define any InterceptorBindings");
        }
        Set<AnnotatedMethod<X>> methods = this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(type);
        for (AnnotatedMethod annotatedMethod : methods) {
            Method method = annotatedMethod.getJavaMember();
            int modifiers = method.getModifiers();
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || !Modifier.isFinal(modifiers)) continue;
            if (hasClassInterceptors) {
                throw new WebBeansDeploymentException("Managed bean class : " + clazz.getName() + " can not define non-static, non-private final methods. Because it is annotated with at least one @InterceptorBinding");
            }
            if (!annotationManager.hasInterceptorBindingMetaAnnotation(AnnotationUtil.asArray(annotatedMethod.getAnnotations()))) continue;
            throw new WebBeansDeploymentException("Method : " + method.getName() + "in managed bean class : " + clazz.getName() + " can not be defined as non-static, non-private and final . Because it is annotated with at least one @InterceptorBinding");
        }
    }

    private static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public void validate(Set<InjectionPoint> injectionPoints, Bean<?> bean) {
        boolean isDecorator = false;
        boolean isInterceptor = false;
        if (bean != null) {
            isInterceptor = bean instanceof javax.enterprise.inject.spi.Interceptor;
            isDecorator = !isInterceptor && bean instanceof Decorator;
        }
        boolean delegateFound = false;
        for (InjectionPoint injectionPoint : injectionPoints) {
            if (injectionPoint.getAnnotated().isAnnotationPresent(Decorated.class)) {
                this.validateDecorated(bean, isDecorator, injectionPoint);
            } else if (injectionPoint.getAnnotated().isAnnotationPresent(Intercepted.class)) {
                this.validateIntercepted(bean, isInterceptor, injectionPoint);
            } else {
                List<Method> abstractMethods;
                Class<?> rawType = ClassUtil.getRawTypeForInjectionPoint(injectionPoint);
                if (rawType.equals(Decorator.class) || isDecorator && rawType.equals(Bean.class) || rawType.equals(javax.enterprise.inject.spi.Interceptor.class)) {
                    Type[] types = ClassUtil.getActualTypeArguments(injectionPoint.getType());
                    if (types.length != 1 || !GenericsUtil.isAssignableFrom(false, AbstractProducerBean.class.isInstance(bean), bean.getBeanClass(), types[0], new HashMap<Type, Integer>())) {
                        throw new WebBeansConfigurationException("injected bean parameter must be " + rawType);
                    }
                } else if (InterceptionFactory.class == rawType) {
                    if (!ParameterizedType.class.isInstance(injectionPoint.getType())) {
                        throw new WebBeansConfigurationException("No type specified for the interception factory, ensure to paramterize it");
                    }
                    ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(injectionPoint.getType());
                    if (pt.getActualTypeArguments() == null || pt.getActualTypeArguments().length != 1) {
                        throw new WebBeansConfigurationException("No explicit type specified for the interception factory");
                    }
                    Type type = pt.getActualTypeArguments()[0];
                    if (!Class.class.isInstance(type)) {
                        throw new WebBeansConfigurationException("InterceptionFactory only works with Class, no generics");
                    }
                }
                if (isDecorator && !(abstractMethods = ClassUtil.getAbstractMethods(bean.getBeanClass())).isEmpty()) {
                    Set types = ((Decorator)bean).getDecoratedTypes();
                    for (Method abstractMethod : abstractMethods) {
                        boolean methodDeclared = false;
                        for (Type type : types) {
                            if (!ClassUtil.isMethodDeclared(ClassUtil.getClass(type), abstractMethod.getName(), abstractMethod.getParameterTypes())) continue;
                            methodDeclared = true;
                            break;
                        }
                        if (methodDeclared) continue;
                        throw new WebBeansConfigurationException("Decorator must not declare abstract methods which is not declared in any Decorated type.");
                    }
                }
            }
            if (!injectionPoint.isDelegate()) {
                this.webBeansContext.getBeanManagerImpl().validate(injectionPoint);
            } else {
                if (!isDecorator) {
                    throw new WebBeansConfigurationException("Delegate injection points can not defined by beans that are not decorator. Injection point : " + injectionPoint);
                }
                if (delegateFound) {
                    throw new WebBeansConfigurationException("Only one Delegate injection point can be defined by decorator. Decorator : " + injectionPoint.getBean());
                }
                delegateFound = true;
            }
            if (injectionPoint.getQualifiers().contains((Object)DefaultLiteral.INSTANCE) && ParameterizedType.class.isInstance(injectionPoint.getType()) && Decorator.class == ((ParameterizedType)ParameterizedType.class.cast(injectionPoint.getType())).getRawType() && !isDecorator) {
                throw new WebBeansConfigurationException("@Inject Decorator<X> only supported in decorators");
            }
            if (!injectionPoint.getQualifiers().contains((Object)DefaultLiteral.INSTANCE) || !ParameterizedType.class.isInstance(injectionPoint.getType()) || javax.enterprise.inject.spi.Interceptor.class != ((ParameterizedType)ParameterizedType.class.cast(injectionPoint.getType())).getRawType() || isInterceptor) continue;
            throw new WebBeansConfigurationException("@Inject Interceptor<X> only supported in interceptors");
        }
    }

    public void checkTypeVariables(TypeLiteral<?> subtype) {
        Type t = subtype.getType();
        Boolean result = (Boolean)this.noTypeVariables.get(t);
        if (result != null) {
            if (!result.booleanValue()) {
                throw new IllegalArgumentException(t + " has a TypeVariable which is forbidden");
            }
            return;
        }
        if (ParameterizedType.class.isInstance(t)) {
            for (Type arg : ((ParameterizedType)ParameterizedType.class.cast(t)).getActualTypeArguments()) {
                if (!TypeVariable.class.isInstance(arg)) continue;
                this.noTypeVariables.putIfAbsent(t, false);
                throw new IllegalArgumentException(arg + " is a TypeVariable which is forbidden");
            }
        }
        this.noTypeVariables.putIfAbsent(t, true);
    }

    public void validEventType(Type eventType, Type metadataType) {
        Type et;
        EventCacheKey key = new EventCacheKey(eventType, metadataType);
        if (this.validEventType.containsKey(key)) {
            return;
        }
        if (GenericsUtil.hasTypeParameters(eventType) && OwbParametrizedTypeImpl.class.isInstance(et = GenericsUtil.resolveType(GenericsUtil.getParameterizedType(eventType), metadataType))) {
            for (Type t : ((OwbParametrizedTypeImpl)OwbParametrizedTypeImpl.class.cast(et)).getActualTypeArguments()) {
                if (!OwbWildcardTypeImpl.class.isInstance(t)) continue;
                throw new IllegalArgumentException("TypeVariable forbidden for events");
            }
        }
        this.validEventType.putIfAbsent(key, true);
    }

    public boolean isContainerEventType(Class<?> type) {
        return CONTAINER_EVENT_CLASSES_SET.contains(type);
    }

    public boolean isContainerEventType(Object event) {
        if (event == null) {
            return false;
        }
        Class<?> eventType = event.getClass();
        if (this.notContainerEvents.containsKey(eventType)) {
            return false;
        }
        for (Class eventClass : CONTAINER_EVENT_CLASSES) {
            if (!eventClass.isInstance(event)) continue;
            return true;
        }
        this.notContainerEvents.putIfAbsent(eventType, true);
        return false;
    }

    public <T> ProcessBeanAttributesImpl<T> fireProcessBeanAttributes(Annotated annotatedType, Class<?> type, BeanAttributes<T> ba) {
        GProcessBeanAttributes event = new GProcessBeanAttributes(this.webBeansContext, type, annotatedType, ba);
        try {
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)event, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
        catch (Exception e) {
            throw new WebBeansConfigurationException("event ProcessBeanAttributes thrown an exception for " + annotatedType, e);
        }
        if (event.getDefinitionError() != null) {
            throw new WebBeansConfigurationException(event.getDefinitionError());
        }
        if (event.getAttributes() != ba) {
            BeanAttributes beanAttributes = event.getAttributes();
            if (!this.webBeansContext.getBeanManagerImpl().isScope(beanAttributes.getScope())) {
                throw new WebBeansConfigurationException(beanAttributes.getScope() + " is not a scope");
            }
        }
        event.setStarted();
        if (event.isVeto()) {
            return null;
        }
        return event;
    }

    public void validateBeanInjection(Bean<?> bean) {
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            Type type = injectionPoint.getType();
            if (!(type instanceof ParameterizedType)) continue;
            Bean injectionPointBean = injectionPoint.getBean();
            ParameterizedType pt = (ParameterizedType)type;
            if (pt.getRawType() != Bean.class) continue;
            Class beanClass = AbstractOwbBean.class.isInstance(injectionPointBean) ? ((AbstractOwbBean)AbstractOwbBean.class.cast(injectionPointBean)).getReturnType() : injectionPointBean.getBeanClass();
            Type beanType = pt.getActualTypeArguments()[0];
            if (GenericsUtil.isAssignableFrom(false, AbstractProducerBean.class.isInstance(bean), beanClass, beanType, new HashMap<Type, Integer>())) continue;
            throw new WebBeansConfigurationException("@Inject Bean<X> can only be done in X, found " + beanType + " and " + beanClass);
        }
    }

    private void validateDecorated(Bean<?> bean, boolean isDecorator, InjectionPoint injectionPoint) {
        if (isDecorator) {
            Type[] types = ClassUtil.getActualTypeArguments(injectionPoint.getType());
            if (types.length != 1 || !((Decorator)bean).getDecoratedTypes().contains(types[0])) {
                throw new WebBeansConfigurationException("ParametrizedType must be a DecoratedTyp at InjectionPoint " + injectionPoint);
            }
        } else {
            throw new WebBeansConfigurationException(injectionPoint.getBean().getBeanClass() + " must be a Decorator");
        }
    }

    private void validateIntercepted(Bean<?> bean, boolean isInterceptor, InjectionPoint injectionPoint) {
        if (isInterceptor) {
            Type[] types = ClassUtil.getActualTypeArguments(injectionPoint.getType());
            if (types.length != 1 || !ClassUtil.isWildCardType(types[0]) || ((WildcardType)types[0]).getLowerBounds().length > 0 || ((WildcardType)types[0]).getUpperBounds().length != 1 || !Object.class.equals((Object)((WildcardType)types[0]).getUpperBounds()[0])) {
                throw new WebBeansConfigurationException("Type parameter for interceptor " + bean.getBeanClass() + " must be an unbound wildcard");
            }
        } else {
            throw new WebBeansConfigurationException(bean.getBeanClass() + " must be an Interceptor");
        }
    }

    public InterceptionFactoryBean getInterceptionFactoryBean() {
        return new InterceptionFactoryBean(this.webBeansContext);
    }

    private static final class EventCacheKey {
        private final Type event;
        private final Type metadata;
        private final int hashCache;

        private EventCacheKey(Type event, Type metadata) {
            this.event = event;
            this.metadata = metadata;
            int result = event != null ? event.hashCode() : 0;
            this.hashCache = result = 31 * result + (metadata != null ? metadata.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || EventCacheKey.class != o.getClass()) {
                return false;
            }
            EventCacheKey that = (EventCacheKey)EventCacheKey.class.cast(o);
            if (this.event != null ? !this.event.equals(that.event) : that.event != null) {
                return false;
            }
            return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
        }

        public int hashCode() {
            return this.hashCache;
        }
    }
}

