/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.instance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Provider;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtil;
import org.apache.webbeans.util.OwbCustomObjectInputStream;
import org.apache.webbeans.util.WebBeansUtil;

public class InstanceImpl<T>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -8401944412490389024L;
    private Type injectionClazz;
    private InjectionPoint injectionPoint;
    private Set<Annotation> qualifierAnnotations = new HashSet<Annotation>();
    private WebBeansContext webBeansContext;
    private Map<Object, CreationalContextImpl<?>> creationalContexts;
    private CreationalContextImpl<?> parentCreationalContext;

    public InstanceImpl(Type injectionClazz, InjectionPoint injectionPoint, WebBeansContext webBeansContext, CreationalContextImpl<?> creationalContext, Annotation ... annotations) {
        this.injectionClazz = injectionClazz;
        this.injectionPoint = injectionPoint;
        this.parentCreationalContext = creationalContext;
        for (Annotation ann : annotations) {
            this.qualifierAnnotations.add(ann);
        }
        this.webBeansContext = webBeansContext;
    }

    public T get() {
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        Set beans = this.resolveBeans();
        Bean bean = this.webBeansContext.getBeanManagerImpl().resolve(beans);
        if (bean == null) {
            InjectionExceptionUtil.throwUnsatisfiedResolutionException(ClassUtil.getClazz(this.injectionClazz), this.injectionPoint, anns);
        }
        return this.create(bean);
    }

    private Set<Bean<?>> resolveBeans() {
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        InjectionResolver injectionResolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
        Bean injectionPointBean = this.injectionPoint != null ? this.injectionPoint.getBean() : null;
        Class injectionPointClass = null;
        if (injectionPointBean != null) {
            injectionPointClass = injectionPointBean.getBeanClass();
        }
        Set beans = injectionResolver.implResolveByType(false, this.injectionClazz, injectionPointClass, anns);
        return injectionResolver.resolveAll(beans);
    }

    public boolean isAmbiguous() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() > 1;
    }

    public boolean isUnsatisfied() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() == 0;
    }

    public Instance<T> select(Annotation ... qualifiers) {
        Annotation[] newQualifiersArray = this.getAdditionalQualifiers(qualifiers);
        return new InstanceImpl<T>(this.injectionClazz, this.injectionPoint, this.webBeansContext, this.parentCreationalContext, newQualifiersArray);
    }

    private Annotation[] getAdditionalQualifiers(Annotation[] qualifiers) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.qualifierAnnotations);
        if (qualifiers != null && qualifiers.length > 0) {
            for (int i = 0; i < qualifiers.length; ++i) {
                newQualifiers.add(qualifiers[i]);
            }
        }
        Annotation[] newQualifiersArray = new Annotation[newQualifiers.size()];
        newQualifiersArray = newQualifiers.toArray(newQualifiersArray);
        return newQualifiersArray;
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(qualifiers);
        Type sub = subtype;
        if (sub == null) {
            sub = this.injectionClazz;
        }
        Annotation[] newQualifiers = this.getAdditionalQualifiers(qualifiers);
        return new InstanceImpl<T>(sub, this.injectionPoint, this.webBeansContext, this.parentCreationalContext, newQualifiers);
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.select(subtype.getRawType(), qualifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<T> iterator() {
        Set<Bean<?>> beans = this.resolveBeans();
        ArrayList<T> instances = new ArrayList<T>();
        this.parentCreationalContext.putInjectionPoint(this.injectionPoint);
        try {
            for (Bean<?> bean : beans) {
                T instance = this.create(bean);
                instances.add(instance);
            }
        }
        finally {
            this.parentCreationalContext.removeInjectionPoint();
        }
        return instances.iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy(T instance) {
        if (instance == null) {
            throw new NullPointerException("instance is null, can't be destroyed");
        }
        if (instance instanceof OwbNormalScopeProxy) {
            OwbNormalScopeProxy proxy = (OwbNormalScopeProxy)instance;
            Provider provider = this.webBeansContext.getNormalScopeProxyFactory().getInstanceProvider(proxy);
            NormalScopedBeanInterceptorHandler handler = (NormalScopedBeanInterceptorHandler)provider;
            Bean<?> bean = handler.getBean();
            CreationalContextImpl<?> creationalContext = this.parentCreationalContext;
            Class beanScope = bean.getScope();
            Context currentContext = this.webBeansContext.getBeanManagerImpl().getContext(beanScope);
            if (!(currentContext instanceof AlterableContext)) throw new UnsupportedOperationException("Not AlterableContext so you can't call destroy youself");
            AlterableContext alterableContext = (AlterableContext)currentContext;
            alterableContext.destroy(bean);
            return;
        } else {
            CreationalContextImpl<?> creationalContext = this.creationalContexts.remove(instance);
            if (creationalContext == null) {
                throw new IllegalArgumentException("instance " + instance + " not produced with this Instance<?>");
            }
            creationalContext.destroyDependent(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T create(Bean<?> bean) {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        creationalContext.putInjectionPoint(this.injectionPoint);
        try {
            Object reference = beanManager.getReference(bean, this.injectionClazz, creationalContext);
            if (this.creationalContexts == null) {
                this.creationalContexts = new IdentityHashMap();
            }
            this.creationalContexts.put(reference, (CreationalContextImpl<?>)creationalContext);
            if (WebBeansUtil.isDependent(bean)) {
                this.parentCreationalContext.addDependent(bean, reference);
            }
            Object object = reference;
            return (T)object;
        }
        finally {
            creationalContext.removeInjectionPoint();
        }
    }

    private void writeObject(ObjectOutputStream op) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(op);
        oos.writeObject(this.injectionClazz);
        oos.writeObject(this.qualifierAnnotations);
        oos.writeObject(this.injectionPoint);
        oos.flush();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.webBeansContext = WebBeansContext.currentInstance();
        OwbCustomObjectInputStream inputStream = new OwbCustomObjectInputStream(in, WebBeansUtil.getCurrentClassLoader());
        this.injectionClazz = (Type)inputStream.readObject();
        this.qualifierAnnotations = (Set)inputStream.readObject();
        this.injectionPoint = (InjectionPoint)inputStream.readObject();
        this.parentCreationalContext = this.webBeansContext.getBeanManagerImpl().createCreationalContext((Contextual)null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Instance<");
        builder.append(ClassUtil.getClazz(this.injectionClazz).getName());
        builder.append("> injectionPointClazz=").append(this.injectionPoint);
        builder.append(",with qualifier annotations {");
        boolean i = false;
        for (Annotation qualifier : this.qualifierAnnotations) {
            if (i) {
                builder.append(",");
            }
            builder.append(((Object)qualifier).toString());
        }
        builder.append("}");
        return builder.toString();
    }
}

