/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public abstract class AbstractOwbBean<T>
extends BeanAttributesImpl<T>
implements OwbBean<T>,
PassivationCapable {
    protected Logger logger = null;
    protected WebBeansType webBeansType;
    private final Class<?> beanClass;
    protected boolean specializedBean;
    protected boolean enabled = true;
    protected Boolean isAlternative = null;
    protected String passivatingId = null;
    protected final WebBeansContext webBeansContext;
    private Boolean isPassivationCapable = null;

    protected AbstractOwbBean(WebBeansContext webBeansContext, WebBeansType webBeansType, BeanAttributes<T> beanAttributes, Class<?> beanClass, boolean nullable) {
        super(beanAttributes, nullable);
        this.webBeansType = webBeansType;
        this.beanClass = beanClass;
        this.webBeansContext = webBeansContext;
    }

    @Override
    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public T create(CreationalContext<T> creationalContext) {
        try {
            if (!(creationalContext instanceof CreationalContextImpl)) {
                creationalContext = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(creationalContext, this);
            }
            Producer producer = this.getProducer();
            Object instance = producer.produce(creationalContext);
            if (producer instanceof InjectionTarget && instance != null) {
                InjectionTarget injectionTarget = (InjectionTarget)producer;
                injectionTarget.inject(instance, creationalContext);
                injectionTarget.postConstruct(instance);
            }
            if (this.getScope().equals(Dependent.class) && instance != null) {
                ((CreationalContextImpl)creationalContext).addDependent(this, instance);
            }
            return (T)instance;
        }
        catch (Exception re) {
            Throwable throwable = this.getRootException(re);
            if (!(throwable instanceof RuntimeException)) {
                throw new CreationException(throwable);
            }
            throw (RuntimeException)throwable;
        }
    }

    private Throwable getRootException(Throwable throwable) {
        if (throwable.getCause() == null || throwable.getCause() == throwable) {
            return throwable;
        }
        return this.getRootException(throwable.getCause());
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (this.getScope().equals(Dependent.class) && creationalContext instanceof CreationalContextImpl && ((CreationalContextImpl)creationalContext).containsDependent((Contextual<?>)this, instance)) {
            creationalContext.release();
            return;
        }
        try {
            Producer producer = this.getProducer();
            if (producer instanceof InjectionTarget) {
                InjectionTarget injectionTarget = (InjectionTarget)producer;
                injectionTarget.preDestroy(instance);
            }
            producer.dispose(instance);
            creationalContext.release();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("FATAL_0001", this), e);
        }
    }

    @Override
    public String getId() {
        if (!this.isEnabled() || this.getReturnType().equals(Object.class)) {
            return null;
        }
        if (this.passivatingId == null) {
            this.passivatingId = this.providedId();
            if (this.passivatingId == null) {
                StringBuilder sb = new StringBuilder(this.webBeansType.toString()).append('#');
                sb.append(this.getReturnType()).append('#');
                for (Annotation qualifier : this.getQualifiers()) {
                    sb.append(((Object)qualifier).toString()).append(',');
                }
                this.passivatingId = sb.toString();
            }
        }
        return this.passivatingId;
    }

    protected String providedId() {
        return null;
    }

    @Override
    public boolean isPassivationCapable() {
        if (this.isPassivationCapable != null) {
            return this.isPassivationCapable;
        }
        if (Serializable.class.isAssignableFrom(this.getReturnType())) {
            this.isPassivationCapable = Boolean.TRUE;
            return true;
        }
        this.isPassivationCapable = Boolean.FALSE;
        return false;
    }

    @Override
    public WebBeansType getWebBeansType() {
        return this.webBeansType;
    }

    @Override
    public Class<T> getReturnType() {
        return this.getBeanClass();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.getProducer().getInjectionPoints();
    }

    @Override
    public void setSpecializedBean(boolean specialized) {
        this.specializedBean = specialized;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    public boolean isAlternative() {
        if (this.isAlternative == null) {
            this.isAlternative = this.webBeansContext.getAlternativesManager().isAlternative(this.getBeanClass(), this.getStereotypes());
        }
        return this.isAlternative;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String simpleName = this.getReturnType().getSimpleName();
        builder.append(simpleName);
        builder.append(", WebBeansType:").append((Object)this.getWebBeansType()).append(", Name:").append(this.getName());
        builder.append(", API Types:[");
        int size = this.getTypes().size();
        int index = 1;
        for (Type clazz : this.getTypes()) {
            if (clazz instanceof Class) {
                builder.append(((Class)clazz).getName());
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)clazz;
                Class rawType = (Class)parameterizedType.getRawType();
                builder.append(rawType.getName());
                builder.append("<");
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length > 0) {
                    for (Type actualType : actualTypeArguments) {
                        if (Class.class.isInstance(actualType)) {
                            builder.append(((Class)Class.class.cast(actualType)).getName().replace("java.lang.", ""));
                        } else {
                            builder.append(actualType);
                        }
                        builder.append(",");
                    }
                }
                builder.delete(builder.length() - 1, builder.length());
                builder.append(">");
            }
            if (index < size) {
                builder.append(",");
            }
            ++index;
        }
        builder.append("], ");
        builder.append("Qualifiers:[");
        size = this.getQualifiers().size();
        index = 1;
        for (Annotation ann : this.getQualifiers()) {
            builder.append(ann.annotationType().getName());
            if (index < size) {
                builder.append(",");
            }
            ++index;
        }
        builder.append("]");
        return builder.toString();
    }

    protected synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = WebBeansLoggerFacade.getLogger(this.getClass());
        }
        return this.logger;
    }

    @Override
    public boolean isDependent() {
        return this.getScope().equals(Dependent.class);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SerializableBean && ((SerializableBean)o).getBean().equals(this);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

