/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.events.generics.GProcessBean;
import org.apache.webbeans.portable.events.generics.GProcessObservableMethod;
import org.apache.webbeans.util.AnnotationUtil;

public class AfterBeanDiscoveryImpl
implements AfterBeanDiscovery {
    private BeanManagerImpl beanManager = null;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(AfterBeanDiscoveryImpl.class);
    private final WebBeansContext webBeansContext;
    private Object extension;
    private boolean started;

    public AfterBeanDiscoveryImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
    }

    public void setStarted() {
        this.started = true;
    }

    public void addBean(Bean<?> bean) {
        if (this.started) {
            throw new IllegalStateException("Don't call AfterBeanDiscovery.addBean(bean) after the event is fired");
        }
        AnnotatedType annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(bean.getBeanClass());
        GProcessBean processBeanEvent = new GProcessBean(bean, annotatedType);
        this.beanManager.fireEvent((Object)processBeanEvent, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        if (bean instanceof Interceptor) {
            this.webBeansContext.getWebBeansUtil().defineManagedBeanWithoutFireEvents(annotatedType);
            Interceptor interceptor = (Interceptor)bean;
            if (interceptor.getScope() != Dependent.class && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_1", interceptor.getBeanClass().getName());
            }
            if (interceptor.getName() != null && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_2", interceptor.getBeanClass().getName());
            }
            if (interceptor.isAlternative() && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_3", interceptor.getBeanClass().getName());
            }
            InterceptorsManager interceptorsManager = this.webBeansContext.getInterceptorsManager();
            interceptorsManager.addCdiInterceptor(interceptor);
            interceptorsManager.addCustomInterceptorClass(bean.getBeanClass());
        } else if (bean instanceof Decorator) {
            ManagedBean managedBean = this.webBeansContext.getWebBeansUtil().defineManagedBeanWithoutFireEvents(annotatedType);
            if (managedBean.getScope() != Dependent.class && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_1", managedBean.getBeanClass().getName());
            }
            if (managedBean.getName() != null && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_2", managedBean.getBeanClass().getName());
            }
            if (managedBean.isAlternative() && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_3", managedBean.getBeanClass().getName());
            }
            boolean found = false;
            for (InjectionPoint ip : bean.getInjectionPoints()) {
                if (!ip.isDelegate()) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new WebBeansConfigurationException("Decorators must have a one @Delegate injection point. But the decorator bean : " + managedBean.toString() + " has more than one");
            }
            this.webBeansContext.getDecoratorsManager().addDecorator((Decorator)bean);
            this.webBeansContext.getDecoratorsManager().addCustomDecoratorClass(bean.getBeanClass());
        } else {
            this.beanManager.addBean(bean);
        }
    }

    public void addContext(Context context) {
        if (this.started) {
            throw new IllegalStateException("Don't call AfterBeanDiscovery.addContext(...) after the event is fired");
        }
        this.beanManager.addContext(context);
    }

    public void addDefinitionError(Throwable t) {
        if (this.started) {
            throw new IllegalStateException("Don't call AfterBeanDiscovery.addBean(bean) after the event is fired");
        }
        this.beanManager.getErrorStack().pushError(t);
    }

    public void addObserverMethod(ObserverMethod<?> observerMethod) {
        if (this.started) {
            throw new IllegalStateException("Don't call AfterBeanDiscovery.addObserverMethod(...) after the event is fired");
        }
        GProcessObservableMethod event = new GProcessObservableMethod(null, observerMethod);
        this.beanManager.fireEvent((Object)event, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        this.beanManager.getNotificationManager().addObserver(observerMethod, observerMethod.getObservedType());
    }

    public <T> AnnotatedType<T> getAnnotatedType(Class<T> type, String id) {
        if (this.started) {
            throw new IllegalStateException("Don't call AfterBeanDiscovery.getAnnotatedType(...) after the event is fired");
        }
        return this.beanManager.getAdditionalAnnotatedType(type, id);
    }

    public <T> Iterable<AnnotatedType<T>> getAnnotatedTypes(Class<T> type) {
        if (this.started) {
            throw new IllegalStateException("Don't call AfterBeanDiscovery.getAnnotatedTypes(...) after the event is fired");
        }
        return this.beanManager.getAnnotatedTypes(type);
    }

    public void setExtension(Object extension) {
        this.extension = extension;
    }
}

