/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;
import org.apache.webbeans.portable.AnnotatedTypeImpl;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public final class AnnotatedElementFactory {
    public static final String OWB_DEFAULT_KEY = "OWB_DEFAULT_KEY";
    private static final Logger logger = WebBeansLoggerFacade.getLogger(AnnotatedElementFactory.class);
    private ConcurrentMap<Class<?>, ConcurrentMap<String, AnnotatedType<?>>> annotatedTypeCache = new ConcurrentHashMap();
    private ConcurrentMap<Class<?>, ConcurrentMap<String, AnnotatedType<?>>> modifiedAnnotatedTypeCache = new ConcurrentHashMap();
    private ConcurrentMap<Constructor<?>, AnnotatedConstructor<?>> annotatedConstructorCache = new ConcurrentHashMap();
    private ConcurrentMap<Method, AnnotatedMethod<?>> annotatedMethodCache = new ConcurrentHashMap();
    private ConcurrentMap<Field, AnnotatedField<?>> annotatedFieldCache = new ConcurrentHashMap();
    private ConcurrentMap<AnnotatedType<?>, Set<AnnotatedMethod<?>>> annotatedMethodsOfTypeCache = new ConcurrentHashMap();
    private WebBeansContext webBeansContext;

    public AnnotatedElementFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public <X> AnnotatedType<X> getAnnotatedType(Class<X> annotatedClass) {
        AnnotatedType annotatedType;
        ConcurrentMap modifiedAnnotatedClasses = (ConcurrentMap)this.modifiedAnnotatedTypeCache.get(annotatedClass);
        if (modifiedAnnotatedClasses != null && (annotatedType = (AnnotatedType)modifiedAnnotatedClasses.get(OWB_DEFAULT_KEY)) != null) {
            return annotatedType;
        }
        return (AnnotatedType)this.getAnnotatedTypeCache(annotatedClass).get(OWB_DEFAULT_KEY);
    }

    public <X> Iterable<AnnotatedType<X>> getAnnotatedTypes(Class<X> annotatedClass) {
        return this.getAnnotatedTypeCache(annotatedClass).values();
    }

    public <X> AnnotatedType<X> setAnnotatedType(AnnotatedType<X> annotatedType) {
        return this.setAnnotatedType(annotatedType, OWB_DEFAULT_KEY);
    }

    public <X> AnnotatedType<X> setAnnotatedType(AnnotatedType<X> annotatedType, String id) {
        ConcurrentMap oldAnnotatedTypes;
        Class type = annotatedType.getJavaClass();
        ConcurrentMap<String, Object> annotatedTypes = (ConcurrentHashMap<String, AnnotatedType<X>>)this.modifiedAnnotatedTypeCache.get(type);
        if (annotatedTypes == null) {
            annotatedTypes = new ConcurrentHashMap<String, AnnotatedType<X>>();
        }
        if ((oldAnnotatedTypes = (ConcurrentMap)this.modifiedAnnotatedTypeCache.putIfAbsent(type, annotatedTypes)) != null) {
            annotatedTypes = oldAnnotatedTypes;
        }
        return annotatedTypes.put(id, annotatedType);
    }

    public <X> AnnotatedType<X> newAnnotatedType(Class<X> annotatedClass) {
        Asserts.assertNotNull(annotatedClass, "annotatedClass is null");
        ConcurrentMap<String, AnnotatedType<X>> annotatedTypes = this.getAnnotatedTypeCache(annotatedClass);
        AnnotatedType annotatedType = (AnnotatedType)annotatedTypes.get(OWB_DEFAULT_KEY);
        if (annotatedType == null) {
            try {
                AnnotatedType oldType;
                AnnotatedType<X> supertype = null;
                if (annotatedClass.getSuperclass() != null && !annotatedClass.getSuperclass().equals(Object.class)) {
                    supertype = this.newAnnotatedType(annotatedClass.getSuperclass());
                }
                if ((oldType = (AnnotatedType)annotatedTypes.putIfAbsent(OWB_DEFAULT_KEY, annotatedType = new AnnotatedTypeImpl(this.webBeansContext, annotatedClass, supertype))) != null) {
                    annotatedType = oldType;
                }
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException || e instanceof ArrayStoreException) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0027", annotatedClass.getName(), e.getCause()), e);
                    }
                    annotatedType = null;
                }
                throw new RuntimeException(e);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0027", annotatedClass.getName(), ncdfe.getCause()), ncdfe);
                }
                annotatedType = null;
            }
        }
        return annotatedType;
    }

    public <X> AnnotatedConstructor<X> newAnnotatedConstructor(Constructor<X> constructor, AnnotatedType<X> declaringClass) {
        AnnotatedConstructorImpl<X> annConstructor;
        Asserts.assertNotNull(constructor, "constructor is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        if (this.annotatedConstructorCache.containsKey(constructor)) {
            annConstructor = (AnnotatedConstructorImpl<X>)this.annotatedConstructorCache.get(constructor);
        } else {
            annConstructor = new AnnotatedConstructorImpl<X>(this.webBeansContext, constructor, declaringClass);
            AnnotatedConstructorImpl<X> old = this.annotatedConstructorCache.putIfAbsent(constructor, annConstructor);
            if (old != null) {
                annConstructor = old;
            }
        }
        return annConstructor;
    }

    public <X> AnnotatedField<X> newAnnotatedField(Field field, AnnotatedType<X> declaringClass) {
        AnnotatedFieldImpl<X> annotField;
        Asserts.assertNotNull(field, "field is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        if (this.annotatedFieldCache.containsKey(field)) {
            annotField = (AnnotatedFieldImpl<X>)this.annotatedFieldCache.get(field);
        } else {
            annotField = new AnnotatedFieldImpl<X>(this.webBeansContext, field, declaringClass);
            AnnotatedFieldImpl<X> old = this.annotatedFieldCache.putIfAbsent(field, annotField);
            if (old != null) {
                annotField = old;
            }
        }
        return annotField;
    }

    public <X> AnnotatedMethod<X> newAnnotatedMethod(Method method, AnnotatedType<X> declaringType) {
        AnnotatedMethodImpl<X> annotMethod;
        Asserts.assertNotNull(method, "method is null");
        Asserts.assertNotNull(declaringType, "declaringType is null");
        if (this.annotatedMethodCache.containsKey(method)) {
            annotMethod = (AnnotatedMethodImpl<X>)this.annotatedMethodCache.get(method);
        } else {
            annotMethod = new AnnotatedMethodImpl<X>(this.webBeansContext, method, declaringType);
            AnnotatedMethodImpl<X> old = this.annotatedMethodCache.putIfAbsent(method, annotMethod);
            if (old != null) {
                annotMethod = old;
            }
        }
        return annotMethod;
    }

    public <T> Set<AnnotatedMethod<? super T>> getFilteredAnnotatedMethods(AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(annotatedType, "annotatedType is null");
        Set<? extends AnnotatedMethod<?>> methods = (Set<? extends AnnotatedMethod<?>>)this.annotatedMethodsOfTypeCache.get(annotatedType);
        if (methods != null) {
            return this.cast(methods);
        }
        methods = Collections.unmodifiableSet(this.getFilteredMethods(annotatedType.getJavaClass(), annotatedType.getMethods(), new HashSet()));
        Set<? extends AnnotatedMethod<?>> old = this.annotatedMethodsOfTypeCache.putIfAbsent(annotatedType, methods);
        if (old != null) {
            return this.cast(old);
        }
        return this.cast(methods);
    }

    private <T> Set<AnnotatedMethod<? super T>> cast(Set<AnnotatedMethod<?>> methods) {
        return methods;
    }

    public void clear() {
        this.modifiedAnnotatedTypeCache.clear();
        this.annotatedTypeCache.clear();
        this.annotatedConstructorCache.clear();
        this.annotatedFieldCache.clear();
        this.annotatedMethodCache.clear();
        this.annotatedMethodsOfTypeCache.clear();
    }

    private Set<? extends AnnotatedMethod<?>> getFilteredMethods(Class<?> type, Set<AnnotatedMethod<?>> allMethods, Set<AnnotatedMethod<?>> filteredMethods) {
        if (type == null) {
            return filteredMethods;
        }
        for (AnnotatedMethod<?> annotatedMethod : allMethods) {
            if (annotatedMethod.getJavaMember().getDeclaringClass() != type || this.isOverridden(annotatedMethod, filteredMethods)) continue;
            filteredMethods.add(annotatedMethod);
        }
        return this.getFilteredMethods(type.getSuperclass(), allMethods, filteredMethods);
    }

    private boolean isOverridden(AnnotatedMethod<?> superclassMethod, Set<AnnotatedMethod<?>> methods) {
        for (AnnotatedMethod<?> subclassMethod : methods) {
            if (!ClassUtil.isOverridden(subclassMethod.getJavaMember(), superclassMethod.getJavaMember())) continue;
            return true;
        }
        return false;
    }

    private <T> ConcurrentMap<String, AnnotatedType<T>> getAnnotatedTypeCache(Class<T> type) {
        ConcurrentMap oldAnnotatedTypes;
        ConcurrentMap annotatedTypes = (ConcurrentHashMap)this.annotatedTypeCache.get(type);
        if (annotatedTypes == null && (oldAnnotatedTypes = (ConcurrentMap)this.annotatedTypeCache.putIfAbsent(type, annotatedTypes = new ConcurrentHashMap())) != null) {
            annotatedTypes = oldAnnotatedTypes;
        }
        return annotatedTypes;
    }
}

