/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.scanner;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.scanner.xbean.CdiArchive;
import org.apache.webbeans.corespi.scanner.xbean.OwbAnnotationFinder;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.UrlSet;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassLoaders;

public abstract class AbstractMetaDataDiscovery
implements ScannerService {
    protected static final Logger logger = WebBeansLoggerFacade.getLogger(AbstractMetaDataDiscovery.class);
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private BeanArchiveService beanArchiveService;
    private final UrlSet beanArchiveLocations = new UrlSet();
    private final Map<String, URL> beanDeploymentUrls = new HashMap<String, URL>();
    protected ClassLoader loader;
    protected CdiArchive archive;
    protected OwbAnnotationFinder finder;
    protected boolean isBDAScannerEnabled = false;
    protected BDABeansXmlScanner bdaBeansXmlScanner;
    protected final WebBeansContext webBeansContext = WebBeansContext.getInstance();

    protected AbstractMetaDataDiscovery() {
    }

    protected AnnotationFinder initFinder() {
        if (this.finder != null) {
            return this.finder;
        }
        if (this.beanArchiveService == null) {
            this.beanArchiveService = this.webBeansContext.getBeanArchiveService();
        }
        this.archive = new CdiArchive(this.beanArchiveService, WebBeansUtil.getCurrentClassLoader(), this.getBeanDeploymentUrls());
        this.finder = new OwbAnnotationFinder(this.archive);
        return this.finder;
    }

    protected Iterable<URL> getBeanArchiveUrls() {
        return this.beanArchiveLocations;
    }

    public Map<String, URL> getBeanDeploymentUrls() {
        return this.beanDeploymentUrls;
    }

    public void scan() throws WebBeansDeploymentException {
        try {
            this.configure();
            this.initFinder();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
    }

    protected abstract void configure();

    protected void registerBeanArchives(ClassLoader loader) {
        this.loader = loader;
        try {
            Set classPathUrls = ClassLoaders.findUrls((ClassLoader)loader);
            Enumeration<URL> beansXmlUrls = loader.getResources(META_INF_BEANS_XML);
            block2: while (beansXmlUrls.hasMoreElements()) {
                URL beansXmlUrl = beansXmlUrls.nextElement();
                this.addWebBeansXmlLocation(beansXmlUrl);
                String beansXml = beansXmlUrl.toExternalForm();
                beansXml = this.stripProtocol(beansXml);
                Iterator cpIt = classPathUrls.iterator();
                while (cpIt.hasNext()) {
                    URL cpUrl = (URL)cpIt.next();
                    if (!beansXml.startsWith(this.stripProtocol(cpUrl.toExternalForm()))) continue;
                    cpIt.remove();
                    this.addDeploymentUrl(beansXml, cpUrl);
                    continue block2;
                }
            }
            this.filterExcludedJars(classPathUrls);
            for (URL url : classPathUrls) {
                if (!this.isBdaUrlEnabled(url)) continue;
                this.addWebBeansXmlLocation(url);
                this.addDeploymentUrl(url.toExternalForm(), url);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String stripProtocol(String urlPath) {
        int pos = urlPath.lastIndexOf(":/");
        if (pos > 0) {
            return urlPath.substring(pos + 1);
        }
        return urlPath;
    }

    protected void filterExcludedJars(Set<URL> classPathUrls) {
        Iterator<URL> it = classPathUrls.iterator();
        while (it.hasNext()) {
            URL url = it.next();
            String path = url.toExternalForm();
            int knownJarIdx = this.isKnownJar(path);
            if (knownJarIdx <= 0 || knownJarIdx >= path.indexOf(".jar")) continue;
            it.remove();
        }
    }

    private int isKnownJar(String path) {
        for (String p : Arrays.asList("/jre/lib", "/Contents/Home/", "/dt.jar", "/tools.jar", "/asm", "/javassist", "/xbean-", "/jconsole.jar", "/geronimo-", "/commons-", "/arquillian-", "/bsh-", "/shrinkwrap-", "/junit-", "/testng-", "/openjpa-", "/bcel", "/hamcrest", "/mysql-connector", "/testng", "/idea_rt", "/eclipse", "/jcommander", "/tomcat", "/catalina", "/jasper", "/jsp-api", "/myfaces-", "/servlet-api", "/javax", "/annotation-api", "/el-api", "/mojarra", "/sisu-guice-", "/sisu-inject-", "/aether-", "/plexus-", "/openwebbeans-")) {
            int i = path.indexOf(p);
            if (i <= 0) continue;
            return i;
        }
        return -1;
    }

    public void release() {
        this.finder = null;
        this.archive = null;
        this.loader = null;
    }

    protected void addDeploymentUrl(String beansXml, URL cpUrl) {
        this.beanDeploymentUrls.put(beansXml, cpUrl);
    }

    protected boolean isBdaUrlEnabled(URL bdaUrl) {
        return true;
    }

    public void init(Object object) {
        String usage = WebBeansContext.currentInstance().getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.useBDABeansXMLScanner");
        this.isBDAScannerEnabled = Boolean.parseBoolean(usage);
    }

    protected void addWebBeansXmlLocation(URL beanArchiveUrl) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("added beans archive URL: " + beanArchiveUrl.toExternalForm());
        }
        this.beanArchiveLocations.add(beanArchiveUrl);
        if (this.beanArchiveService == null) {
            this.beanArchiveService = this.webBeansContext.getBeanArchiveService();
        }
        this.beanArchiveService.getBeanArchiveInformation(beanArchiveUrl);
    }

    public Set<Class<?>> getBeanClasses() {
        HashSet classSet = new HashSet();
        for (CdiArchive.FoundClasses foundClasses : this.archive.classesByUrl().values()) {
            boolean scanModeAnnotated = BeanArchiveService.BeanDiscoveryMode.ANNOTATED.equals((Object)foundClasses.getBeanArchiveInfo().getBeanDiscoveryMode());
            for (String className : foundClasses.getClassNames()) {
                try {
                    Class<?> clazz;
                    AnnotationFinder.ClassInfo classInfo;
                    if (scanModeAnnotated && ((classInfo = this.finder.getClassInfo(className)) == null || !this.isBeanAnnotatedClass(classInfo)) || (clazz = ClassUtil.getClassFromName(className)) == null) continue;
                    clazz.getDeclaredFields();
                    clazz.getDeclaredMethods();
                    classSet.add(clazz);
                }
                catch (NoClassDefFoundError e) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, "WARN_0018", new Object[]{className, e.toString()});
                }
            }
        }
        return classSet;
    }

    protected boolean isBeanAnnotatedClass(AnnotationFinder.ClassInfo classInfo) {
        for (AnnotationFinder.AnnotationInfo annotationInfo : classInfo.getAnnotations()) {
            if (!this.isBeanAnnotation(annotationInfo)) continue;
            return true;
        }
        return false;
    }

    protected boolean isBeanAnnotation(AnnotationFinder.AnnotationInfo annotationInfo) {
        String annotationName = annotationInfo.getName();
        try {
            Class<?> annotationType = WebBeansUtil.getCurrentClassLoader().loadClass(annotationName);
            boolean isBeanAnnotation = this.webBeansContext.getBeanManagerImpl().isScope(annotationType);
            isBeanAnnotation = isBeanAnnotation || this.webBeansContext.getBeanManagerImpl().isStereotype(annotationType);
            return isBeanAnnotation;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Set<URL> getBeanXmls() {
        return Collections.unmodifiableSet(this.beanArchiveLocations);
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return this.bdaBeansXmlScanner;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.isBDAScannerEnabled;
    }
}

