/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.DeploymentValidationService;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.SerializableBeanVault;
import org.apache.webbeans.context.creational.CreationalContextFactory;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.proxy.SubclassProxyFactory;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.ApplicationBoundaryService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class WebBeansContext {
    private final Map<Class<?>, Object> managerMap = new HashMap();
    private final Map<Class<?>, Object> serviceMap = new HashMap();
    private final WebBeansUtil webBeansUtil = new WebBeansUtil(this);
    private final AlternativesManager alternativesManager = new AlternativesManager(this);
    private final AnnotatedElementFactory annotatedElementFactory = new AnnotatedElementFactory(this);
    private final BeanManagerImpl beanManagerImpl = new BeanManagerImpl(this);
    private final ConversationManager conversationManager = new ConversationManager(this);
    private final CreationalContextFactory creationalContextFactory = new CreationalContextFactory(this);
    private final DecoratorsManager decoratorsManager = new DecoratorsManager(this);
    private final ExtensionLoader extensionLoader = new ExtensionLoader(this);
    private final InterceptorsManager interceptorsManager = new InterceptorsManager(this);
    private final InterceptorDecoratorProxyFactory interceptorDecoratorProxyFactory = new InterceptorDecoratorProxyFactory(this);
    private final NormalScopeProxyFactory normalScopeProxyFactory = new NormalScopeProxyFactory(this);
    private final SubclassProxyFactory subclassProxyFactory = new SubclassProxyFactory(this);
    private final OpenWebBeansConfiguration openWebBeansConfiguration;
    private final PluginLoader pluginLoader = new PluginLoader();
    private final SerializableBeanVault serializableBeanVault = new SerializableBeanVault();
    private final StereoTypeManager stereoTypeManager = new StereoTypeManager();
    private final AnnotationManager annotationManager = new AnnotationManager(this);
    private final InjectionPointFactory injectionPointFactory = new InjectionPointFactory(this);
    private final InterceptorUtil interceptorUtil = new InterceptorUtil(this);
    private final SecurityService securityService;
    private final LoaderService loaderService;
    private BeanArchiveService beanArchiveService;
    private final InterceptorResolutionService interceptorResolutionService = new InterceptorResolutionService(this);
    private final DeploymentValidationService deploymentValidationService = new DeploymentValidationService(this);
    private ScannerService scannerService;
    private ContextsService contextsService;
    private final ApplicationBoundaryService applicationBoundaryService;

    public WebBeansContext() {
        this(null, new OpenWebBeansConfiguration());
    }

    public WebBeansContext(Map<Class<?>, Object> initialServices, Properties properties) {
        this(initialServices, new OpenWebBeansConfiguration(properties));
    }

    private WebBeansContext(Map<Class<?>, Object> initialServices, OpenWebBeansConfiguration openWebBeansConfiguration) {
        OpenWebBeansConfiguration openWebBeansConfiguration2 = this.openWebBeansConfiguration = openWebBeansConfiguration != null ? openWebBeansConfiguration : new OpenWebBeansConfiguration();
        if (initialServices == null || !initialServices.containsKey(LoaderService.class)) {
            String implementationLoaderServiceName = openWebBeansConfiguration.getProperty(LoaderService.class.getName());
            if (implementationLoaderServiceName == null) {
                this.serviceMap.put(LoaderService.class, new DefaultLoaderService());
            } else {
                this.serviceMap.put(LoaderService.class, LoaderService.class.cast(this.get(implementationLoaderServiceName)));
            }
        }
        if (initialServices != null) {
            for (Map.Entry<Class<?>, Object> entry : initialServices.entrySet()) {
                if (!entry.getKey().isAssignableFrom(entry.getValue().getClass())) {
                    throw new IllegalArgumentException("Initial service claiming to be of type " + entry.getKey() + " is a " + entry.getValue().getClass());
                }
                this.serviceMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.loaderService = this.getService(LoaderService.class);
        this.securityService = this.getService(SecurityService.class);
        this.applicationBoundaryService = this.getService(ApplicationBoundaryService.class);
        this.beanArchiveService = this.getService(BeanArchiveService.class);
        this.managerMap.put(this.getClass(), this);
        this.managerMap.put(AlternativesManager.class, this.alternativesManager);
        this.managerMap.put(AnnotatedElementFactory.class, this.annotatedElementFactory);
        this.managerMap.put(BeanManagerImpl.class, this.beanManagerImpl);
        this.managerMap.put(ConversationManager.class, this.conversationManager);
        this.managerMap.put(CreationalContextFactory.class, this.creationalContextFactory);
        this.managerMap.put(DecoratorsManager.class, this.decoratorsManager);
        this.managerMap.put(ExtensionLoader.class, this.extensionLoader);
        this.managerMap.put(InterceptorsManager.class, this.interceptorsManager);
        this.managerMap.put(InterceptorDecoratorProxyFactory.class, this.interceptorDecoratorProxyFactory);
        this.managerMap.put(NormalScopeProxyFactory.class, this.normalScopeProxyFactory);
        this.managerMap.put(SubclassProxyFactory.class, this.subclassProxyFactory);
        this.managerMap.put(OpenWebBeansConfiguration.class, openWebBeansConfiguration);
        this.managerMap.put(PluginLoader.class, this.pluginLoader);
        this.managerMap.put(SerializableBeanVault.class, this.serializableBeanVault);
        this.managerMap.put(StereoTypeManager.class, this.stereoTypeManager);
        this.managerMap.put(InterceptorResolutionService.class, this.interceptorResolutionService);
    }

    public static WebBeansContext getInstance() {
        WebBeansContext webBeansContext = WebBeansFinder.getSingletonInstance();
        return webBeansContext;
    }

    public static WebBeansContext currentInstance() {
        return WebBeansContext.getInstance();
    }

    public <T> T getService(Class<T> clazz) {
        T t = clazz.cast(this.serviceMap.get(clazz));
        if (t == null) {
            t = this.doServiceLoader(clazz);
            this.registerService(clazz, t);
        }
        return t;
    }

    public <T> void registerService(Class<T> clazz, T t) {
        this.serviceMap.put(clazz, t);
    }

    private <T> T doServiceLoader(Class<T> serviceInterface) {
        String implName = this.getOpenWebBeansConfiguration().getProperty(serviceInterface.getName());
        if (implName == null) {
            List<OpenWebBeansPlugin> plugins = this.getPluginLoader().getPlugins();
            if (plugins != null && plugins.size() > 0) {
                for (OpenWebBeansPlugin plugin : plugins) {
                    if (!plugin.supportService(serviceInterface)) continue;
                    return (T)plugin.getSupportedService(serviceInterface);
                }
            }
            return null;
        }
        return serviceInterface.cast(this.get(implName));
    }

    public InterceptorUtil getInterceptorUtil() {
        return this.interceptorUtil;
    }

    public InjectionPointFactory getInjectionPointFactory() {
        return this.injectionPointFactory;
    }

    public WebBeansUtil getWebBeansUtil() {
        return this.webBeansUtil;
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public OpenWebBeansConfiguration getOpenWebBeansConfiguration() {
        return this.openWebBeansConfiguration;
    }

    public AnnotatedElementFactory getAnnotatedElementFactory() {
        return this.annotatedElementFactory;
    }

    public BeanManagerImpl getBeanManagerImpl() {
        return this.beanManagerImpl;
    }

    public SerializableBeanVault getSerializableBeanVault() {
        return this.serializableBeanVault;
    }

    public CreationalContextFactory getCreationalContextFactory() {
        return this.creationalContextFactory;
    }

    public DecoratorsManager getDecoratorsManager() {
        return this.decoratorsManager;
    }

    public StereoTypeManager getStereoTypeManager() {
        return this.stereoTypeManager;
    }

    public AlternativesManager getAlternativesManager() {
        return this.alternativesManager;
    }

    public InterceptorsManager getInterceptorsManager() {
        return this.interceptorsManager;
    }

    public InterceptorResolutionService getInterceptorResolutionService() {
        return this.interceptorResolutionService;
    }

    public PluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public ExtensionLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public InterceptorDecoratorProxyFactory getInterceptorDecoratorProxyFactory() {
        return this.interceptorDecoratorProxyFactory;
    }

    public NormalScopeProxyFactory getNormalScopeProxyFactory() {
        return this.normalScopeProxyFactory;
    }

    public SubclassProxyFactory getSubclassProxyFactory() {
        return this.subclassProxyFactory;
    }

    public ScannerService getScannerService() {
        if (this.scannerService == null) {
            this.scannerService = this.getService(ScannerService.class);
        }
        return this.scannerService;
    }

    public ContextsService getContextsService() {
        if (this.contextsService == null) {
            this.contextsService = this.getService(ContextsService.class);
        }
        return this.contextsService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public BeanArchiveService getBeanArchiveService() {
        return this.beanArchiveService;
    }

    private Object get(String singletonName) {
        Class<?> clazz = ClassUtil.getClassFromName(singletonName);
        if (clazz == null) {
            throw new WebBeansException("Class not found exception in creating instance with class : " + singletonName, new ClassNotFoundException("Class with name: " + singletonName + " is not found in the system"));
        }
        return this.get(clazz);
    }

    public <T> T get(Class<T> clazz) {
        T object = clazz.cast(this.managerMap.get(clazz));
        if (object == null) {
            object = this.createInstance(clazz);
            this.managerMap.put(clazz, object);
        }
        return object;
    }

    private <T> T createInstance(Class<T> clazz) {
        try {
            try {
                Constructor<T> constructor = clazz.getConstructor(WebBeansContext.class);
                return constructor.newInstance(this);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e2) {
                    throw new WebBeansException("No suitable constructor : " + clazz.getName(), e2.getCause());
                }
            }
        }
        catch (InstantiationException e) {
            throw new WebBeansException("Unable to instantiate class : " + clazz.getName(), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new WebBeansException("Unable to instantiate class : " + clazz.getName(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new WebBeansException("Illegal access exception in creating instance with class : " + clazz.getName(), e);
        }
    }

    public void clear() {
        this.managerMap.clear();
    }

    public LoaderService getLoaderService() {
        return this.loaderService;
    }

    public DeploymentValidationService getDeploymentValidationService() {
        return this.deploymentValidationService;
    }

    public ApplicationBoundaryService getApplicationBoundaryService() {
        return this.applicationBoundaryService;
    }

    public boolean findMissingAnnotatedType(Class<?> missing) {
        return false;
    }
}

