/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Inject;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.AbstractBeanBuilder;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.ProducerMethodBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerMethodBeansBuilder<T>
extends AbstractBeanBuilder {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;

    public ProducerMethodBeansBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, "annotated type may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public Set<ProducerMethodBean<?>> defineProducerMethods(InjectionTargetBean<T> bean, Set<ProducerFieldBean<?>> producerFields) {
        HashSet producerBeans = new HashSet();
        Set annotatedMethods = this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.annotatedType);
        HashSet skipMethods = new HashSet();
        for (AnnotatedMethod<T> annotatedMethod : annotatedMethods) {
            boolean isProducer = annotatedMethod.isAnnotationPresent(Produces.class);
            if (isProducer && annotatedMethod.getJavaMember().getDeclaringClass().equals(this.annotatedType.getJavaClass())) {
                this.checkProducerMethodForDeployment(annotatedMethod);
                boolean specialize = false;
                if (annotatedMethod.isAnnotationPresent(Specializes.class)) {
                    if (annotatedMethod.isStatic()) {
                        throw new WebBeansConfigurationException("Specializing annotated producer method : " + annotatedMethod + " can not be static");
                    }
                    specialize = true;
                }
                AnnotatedMethod<T> method = annotatedMethod;
                BeanAttributes<T> beanAttributes = this.webBeansContext.getWebBeansUtil().fireProcessBeanAttributes((Annotated)annotatedMethod, annotatedMethod.getJavaMember().getReturnType(), BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(method).build());
                if (beanAttributes == null) continue;
                ProducerMethodBeanBuilder<T> producerMethodBeanCreator = new ProducerMethodBeanBuilder<T>(bean, annotatedMethod, beanAttributes);
                ProducerMethodBean<T> producerMethodBean = producerMethodBeanCreator.getBean();
                this.webBeansContext.getDeploymentValidationService().validateProxyable(producerMethodBean);
                producerMethodBeanCreator.validate();
                if (specialize) {
                    producerMethodBeanCreator.configureProducerSpecialization(producerMethodBean, annotatedMethod);
                }
                producerMethodBean.setCreatorMethod(annotatedMethod.getJavaMember());
                this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(bean, producerMethodBean, AnnotationUtil.asArray(annotatedMethod.getAnnotations()));
                WebBeansUtil.checkProducerGenericType(producerMethodBean, annotatedMethod.getJavaMember());
                producerBeans.add(producerMethodBean);
                continue;
            }
            if (!isProducer) continue;
            skipMethods.add(annotatedMethod);
        }
        this.validateNoDisposerWithoutProducer(annotatedMethods, producerBeans, producerFields, skipMethods);
        return producerBeans;
    }

    private void checkProducerMethodForDeployment(AnnotatedMethod<? super T> annotatedMethod) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        if (annotatedMethod.isAnnotationPresent(Inject.class) || annotatedMethod.isAnnotationPresent(Disposes.class) || annotatedMethod.isAnnotationPresent(Observes.class)) {
            throw new WebBeansConfigurationException("Producer annotated method : " + annotatedMethod + " can not be annotated with" + " @Initializer/@Destructor annotation or has a parameter annotated with @Disposes/@Observes");
        }
    }
}

