/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ManagedBeanBuilder<T, M extends ManagedBean<T>> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected final BeanAttributes<T> beanAttributes;

    public ManagedBeanBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes) {
        Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, "annotated type may not be null");
        Asserts.assertNotNull(beanAttributes, "beanAttributes may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
        this.beanAttributes = beanAttributes;
    }

    public M getBean() {
        ManagedBean<T> bean = new ManagedBean<T>(this.webBeansContext, WebBeansType.MANAGED, this.annotatedType, this.beanAttributes, this.annotatedType.getJavaClass());
        bean.setEnabled(this.webBeansContext.getWebBeansUtil().isBeanEnabled(this.annotatedType, bean.getStereotypes()));
        this.webBeansContext.getWebBeansUtil().checkManagedBeanCondition(this.annotatedType);
        WebBeansUtil.checkGenericType(this.annotatedType.getJavaClass(), this.beanAttributes.getScope());
        this.webBeansContext.getWebBeansUtil().validateBeanInjection(bean);
        UnproxyableResolutionException lazyException = this.webBeansContext.getDeploymentValidationService().validateProxyable(bean);
        if (lazyException == null) {
            return (M)bean;
        }
        return (M)new UnproxyableBean<T>(this.webBeansContext, WebBeansType.MANAGED, this.beanAttributes, this.annotatedType, this.annotatedType.getJavaClass(), lazyException);
    }

    private static class UnproxyableBean<T>
    extends ManagedBean<T> {
        private final UnproxyableResolutionException exception;

        public UnproxyableBean(WebBeansContext webBeansContext, WebBeansType webBeansType, BeanAttributes<T> beanAttributes, AnnotatedType<T> at, Class<T> beanClass, UnproxyableResolutionException error) {
            super(webBeansContext, webBeansType, at, beanAttributes, beanClass);
            this.exception = error;
        }

        @Override
        public boolean valid() {
            throw this.exception;
        }

        @Override
        public T create(CreationalContext<T> creationalContext) {
            throw this.exception;
        }
    }
}

