/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.util.Asserts;

public abstract class AbstractProducerBeanBuilder<T, A extends AnnotatedMember<?>, P extends AbstractProducerBean<T>> {
    protected final InjectionTargetBean<?> parent;
    protected final A annotatedMember;
    protected final BeanAttributesImpl<T> beanAttributes;

    public AbstractProducerBeanBuilder(InjectionTargetBean<?> parent, A annotated, BeanAttributesImpl<T> beanAttributes) {
        Asserts.assertNotNull(parent, "webBeansContext may not be null");
        Asserts.assertNotNull(annotated, "annotated may not be null");
        Asserts.assertNotNull(beanAttributes, "beanAttributes may not be null");
        this.parent = parent;
        this.annotatedMember = annotated;
        this.beanAttributes = beanAttributes;
    }

    protected AnnotatedType<?> getSuperType() {
        Class superclass = this.annotatedMember.getDeclaringType().getJavaClass().getSuperclass();
        if (superclass == null) {
            return null;
        }
        return this.parent.getWebBeansContext().getAnnotatedElementFactory().getAnnotatedType(superclass);
    }

    protected abstract <X> P createBean(InjectionTargetBean<X> var1, Class<T> var2);

    protected P createBean(Class<T> beanClass) {
        return this.createBean(this.parent, beanClass);
    }
}

