/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.interceptor.Interceptor;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.NewLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.BeanManagerBean;
import org.apache.webbeans.component.BeanMetadataBean;
import org.apache.webbeans.component.ConversationBean;
import org.apache.webbeans.component.DecoratorMetadataBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.EventBean;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.InstanceBean;
import org.apache.webbeans.component.InterceptedOrDecoratedBeanMetadataBean;
import org.apache.webbeans.component.InterceptorMetadataBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.NewManagedBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.ExtensionBeanBuilder;
import org.apache.webbeans.component.creation.ManagedBeanBuilder;
import org.apache.webbeans.component.creation.ObserverMethodsBuilder;
import org.apache.webbeans.component.creation.ProducerFieldBeansBuilder;
import org.apache.webbeans.component.creation.ProducerMethodBeansBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.exception.inject.InconsistentSpecializationException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.portable.ProducerMethodProducer;
import org.apache.webbeans.portable.events.discovery.ErrorStack;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessBean;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.portable.events.generics.GProcessManagedBean;
import org.apache.webbeans.portable.events.generics.GProcessObservableMethod;
import org.apache.webbeans.portable.events.generics.GProcessProducer;
import org.apache.webbeans.portable.events.generics.GProcessProducerField;
import org.apache.webbeans.portable.events.generics.GProcessProducerMethod;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SortedListHelper;

public final class WebBeansUtil {
    private final WebBeansContext webBeansContext;

    public WebBeansUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public static ClassLoader getCurrentClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = WebBeansUtil.class.getClassLoader();
        }
        return loader;
    }

    public static void checkGenericType(Class<?> clazz, Class<? extends Annotation> scope) {
        Asserts.assertNotNull(clazz);
        if (ClassUtil.isDefinitionContainsTypeVariables(clazz) && !scope.equals(Dependent.class)) {
            throw new WebBeansConfigurationException("Generic type may only defined with scope @Dependent for ManagedBean class : " + clazz.getName());
        }
    }

    public static void checkProducerGenericType(Bean<?> bean, Member member) {
        Asserts.assertNotNull(bean, "Bean is null");
        Type type = null;
        if (bean instanceof ProducerMethodBean) {
            type = ((ProducerMethodBean)bean).getCreatorMethod().getGenericReturnType();
        } else if (bean instanceof ProducerFieldBean) {
            type = ((ProducerFieldBean)bean).getCreatorField().getGenericType();
        } else {
            throw new IllegalArgumentException("Bean must be Producer Field or Method Bean instance : " + bean);
        }
        String messageTemplate = "Producer Field/Method Bean with name : %s in bean class : %s";
        String memberName = member.getName();
        String declaringClassName = member.getDeclaringClass().getName();
        if (WebBeansUtil.checkGenericForProducers(type, messageTemplate, memberName, declaringClassName) && !bean.getScope().equals(Dependent.class)) {
            String message = WebBeansUtil.format(messageTemplate, memberName, declaringClassName);
            throw new WebBeansConfigurationException(message + " scope must bee @Dependent");
        }
    }

    private static boolean checkGenericForProducers(Type type, String messageTemplate, Object ... errorMessageArgs) {
        boolean result = false;
        if (type instanceof TypeVariable) {
            String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
            throw new WebBeansConfigurationException(message + " return type can not be type variable");
        }
        if (ClassUtil.isParametrizedType(type)) {
            Type[] actualTypes = ClassUtil.getActualTypeArguments(type);
            if (actualTypes.length == 0) {
                String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
                throw new WebBeansConfigurationException(message + " return type must define actual type arguments or type variable");
            }
            for (Type actualType : actualTypes) {
                if (ClassUtil.isWildCardType(actualType)) {
                    String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
                    throw new WebBeansConfigurationException(message + " return type can not define wildcard actual type argument");
                }
                if (!ClassUtil.isTypeVariable(actualType)) continue;
                result = true;
            }
        }
        return result;
    }

    public void checkManagedBean(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz, "Class is null");
        int modifier = clazz.getModifiers();
        if (!Modifier.isStatic(modifier) && ClassUtil.isInnerClazz(clazz)) {
            throw new WebBeansConfigurationException("Skipping CDI bean detection for non-static inner class: " + clazz.getName());
        }
        if (Extension.class.isAssignableFrom(clazz)) {
            throw new WebBeansConfigurationException("Skipping CDI bean detection for CDI Extension class" + clazz.getName());
        }
        List<OpenWebBeansPlugin> plugins = this.webBeansContext.getPluginLoader().getPlugins();
        for (OpenWebBeansPlugin plugin : plugins) {
            try {
                plugin.isManagedBean(clazz);
            }
            catch (Exception e) {
                PluginLoader.throwsException(e);
            }
        }
    }

    public void checkManagedBeanCondition(Class<?> clazz) throws WebBeansConfigurationException {
        if (AnnotationUtil.hasClassAnnotation(clazz, Decorator.class) && AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + clazz.getName() + " may not annotated with both @Interceptor and @Decorator annotation");
        }
        if (!AnnotationUtil.hasClassAnnotation(clazz, Decorator.class) && !AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            this.webBeansContext.getInterceptorUtil().checkSimpleWebBeansInterceptorConditions(clazz);
        }
    }

    public boolean supportsJavaEeComponentInjections(Class<?> clazz) {
        if (clazz.isInterface() || clazz.isAnnotation() || clazz.isEnum()) {
            return false;
        }
        List<OpenWebBeansPlugin> plugins = this.webBeansContext.getPluginLoader().getPlugins();
        for (OpenWebBeansPlugin plugin : plugins) {
            if (!(plugin instanceof OpenWebBeansEjbPlugin)) {
                if (!plugin.supportsJavaEeComponentInjections(clazz)) continue;
                return true;
            }
            return ((OpenWebBeansEjbPlugin)plugin).isSessionBean(clazz);
        }
        return false;
    }

    public boolean isConstructorOk(Class<?> clazz) throws WebBeansConfigurationException {
        Constructor[] constructors;
        Asserts.nullCheckForClass(clazz);
        if (this.getNoArgConstructor(clazz) != null) {
            return true;
        }
        for (Constructor constructor : constructors = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredConstructors(clazz)) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return true;
        }
        return false;
    }

    public <T> Bean<T> createNewComponent(Class<T> type) {
        Asserts.nullCheckForClass(type);
        OpenWebBeansEjbPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbPlugin();
        if (ejbPlugin != null && ejbPlugin.isNewSessionBean(type)) {
            return ejbPlugin.defineNewSessionBean(type);
        }
        AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(type);
        BeanAttributesImpl<T> defaultBeanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedType).build();
        BeanAttributesImpl newBeanAttributes = new BeanAttributesImpl(defaultBeanAttributes.getTypes(), Collections.singleton(new NewLiteral(type)));
        ManagedBeanBuilder beanBuilder = new ManagedBeanBuilder(this.webBeansContext, annotatedType, newBeanAttributes);
        NewManagedBean<T> newBean = new NewManagedBean<T>(this.webBeansContext, WebBeansType.MANAGED, annotatedType, newBeanAttributes, type, ((AbstractOwbBean)beanBuilder.getBean()).getInjectionPoints());
        return newBean;
    }

    public <T> NewManagedBean<T> createNewComponent(OwbBean<T> bean, Class<T> type) {
        Asserts.assertNotNull(bean, "bean may not be null");
        if (!EnumSet.of(WebBeansType.MANAGED, WebBeansType.ENTERPRISE, WebBeansType.PRODUCERMETHOD, WebBeansType.PRODUCERFIELD).contains((Object)bean.getWebBeansType())) {
            throw new WebBeansConfigurationException("@New annotation on type : " + bean.getBeanClass() + " must defined as a simple or an enterprise web bean");
        }
        AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(type);
        BeanAttributesImpl newBeanAttributes = new BeanAttributesImpl(bean.getTypes(), Collections.singleton(new NewLiteral(type)));
        NewManagedBean<T> newBean = new NewManagedBean<T>(bean.getWebBeansContext(), bean.getWebBeansType(), annotatedType, newBeanAttributes, type, bean.getInjectionPoints());
        return newBean;
    }

    public <T> ExtensionBean<T> createExtensionComponent(Class<T> clazz) {
        Asserts.nullCheckForClass(clazz);
        ExtensionBeanBuilder<T> extensionBeanBuilder = new ExtensionBeanBuilder<T>(this.webBeansContext, clazz);
        ExtensionBean<T> bean = extensionBeanBuilder.getBean();
        new ObserverMethodsBuilder(this.webBeansContext, extensionBeanBuilder.getAnnotatedType()).defineObserverMethods(bean);
        return bean;
    }

    public BeanManagerBean getManagerBean() {
        return new BeanManagerBean(this.webBeansContext);
    }

    public <T> InstanceBean<T> getInstanceBean() {
        return new InstanceBean(this.webBeansContext);
    }

    public <T> EventBean<T> getEventBean() {
        return new EventBean(this.webBeansContext);
    }

    public <T> BeanMetadataBean<T> getBeanMetadataBean() {
        return new BeanMetadataBean(this.webBeansContext);
    }

    public <T> InterceptorMetadataBean<T> getInterceptorMetadataBean() {
        return new InterceptorMetadataBean(this.webBeansContext);
    }

    public <T> DecoratorMetadataBean<T> getDecoratorMetadataBean() {
        return new DecoratorMetadataBean(this.webBeansContext);
    }

    public <T> InterceptedOrDecoratedBeanMetadataBean<T> getInterceptedOrDecoratedBeanMetadataBean() {
        return new InterceptedOrDecoratedBeanMetadataBean(this.webBeansContext);
    }

    public ConversationBean getConversationBean() {
        ConversationBean conversationComp = new ConversationBean(this.webBeansContext);
        return conversationComp;
    }

    public InjectionPointBean getInjectionPointBean() {
        return new InjectionPointBean(this.webBeansContext);
    }

    public static String getManagedBeanDefaultName(String clazzName) {
        Asserts.assertNotNull(clazzName);
        if (clazzName.length() > 0) {
            StringBuilder name = new StringBuilder(clazzName);
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            return name.toString();
        }
        return clazzName;
    }

    public static String getProducerDefaultName(String methodName) {
        StringBuilder buffer = new StringBuilder(methodName);
        if (buffer.length() > 3 && (buffer.substring(0, 3).equals("get") || buffer.substring(0, 3).equals("set"))) {
            if (Character.isUpperCase(buffer.charAt(3))) {
                buffer.setCharAt(3, Character.toLowerCase(buffer.charAt(3)));
            }
            return buffer.substring(3);
        }
        if (buffer.length() > 2 && buffer.substring(0, 2).equals("is")) {
            if (Character.isUpperCase(buffer.charAt(2))) {
                buffer.setCharAt(2, Character.toLowerCase(buffer.charAt(2)));
            }
            return buffer.substring(2);
        }
        buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
        return buffer.toString();
    }

    protected static boolean isDirectlySpecializedBeanSet(Set<Bean<?>> beans) {
        ArrayList<AbstractOwbBean> beanList = new ArrayList<AbstractOwbBean>();
        for (Bean<?> bb : beans) {
            AbstractOwbBean bean = (AbstractOwbBean)bb;
            beanList.add(bean);
        }
        Collections.sort(beanList, new Comparator(){

            public int compare(Object o1, Object o2) {
                AbstractOwbBean b1 = (AbstractOwbBean)o1;
                AbstractOwbBean b2 = (AbstractOwbBean)o2;
                Class c1 = b1.getReturnType();
                Class c2 = b2.getReturnType();
                if (c2.isAssignableFrom(c1)) {
                    return 1;
                }
                if (c1.isAssignableFrom(c2)) {
                    return -1;
                }
                throw new InconsistentSpecializationException(c1 + " and " + c2 + "are not assignable to each other.");
            }
        });
        for (int i = 0; i < beanList.size() - 1; ++i) {
            if (((AbstractOwbBean)beanList.get(i)).getReturnType().equals(((AbstractOwbBean)beanList.get(i + 1)).getReturnType().getSuperclass())) continue;
            return false;
        }
        return true;
    }

    public void configureSpecializations(List<Class<?>> beanClasses) {
        for (Class<?> clazz : beanClasses) {
            this.configureSpecializations(clazz, beanClasses);
        }
    }

    protected void configureSpecializations(Class<?> specializedClass, List<Class<?>> beanClasses) {
        Asserts.nullCheckForClass(specializedClass);
        Bean<?> superBean = null;
        Set<Bean<?>> resolvers = this.isConfiguredWebBeans(specializedClass, true);
        AlternativesManager altManager = this.webBeansContext.getAlternativesManager();
        if (resolvers != null && !resolvers.isEmpty()) {
            Bean<?> specialized = resolvers.iterator().next();
            if (resolvers.size() > 1) {
                if (!WebBeansUtil.isDirectlySpecializedBeanSet(resolvers)) {
                    throw new InconsistentSpecializationException("More than one specialized bean for class : " + specializedClass + " is enabled in the deployment.");
                }
                for (Bean<?> bean : resolvers) {
                    if (bean == specialized || bean.getTypes().size() <= specialized.getTypes().size() || !bean.getTypes().containsAll(specialized.getTypes())) continue;
                    specialized = bean;
                }
            }
            Class<?> superClass = specializedClass.getSuperclass();
            resolvers = this.isConfiguredWebBeans(superClass, false);
            for (Bean<?> bean : resolvers) {
                AbstractOwbBean candidate = (AbstractOwbBean)bean;
                if (candidate instanceof NewBean || !candidate.getReturnType().equals(superClass)) continue;
                superBean = bean;
                break;
            }
            if (superBean != null) {
                for (Class<?> clazz : beanClasses) {
                    if (clazz.equals(specializedClass) || !clazz.getSuperclass().equals(superClass)) continue;
                    InconsistentSpecializationException exception = new InconsistentSpecializationException(superClass.getName() + " is @Specialized by two classes: " + clazz.getName() + " and " + specializedClass.getName());
                    throw new WebBeansDeploymentException(exception);
                }
                if (!specialized.getTypes().containsAll(superBean.getTypes())) {
                    throw new DefinitionException("@Specialized Class : " + specializedClass.getName() + " must have all bean types of its super class");
                }
                this.webBeansContext.getBeanManagerImpl().getNotificationManager().disableOverriddenObservers(specializedClass);
                if (beanClasses.contains(superClass) && ((AbstractOwbBean)superBean).isEnabled()) {
                    this.configureSpecializations(superClass, beanClasses);
                }
                if (!AnnotationUtil.hasClassAnnotation(specializedClass, Alternative.class)) {
                    ((AbstractOwbBean)superBean).setEnabled(false);
                } else if (altManager.isClassAlternative(specializedClass)) {
                    ((AbstractOwbBean)superBean).setEnabled(false);
                }
                AbstractOwbBean abstractOwbBean = (AbstractOwbBean)specialized;
                if (abstractOwbBean.isSpecializedBean()) {
                    return;
                }
                if (abstractOwbBean.getClass() != superBean.getClass()) {
                    throw new InconsistentSpecializationException("@Specialized Class : " + specializedClass.getName() + " and its super class may be the same type of bean,i.e, ManagedBean, SessionBean etc.");
                }
                if (superBean.getName() != null && !superBean.getName().equals(abstractOwbBean.getName())) {
                    throw new InconsistentSpecializationException("@Specialized Class : " + specializedClass.getName() + " may not explicitly declare a bean name");
                }
                abstractOwbBean.setSpecializedBean(true);
                HashMap hashMap = new HashMap();
                HashMap beanProducers = new HashMap();
                for (Bean<?> bean : this.webBeansContext.getBeanManagerImpl().getComponents()) {
                    if (!(bean instanceof ProducerMethodBean)) continue;
                    ProducerMethodBean producerBean = (ProducerMethodBean)bean;
                    Class returnType = producerBean.getReturnType();
                    if (producerBean.getBeanClass() == superBean.getBeanClass() && producerBean.getProducer() instanceof ProducerMethodProducer) {
                        ProducerMethodProducer producer = (ProducerMethodProducer)producerBean.getProducer();
                        producer.specializeBy(abstractOwbBean);
                        if (beanProducers.keySet().contains(returnType)) {
                            ((ProducerMethodBean)beanProducers.get(returnType)).setSpecializedBean(true);
                            continue;
                        }
                        hashMap.put(returnType, producerBean);
                        continue;
                    }
                    if (specializedClass != bean.getBeanClass()) continue;
                    if (hashMap.keySet().contains(returnType)) {
                        producerBean.setSpecializedBean(true);
                        continue;
                    }
                    beanProducers.put(returnType, producerBean);
                }
            } else {
                throw new DefinitionException("WebBean component class : " + specializedClass.getName() + " is not enabled for specialized by the " + specializedClass + " class");
            }
        }
    }

    protected void configSpecializedProducerMethodBeans(List<ProducerMethodBean> sortedProducerBeans) {
        if (sortedProducerBeans.isEmpty()) {
            return;
        }
        AlternativesManager altManager = this.webBeansContext.getAlternativesManager();
        Method superMethod = sortedProducerBeans.get(0).getCreatorMethod();
        for (int i = 1; i < sortedProducerBeans.size(); ++i) {
            ProducerMethodBean bean = sortedProducerBeans.get(i);
            ProducerMethodBean superBean = sortedProducerBeans.get(i - 1);
            boolean isSuperHasName = this.isSuperMethodNamed(bean, bean.getCreatorMethod(), superMethod);
            if (bean.getCreatorMethod().getAnnotation(Alternative.class) == null) {
                superBean.setEnabled(false);
            } else if (altManager.isClassAlternative(bean.getBeanClass())) {
                superBean.setEnabled(false);
            }
            if (isSuperHasName) continue;
            superMethod = bean.getCreatorMethod();
        }
    }

    public void configureProducerMethodSpecializations() {
        Set<Bean<?>> beans = this.webBeansContext.getBeanManagerImpl().getBeans();
        ArrayList<ProducerMethodBean> producerBeans = new ArrayList<ProducerMethodBean>();
        for (Bean<?> b : beans) {
            if (!(b instanceof ProducerMethodBean)) continue;
            producerBeans.add((ProducerMethodBean)b);
        }
        SortedListHelper<ProducerMethodBean> producerBeanListHelper = new SortedListHelper<ProducerMethodBean>(new ArrayList(), new Comparator<ProducerMethodBean>(){

            @Override
            public int compare(ProducerMethodBean e1, ProducerMethodBean e2) {
                if (e1.getBeanClass().isAssignableFrom(e2.getBeanClass())) {
                    return -1;
                }
                if (e1.equals(e2)) {
                    return 0;
                }
                return 1;
            }
        });
        while (true) {
            boolean bl;
            ProducerMethodBean<Object> pRight;
            ProducerMethodBean<Object> pbean = null;
            Method method = null;
            producerBeanListHelper.clear();
            for (ProducerMethodBean<Object> producerMethodBean : producerBeans) {
                if (!producerMethodBean.isSpecializedBean()) continue;
                pbean = producerMethodBean;
                method = producerMethodBean.getCreatorMethod();
                producerBeanListHelper.add(producerMethodBean);
                break;
            }
            if (pbean == null) break;
            ProducerMethodBean<Object> pLeft = pRight = pbean;
            boolean pLeftContinue = true;
            boolean bl2 = true;
            while (pLeftContinue || bl) {
                bl = false;
                pLeftContinue = false;
                for (ProducerMethodBean<Object> producerMethodBean : producerBeans) {
                    Method superMethod;
                    if (pLeft != null && pLeft.getBeanClass().getSuperclass().equals(producerMethodBean.getBeanClass())) {
                        superMethod = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(producerMethodBean.getBeanClass(), method.getName(), (Class[])method.getParameterTypes());
                        if (superMethod != null && superMethod.equals(producerMethodBean.getCreatorMethod())) {
                            producerBeanListHelper.add(producerMethodBean);
                            pLeft = producerMethodBean.isSpecializedBean() ? producerMethodBean : null;
                        } else {
                            pLeft = null;
                        }
                        if (pLeft != null) {
                            pLeftContinue = true;
                        }
                    }
                    if (pRight == null || !producerMethodBean.getBeanClass().getSuperclass().equals(pRight.getBeanClass())) continue;
                    if (!producerMethodBean.isSpecializedBean()) {
                        pRight = null;
                    } else {
                        superMethod = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(producerMethodBean.getBeanClass(), method.getName(), (Class[])method.getParameterTypes());
                        if (superMethod != null && superMethod.equals(producerMethodBean.getCreatorMethod())) {
                            producerBeanListHelper.add(producerMethodBean);
                            pRight = producerMethodBean;
                        } else {
                            pRight = null;
                        }
                    }
                    if (pRight == null) continue;
                    bl = true;
                }
            }
            for (ProducerMethodBean<Object> producerMethodBean : producerBeanListHelper.getList()) {
                producerBeans.remove(producerMethodBean);
            }
            this.configSpecializedProducerMethodBeans(producerBeanListHelper.getList());
        }
    }

    public Set<Bean<?>> isConfiguredWebBeans(Class<?> clazz, boolean annotate) {
        Asserts.nullCheckForClass(clazz);
        HashSet beans = new HashSet();
        Set<Bean<?>> components = this.webBeansContext.getBeanManagerImpl().getComponents();
        for (AbstractOwbBean abstractOwbBean : components) {
            if (!abstractOwbBean.getTypes().contains(clazz) && (!EnterpriseBeanMarker.class.isInstance(abstractOwbBean) || !abstractOwbBean.getBeanClass().isAssignableFrom(clazz))) continue;
            if (annotate) {
                if (!abstractOwbBean.getReturnType().isAnnotationPresent(Specializes.class) || abstractOwbBean instanceof NewBean) continue;
                beans.add(abstractOwbBean);
                continue;
            }
            beans.add(abstractOwbBean);
        }
        return beans;
    }

    public <T> Constructor<T> getNoArgConstructor(Class<T> clazz) {
        return this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredConstructor(clazz, new Class[0]);
    }

    public boolean isSuperMethodNamed(AbstractOwbBean<?> component, Method method, Method superMethod) {
        return this.webBeansContext.getAnnotationManager().isSuperMethodNamed(component, method, superMethod);
    }

    public static boolean checkObtainsInjectionPointConditions(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        Class<Instance> candidateClazz = ClassUtil.getClass(type);
        if (!candidateClazz.isAssignableFrom(Instance.class)) {
            return false;
        }
        if (ClassUtil.isParametrizedType(injectionPoint.getType())) {
            ParameterizedType pt = (ParameterizedType)injectionPoint.getType();
            Class rawType = (Class)pt.getRawType();
            Type[] typeArgs = pt.getActualTypeArguments();
            if (!rawType.isAssignableFrom(Instance.class)) {
                throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must have type javax.inject.Instance");
            }
            if (typeArgs.length != 1) {
                throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must not have more than one actual type argument");
            }
        } else {
            throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must be defined as ParameterizedType with one actual type argument");
        }
        return true;
    }

    public static void checkNullInstance(Object instance, Class<?> scopeType, String errorMessage, Object ... errorMessageArgs) {
        if (instance == null && !scopeType.equals(Dependent.class)) {
            String message = WebBeansUtil.format(errorMessage, errorMessageArgs);
            throw new IllegalProductException(message);
        }
    }

    public void checkSerializableScopeType(Class<? extends Annotation> scopeType, boolean isSerializable, String errorMessage, Object ... errorMessageArgs) {
        if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(scopeType) && !isSerializable) {
            String message = WebBeansUtil.format(errorMessage, errorMessageArgs);
            throw new IllegalProductException(message);
        }
    }

    public static Bean<?> getMostSpecializedBean(BeanManager manager, Bean<?> component) {
        Set<Bean> beans;
        if (component instanceof EnterpriseBeanMarker) {
            beans = new HashSet();
            Set allBeans = manager.getBeans(Object.class, AnnotationUtil.asArray(component.getQualifiers()));
            for (Bean candidateBean : allBeans) {
                Class candidateSuperClass;
                if (!(candidateBean instanceof EnterpriseBeanMarker) || !(candidateSuperClass = candidateBean.getBeanClass().getSuperclass()).equals(component.getBeanClass())) continue;
                beans.add(candidateBean);
            }
        } else {
            beans = manager.getBeans((Type)component.getBeanClass(), AnnotationUtil.asArray(component.getQualifiers()));
        }
        for (Bean bean : beans) {
            Bean find = bean;
            if (find.equals(component) || !AnnotationUtil.hasClassAnnotation(find.getBeanClass(), Specializes.class)) continue;
            return WebBeansUtil.getMostSpecializedBean(manager, find);
        }
        return component;
    }

    public <T> GProcessAnnotatedType fireProcessAnnotatedTypeEvent(AnnotatedType<T> annotatedType) {
        GProcessAnnotatedType processAnnotatedEvent = new GProcessAnnotatedType((AnnotatedType)annotatedType);
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processAnnotatedEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        if (processAnnotatedEvent.isModifiedAnnotatedType()) {
            this.webBeansContext.getAnnotatedElementFactory().setAnnotatedType(processAnnotatedEvent.getAnnotatedType());
        }
        return processAnnotatedEvent;
    }

    public <T> GProcessInjectionTarget fireProcessInjectionTargetEvent(InjectionTargetImpl<T> injectionTarget, AnnotatedType<T> annotatedType) {
        GProcessInjectionTarget processInjectionTargetEvent = new GProcessInjectionTarget(injectionTarget, annotatedType);
        return this.fireProcessInjectionTargetEvent(processInjectionTargetEvent);
    }

    private GProcessInjectionTarget fireProcessInjectionTargetEvent(GProcessInjectionTarget processInjectionTargetEvent) {
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processInjectionTargetEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return processInjectionTargetEvent;
    }

    public <T> GProcessInjectionTarget fireProcessInjectionTargetEventForJavaEeComponents(Class<T> componentClass) {
        AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(componentClass);
        InjectionTargetImpl injectionTarget = (InjectionTargetImpl)InjectionTargetImpl.class.cast(this.webBeansContext.getBeanManagerImpl().createInjectionTarget(annotatedType));
        GProcessInjectionTarget processInjectionTargetEvent = new GProcessInjectionTarget(injectionTarget, annotatedType);
        return this.fireProcessInjectionTargetEvent(processInjectionTargetEvent);
    }

    public <T> Producer<T> fireProcessProducerEvent(Producer<T> producer, AnnotatedMember<?> annotatedMember) {
        GProcessProducer processProducerEvent = new GProcessProducer((Producer<?>)producer, annotatedMember);
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processProducerEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducer event observers. Look at logs for further details");
        return processProducerEvent.getProducer();
    }

    public void fireProcessProducerMethodBeanEvent(Map<ProducerMethodBean<?>, AnnotatedMethod<?>> annotatedMethods, AnnotatedType<?> annotatedType) {
        WebBeansContext webBeansContext = this.webBeansContext;
        AnnotationManager annotationManager = webBeansContext.getAnnotationManager();
        for (Map.Entry<ProducerMethodBean<?>, AnnotatedMethod<?>> beanEntry : annotatedMethods.entrySet()) {
            ProducerMethodBean<?> bean = beanEntry.getKey();
            AnnotatedMethod<?> annotatedMethod = beanEntry.getValue();
            Annotation[] annotationsFromSet = AnnotationUtil.asArray(bean.getQualifiers());
            Method disposal = annotationManager.getDisposalWithGivenAnnotatedMethod(annotatedType, bean.getReturnType(), annotationsFromSet);
            AnnotatedMethod<?> disposalAnnotated = null;
            GProcessProducerMethod processProducerMethodEvent = null;
            if (disposal != null) {
                disposalAnnotated = webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(disposal, annotatedType);
                processProducerMethodEvent = new GProcessProducerMethod(bean, annotatedMethod, (AnnotatedParameter)disposalAnnotated.getParameters().get(0));
            } else {
                processProducerMethodEvent = new GProcessProducerMethod(bean, annotatedMethod, null);
            }
            webBeansContext.getBeanManagerImpl().fireEvent((Object)processProducerMethodEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public void fireProcessObservableMethodBeanEvent(Map<ObserverMethod<?>, AnnotatedMethod<?>> annotatedMethods) {
        for (Map.Entry<ObserverMethod<?>, AnnotatedMethod<?>> observableMethodEntry : annotatedMethods.entrySet()) {
            ObserverMethod<?> observableMethod = observableMethodEntry.getKey();
            AnnotatedMethod<?> annotatedMethod = observableMethodEntry.getValue();
            GProcessObservableMethod event = new GProcessObservableMethod(annotatedMethod, observableMethod);
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)event, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public void fireProcessProducerFieldBeanEvent(Map<ProducerFieldBean<?>, AnnotatedField<?>> annotatedFields) {
        for (Map.Entry<ProducerFieldBean<?>, AnnotatedField<?>> beanEntry : annotatedFields.entrySet()) {
            ProducerFieldBean<?> bean = beanEntry.getKey();
            AnnotatedField<?> field = beanEntry.getValue();
            GProcessProducerField processProducerFieldEvent = new GProcessProducerField(bean, field, null);
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)processProducerFieldEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public static void checkInjectionPointNamedQualifier(InjectionPoint injectionPoint) {
        Member member;
        String value;
        Set qualifierset = injectionPoint.getQualifiers();
        Named namedQualifier = null;
        for (Annotation qualifier : qualifierset) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            namedQualifier = (Named)qualifier;
            break;
        }
        if (namedQualifier != null && ((value = namedQualifier.value()) == null || value.equals("")) && !((member = injectionPoint.getMember()) instanceof Field)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " can not define @Named qualifier without value!");
        }
    }

    public void setInjectionTargetBeanEnableFlag(InjectionTargetBean<?> bean) {
        bean.setEnabled(this.isBeanEnabled(bean.getAnnotatedType(), bean.getStereotypes()));
    }

    public boolean isBeanEnabled(AnnotatedType<?> at, Set<Class<? extends Annotation>> stereotypes) {
        boolean isAlternative = WebBeansUtil.hasInjectionTargetBeanAnnotatedWithAlternative(at, stereotypes);
        return !isAlternative || this.webBeansContext.getAlternativesManager().isAlternative(at.getJavaClass(), stereotypes);
    }

    public static boolean hasInjectionTargetBeanAnnotatedWithAlternative(InjectionTargetBean<?> bean) {
        return WebBeansUtil.hasInjectionTargetBeanAnnotatedWithAlternative(bean.getAnnotatedType(), bean.getStereotypes());
    }

    public static boolean hasInjectionTargetBeanAnnotatedWithAlternative(AnnotatedType<?> beanType, Set<Class<? extends Annotation>> stereotypes) {
        Asserts.assertNotNull(beanType, "bean type can not be null");
        Asserts.assertNotNull(stereotypes, "stereotypes can not be null");
        boolean alternative = false;
        if (beanType.getAnnotation(Alternative.class) != null) {
            alternative = true;
        }
        if (!alternative) {
            for (Class<? extends Annotation> stereoType : stereotypes) {
                if (!AnnotationUtil.hasClassAnnotation(stereoType, Alternative.class)) continue;
                alternative = true;
                break;
            }
        }
        return alternative;
    }

    public void setBeanEnableFlagForProducerBean(InjectionTargetBean<?> parent, AbstractProducerBean<?> producer, Annotation[] annotations) {
        Asserts.assertNotNull(parent, "parent can not be null");
        Asserts.assertNotNull(producer, "producer can not be null");
        producer.setEnabled(this.isProducerBeanEnabled(parent, producer.getStereotypes(), annotations));
    }

    public boolean isProducerBeanEnabled(InjectionTargetBean<?> parent, Set<Class<? extends Annotation>> stereotypes, Annotation[] annotations) {
        boolean alternative = false;
        if (AnnotationUtil.hasAnnotation(annotations, Alternative.class)) {
            alternative = true;
        }
        if (!alternative) {
            for (Class<? extends Annotation> stereoType : stereotypes) {
                if (!AnnotationUtil.hasClassAnnotation(stereoType, Alternative.class)) continue;
                alternative = true;
                break;
            }
        }
        if (alternative) {
            return WebBeansUtil.hasInjectionTargetBeanAnnotatedWithAlternative(parent) && this.webBeansContext.getAlternativesManager().isBeanHasAlternative(parent);
        }
        return parent.isEnabled();
    }

    public static boolean isExtensionEventType(Type type) {
        return type.equals(BeforeBeanDiscovery.class) || type.equals(AfterBeanDiscovery.class) || type.equals(AfterDeploymentValidation.class) || type.equals(BeforeShutdown.class) || type.equals(GProcessAnnotatedType.class) || type.equals(GProcessInjectionTarget.class) || type.equals(GProcessProducer.class) || type.equals(GProcessProducerField.class) || type.equals(GProcessProducerMethod.class) || type.equals(GProcessManagedBean.class) || type.equals(GProcessBean.class) || type.equals(GProcessSessionBean.class) || type.equals(GProcessObservableMethod.class);
    }

    public static boolean isExtensionBeanEventType(Type type) {
        return type.equals(GProcessAnnotatedType.class) || type.equals(GProcessInjectionTarget.class) || type.equals(GProcessManagedBean.class) || type.equals(GProcessSessionBean.class) || type.equals(GProcessBean.class);
    }

    public static boolean isDefaultExtensionBeanEventType(Class<?> clazz) {
        return clazz.equals(ProcessAnnotatedType.class) || clazz.equals(ProcessInjectionTarget.class) || clazz.equals(ProcessManagedBean.class) || clazz.equals(ProcessBean.class) || clazz.equals(ProcessSessionBean.class);
    }

    public static boolean isExtensionProducerOrObserverEventType(Type type) {
        return type.equals(GProcessProducer.class) || type.equals(GProcessProducerField.class) || type.equals(GProcessProducerMethod.class) || type.equals(GProcessObservableMethod.class);
    }

    public static boolean isDefaultExtensionProducerOrObserverEventType(Class<?> clazz) {
        return clazz.equals(ProcessProducer.class) || clazz.equals(ProcessProducerField.class) || clazz.equals(ProcessProducerMethod.class) || clazz.equals(ProcessObserverMethod.class);
    }

    public static boolean isDependent(Bean<?> bean) {
        if (!(bean instanceof OwbBean)) {
            return bean.getScope().equals(Dependent.class);
        }
        return ((OwbBean)bean).isDependent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectErrorStack(String logMessage) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        ErrorStack stack = manager.getErrorStack();
        try {
            if (stack.hasErrors()) {
                stack.logErrors();
                throw new WebBeansConfigurationException(logMessage);
            }
        }
        finally {
            stack.clear();
        }
    }

    public static String getPassivationId(Contextual<?> contextual) {
        if (contextual instanceof Bean) {
            if (contextual instanceof AbstractOwbBean) {
                if (((AbstractOwbBean)contextual).isPassivationCapable()) {
                    return ((AbstractOwbBean)contextual).getId();
                }
            } else if (contextual instanceof PassivationCapable) {
                PassivationCapable pc = (PassivationCapable)contextual;
                return pc.getId();
            }
        } else if (contextual instanceof PassivationCapable && contextual instanceof Serializable) {
            PassivationCapable pc = (PassivationCapable)contextual;
            return pc.getId();
        }
        return null;
    }

    public <T> ManagedBean<T> defineManagedBeanWithoutFireEvents(AnnotatedType<T> type) {
        BeanAttributesImpl<T> beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(type).build();
        ManagedBeanBuilder managedBeanCreator = new ManagedBeanBuilder(this.webBeansContext, type, beanAttributes);
        this.setInjectionTargetBeanEnableFlag((InjectionTargetBean<?>)managedBeanCreator.getBean());
        Object managedBean = managedBeanCreator.getBean();
        new ProducerMethodBeansBuilder(((AbstractOwbBean)managedBean).getWebBeansContext(), ((InjectionTargetBean)managedBean).getAnnotatedType()).defineProducerMethods(managedBean);
        new ProducerFieldBeansBuilder(((AbstractOwbBean)managedBean).getWebBeansContext(), ((InjectionTargetBean)managedBean).getAnnotatedType()).defineProducerFields(managedBean);
        new ObserverMethodsBuilder(this.webBeansContext, ((InjectionTargetBean)managedBean).getAnnotatedType()).defineObserverMethods(managedBean);
        if (((InjectionTargetBean)managedBean).getProducer() instanceof AbstractProducer) {
            AbstractProducer producer = (AbstractProducer)((InjectionTargetBean)managedBean).getProducer();
            producer.defineInterceptorStack(managedBean, ((InjectionTargetBean)managedBean).getAnnotatedType(), this.webBeansContext);
        }
        return managedBean;
    }

    public boolean isPassivationCapableDependency(InjectionPoint injectionPoint) {
        if (injectionPoint.isDelegate()) {
            return true;
        }
        InjectionResolver instance = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
        Bean<?> bean = instance.getInjectionPointBean(injectionPoint);
        if (bean instanceof EnterpriseBeanMarker || bean instanceof ResourceBean || bean instanceof InstanceBean || bean instanceof EventBean || bean instanceof InjectionPointBean || bean instanceof BeanManagerBean) {
            return true;
        }
        if (this.webBeansContext.getBeanManagerImpl().isNormalScope(bean.getScope())) {
            return true;
        }
        return WebBeansUtil.getPassivationId(bean) != null;
    }

    public static void throwRuntimeExceptions(Exception e) {
        if (RuntimeException.class.isAssignableFrom(e.getClass())) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static boolean isDecorator(AnnotatedType<?> annotatedType) {
        return annotatedType.isAnnotationPresent(Decorator.class);
    }

    public boolean isAnnotatedTypeDecoratorOrInterceptor(AnnotatedType<?> annotatedType) {
        if (WebBeansUtil.isDecorator(annotatedType) || WebBeansUtil.isCdiInterceptor(annotatedType)) {
            return true;
        }
        if (this.webBeansContext.getInterceptorsManager().isInterceptorClassEnabled(annotatedType.getJavaClass())) {
            return true;
        }
        return this.webBeansContext.getDecoratorsManager().isDecoratorEnabled(annotatedType.getJavaClass());
    }

    public static boolean isCdiInterceptor(AnnotatedType<?> annotatedType) {
        return annotatedType.isAnnotationPresent(Interceptor.class);
    }

    public <T> ManagedBean<T> defineManagedBean(AnnotatedType<T> type) {
        BeanAttributesImpl<T> beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(type).build();
        ManagedBeanBuilder managedBeanCreator = new ManagedBeanBuilder(this.webBeansContext, type, beanAttributes);
        Object managedBean = managedBeanCreator.getBean();
        new ProducerMethodBeansBuilder(((AbstractOwbBean)managedBean).getWebBeansContext(), ((InjectionTargetBean)managedBean).getAnnotatedType()).defineProducerMethods(managedBean);
        new ProducerFieldBeansBuilder(((AbstractOwbBean)managedBean).getWebBeansContext(), ((InjectionTargetBean)managedBean).getAnnotatedType()).defineProducerFields(managedBean);
        new ObserverMethodsBuilder(this.webBeansContext, ((InjectionTargetBean)managedBean).getAnnotatedType()).defineObserverMethods(managedBean);
        if (((InjectionTargetBean)managedBean).getProducer() instanceof AbstractProducer) {
            AbstractProducer producer = (AbstractProducer)((InjectionTargetBean)managedBean).getProducer();
            producer.defineInterceptorStack(managedBean, ((InjectionTargetBean)managedBean).getAnnotatedType(), this.webBeansContext);
        }
        return managedBean;
    }

    public <X> void checkManagedBeanCondition(AnnotatedType<X> type) throws WebBeansConfigurationException {
        int modifier = type.getJavaClass().getModifiers();
        if (type.isAnnotationPresent(Decorator.class) && type.isAnnotationPresent(Interceptor.class)) {
            throw new WebBeansConfigurationException("Annotated type " + type + " may not annotated with both @Interceptor and @Decorator annotation");
        }
        if (!type.isAnnotationPresent(Decorator.class) && !type.isAnnotationPresent(Interceptor.class)) {
            this.checkManagedWebBeansInterceptorConditions(type);
        }
        if (Modifier.isInterface(modifier)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + type.getJavaClass().getName() + " may not defined as interface");
        }
    }

    private <X> void checkManagedWebBeansInterceptorConditions(AnnotatedType<X> type) {
        Annotation[] anns = AnnotationUtil.asArray(type.getAnnotations());
        Class clazz = type.getJavaClass();
        boolean hasClassInterceptors = false;
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        if (annotationManager.getInterceptorBindingMetaAnnotations(anns).length > 0) {
            hasClassInterceptors = true;
        } else {
            Annotation[] stereoTypes = annotationManager.getStereotypeMetaAnnotations(anns);
            for (Annotation stero : stereoTypes) {
                if (!annotationManager.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                hasClassInterceptors = true;
                break;
            }
        }
        if (Modifier.isFinal(clazz.getModifiers()) && hasClassInterceptors) {
            throw new WebBeansConfigurationException("Final managed bean class with name : " + clazz.getName() + " can not define any InterceptorBindings");
        }
        Set methods = type.getMethods();
        for (AnnotatedMethod methodA : methods) {
            Method method = methodA.getJavaMember();
            int modifiers = method.getModifiers();
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || !Modifier.isFinal(modifiers)) continue;
            if (hasClassInterceptors) {
                throw new WebBeansConfigurationException("Maanged bean class : " + clazz.getName() + " can not define non-static, non-private final methods. Because it is annotated with at least one @InterceptorBinding");
            }
            if (!annotationManager.hasInterceptorBindingMetaAnnotation(AnnotationUtil.asArray(methodA.getAnnotations()))) continue;
            throw new WebBeansConfigurationException("Method : " + method.getName() + "in managed bean class : " + clazz.getName() + " can not be defined as non-static, non-private and final . Because it is annotated with at least one @InterceptorBinding");
        }
    }

    private static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

