/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.InterceptedMarker;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.component.creation.ManagedBeanCreatorImpl;
import org.apache.webbeans.config.EJBWebBeansConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectableBeanManager;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.corespi.se.DefaultJndiService;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.inject.InconsistentSpecializationException;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ProcessAnnotatedTypeImpl;
import org.apache.webbeans.portable.events.discovery.AfterBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.discovery.AfterDeploymentValidationImpl;
import org.apache.webbeans.portable.events.discovery.BeforeBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansWebPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtils;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansDeployer {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(BeansDeployer.class);
    protected boolean deployed = false;
    protected WebBeansXMLConfigurator xmlConfigurator = null;
    protected boolean discoverEjb = false;
    private final WebBeansContext webBeansContext;

    public BeansDeployer(WebBeansXMLConfigurator xmlConfigurator, WebBeansContext webBeansContext) {
        this.xmlConfigurator = xmlConfigurator;
        this.webBeansContext = webBeansContext;
        String usage = this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService");
        this.discoverEjb = Boolean.parseBoolean(usage);
    }

    public void deploy(ScannerService scanner) {
        try {
            if (!this.deployed) {
                this.webBeansContext.getExtensionLoader().loadExtensionServices();
                JNDIService service = this.webBeansContext.getService(JNDIService.class);
                if (service instanceof DefaultJndiService) {
                    service.bind("java:comp/BeanManager", (Object)new InjectableBeanManager(this.webBeansContext.getBeanManagerImpl()));
                } else {
                    service.bind("java:comp/BeanManager", (Object)this.webBeansContext.getBeanManagerImpl().getReference());
                }
                this.webBeansContext.getBeanManagerImpl().addInternalBean(this.webBeansContext.getWebBeansUtil().getManagerBean());
                this.fireBeforeBeanDiscoveryEvent();
                this.deployFromXML(scanner);
                this.checkStereoTypes(scanner);
                this.configureDefaultBeans();
                this.deployFromClassPath(scanner);
                this.deployAdditionalAnnotatedTypes();
                this.checkSpecializations(scanner);
                this.fireAfterBeanDiscoveryEvent();
                this.validateInjectionPoints();
                this.fireAfterDeploymentValidationEvent();
                scanner.release();
                this.webBeansContext.getAnnotatedElementFactory().clear();
                this.deployed = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            WebBeansUtil.throwRuntimeExceptions(e);
        }
    }

    private void configureDefaultBeans() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        beanManager.addInternalBean(webBeansUtil.getConversationBean());
        beanManager.addInternalBean(webBeansUtil.getInjectionPointBean());
        beanManager.addInternalBean(webBeansUtil.getInstanceBean());
        beanManager.addInternalBean(webBeansUtil.getEventBean());
        OpenWebBeansJavaEEPlugin beanEeProvider = this.webBeansContext.getPluginLoader().getJavaEEPlugin();
        OpenWebBeansWebPlugin beanWebProvider = this.webBeansContext.getPluginLoader().getWebPlugin();
        if (beanEeProvider != null) {
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.common.beans.PrinicipalBean");
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.ValidatorBean");
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.ValidatorFactoryBean");
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.UserTransactionBean");
        } else if (beanWebProvider != null) {
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.common.beans.PrinicipalBean");
        }
    }

    private void addDefaultBean(BeanManagerImpl manager, String className) {
        Bean bean = null;
        Class<?> beanClass = ClassUtil.getClassFromName(className);
        if (beanClass != null) {
            bean = (Bean)ClassUtil.newInstance(this.webBeansContext, beanClass);
        }
        if (bean != null) {
            manager.addInternalBean(bean);
        }
    }

    private void fireBeforeBeanDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireEvent(new BeforeBeanDiscoveryImpl(this.webBeansContext), new Annotation[0]);
    }

    private void fireAfterBeanDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireEvent(new AfterBeanDiscoveryImpl(this.webBeansContext), new Annotation[0]);
        this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by AfterBeanDiscovery event observers. Look at logs for further details");
    }

    private void fireAfterDeploymentValidationEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireEvent(new AfterDeploymentValidationImpl(manager), new Annotation[0]);
        this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by AfterDeploymentValidation event observers. Look at logs for further details");
    }

    private void validateInjectionPoints() {
        logger.fine("Validation of injection points has started.");
        this.webBeansContext.getDecoratorsManager().validateDecoratorClasses();
        this.webBeansContext.getInterceptorsManager().validateInterceptorClasses();
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        Set<Bean<?>> beans = new HashSet();
        Set<Decorator<?>> decorators = manager.getDecorators();
        for (Decorator<?> decorator : decorators) {
            WebBeansDecorator wbDec = (WebBeansDecorator)decorator;
            beans.add(wbDec);
        }
        logger.fine("Validation of the decorator's injection points has started.");
        this.validate(beans);
        beans.clear();
        List<Interceptor<?>> interceptors = manager.getInterceptors();
        for (Interceptor<?> interceptor : interceptors) {
            WebBeansInterceptor wbInt = (WebBeansInterceptor)interceptor;
            beans.add(wbInt);
        }
        logger.fine("Validation of the interceptor's injection points has started.");
        this.validate(beans);
        beans.clear();
        beans = manager.getBeans();
        this.validate(beans);
        logger.info("INFO_0003");
    }

    private void validate(Set<Bean<?>> beans) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        if (beans != null && beans.size() > 0) {
            Stack<String> beanNames = new Stack<String>();
            for (Bean<?> bean : beans) {
                if (bean instanceof OwbBean && !((OwbBean)bean).isEnabled()) continue;
                String beanName = bean.getName();
                if (beanName != null) {
                    beanNames.push(beanName);
                }
                if (bean instanceof InjectionTargetBean) {
                    if (!(bean instanceof Decorator || bean instanceof Interceptor || bean instanceof NewBean)) {
                        this.webBeansContext.getDefinitionUtil().defineDecoratorStack((AbstractInjectionTargetBean)bean);
                    }
                    if (bean instanceof InterceptedMarker) {
                        this.webBeansContext.getDefinitionUtil().defineBeanInterceptorStack((AbstractInjectionTargetBean)bean);
                    }
                }
                this.checkPassivationScope(bean);
                Set injectionPoints = bean.getInjectionPoints();
                if (injectionPoints == null) continue;
                for (InjectionPoint injectionPoint : injectionPoints) {
                    if (!injectionPoint.isDelegate()) {
                        manager.validate(injectionPoint);
                        continue;
                    }
                    if (bean.getBeanClass().isAnnotationPresent(javax.decorator.Decorator.class) || this.webBeansContext.getBeanManagerImpl().containsCustomDecoratorClass(bean.getBeanClass())) continue;
                    throw new WebBeansConfigurationException("Delegate injection points can not defined by beans that are not decorator. Injection point : " + injectionPoint);
                }
            }
            this.validateBeanNames(beanNames);
            beanNames.clear();
        }
    }

    private void validateBeanNames(Stack<String> beanNames) {
        if (beanNames.size() > 0) {
            for (String beanName : beanNames) {
                for (String other : beanNames) {
                    String part = null;
                    int i = beanName.lastIndexOf(46);
                    if (i != -1) {
                        part = beanName.substring(0, i);
                    }
                    if (beanName.equals(other)) {
                        InjectionResolver resolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
                        Set<Bean<?>> beans = resolver.implResolveByName(beanName);
                        if (beans.size() <= 1 || (beans = resolver.findByAlternatives(beans)).size() <= 1) continue;
                        InjectionExceptionUtils.throwAmbiguousResolutionExceptionForBeanName(beans, beanName);
                        continue;
                    }
                    if (part == null || !part.equals(other)) continue;
                    throw new WebBeansConfigurationException("EL name of one bean is of the form x.y, where y is a valid bean EL name, and x is the EL name of the other bean for the bean name : " + beanName);
                }
            }
        }
    }

    protected void deployFromClassPath(ScannerService scanner) throws ClassNotFoundException {
        logger.fine("Deploying configurations from class files has started.");
        Set classIndex = scanner.getBeanClasses();
        if (classIndex != null) {
            AnnotatedElementFactory annotatedElementFactory = this.webBeansContext.getAnnotatedElementFactory();
            List<AnnotatedType<?>> additionalAnnotatedTypes = this.webBeansContext.getBeanManagerImpl().getAdditionalAnnotatedTypes();
            for (Class implClass : classIndex) {
                AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(implClass);
                if (null != annotatedType) {
                    this.deploySingleAnnotatedType(implClass, annotatedType);
                    if (!additionalAnnotatedTypes.contains(annotatedType)) continue;
                    additionalAnnotatedTypes.remove(annotatedType);
                    continue;
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Error creating managed bean " + implClass);
            }
        }
        logger.fine("Deploying configurations from class files has ended.");
    }

    private void deployAdditionalAnnotatedTypes() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        List<AnnotatedType<?>> annotatedTypes = beanManager.getAdditionalAnnotatedTypes();
        for (AnnotatedType<?> type : annotatedTypes) {
            Class implClass = type.getJavaClass();
            this.deploySingleAnnotatedType(implClass, type);
        }
    }

    private void deploySingleAnnotatedType(Class implClass, AnnotatedType annotatedType) {
        GProcessAnnotatedType processAnnotatedEvent = this.webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent(annotatedType);
        if (processAnnotatedEvent.isVeto()) {
            return;
        }
        boolean isDefined = this.defineManagedBean(implClass, processAnnotatedEvent);
        if (!isDefined && this.discoverEjb && EJBWebBeansConfigurator.isSessionBean(implClass, this.webBeansContext)) {
            logger.log(Level.FINE, "Found Enterprise Bean with class name : [{0}]", implClass.getName());
            this.defineEnterpriseWebBean(implClass, processAnnotatedEvent);
        }
    }

    protected void deployFromXML(ScannerService scanner) throws WebBeansDeploymentException {
        logger.fine("Deploying configurations from XML files has started.");
        Set xmlLocations = scanner.getBeanXmls();
        for (URL url : xmlLocations) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("OpenWebBeans BeansDeployer configuring: " + url.toExternalForm());
            }
            InputStream fis = null;
            try {
                fis = url.openStream();
                this.xmlConfigurator.configure(fis, url.toExternalForm(), scanner);
            }
            catch (IOException e) {
                throw new WebBeansDeploymentException("Error configuring: filename: " + url.toExternalForm(), e);
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deploying configurations from XML has ended successfully.");
        }
    }

    protected void checkSpecializations(ScannerService scanner) {
        logger.fine("Checking Specialization constraints has started.");
        try {
            Set beanClasses = scanner.getBeanClasses();
            if (beanClasses != null && beanClasses.size() > 0) {
                ArrayList superClassList = new ArrayList();
                ArrayList specialClassList = new ArrayList();
                for (Class specialClass : beanClasses) {
                    if (!AnnotationUtil.hasClassAnnotation(specialClass, Specializes.class)) continue;
                    Class superClass = specialClass.getSuperclass();
                    if (superClass.equals(Object.class)) {
                        throw new WebBeansConfigurationException(WebBeansLoggerFacade.getTokenString("EXCEPT_0003") + specialClass.getName() + WebBeansLoggerFacade.getTokenString("EXCEPT_0004"));
                    }
                    if (superClassList.contains(superClass)) {
                        throw new InconsistentSpecializationException(WebBeansLoggerFacade.getTokenString("EXCEPT_0005") + superClass.getName());
                    }
                    superClassList.add(superClass);
                    specialClassList.add(specialClass);
                }
                this.webBeansContext.getWebBeansUtil().configureSpecializations(specialClassList);
            }
            this.webBeansContext.getWebBeansUtil().configureProducerMethodSpecializations();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
        logger.fine("Checking Specialization constraints has ended.");
    }

    protected void checkPassivationScope(Bean<?> beanObj) {
        boolean validate = false;
        if (beanObj instanceof EnterpriseBeanMarker) {
            EnterpriseBeanMarker marker = (EnterpriseBeanMarker)beanObj;
            if (marker.isPassivationCapable()) {
                validate = true;
            }
        } else if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(beanObj.getScope())) {
            if (WebBeansUtil.isPassivationCapable(beanObj) == null) {
                if (!(beanObj instanceof AbstractProducerBean)) {
                    throw new WebBeansConfigurationException("Passivation scoped defined bean must be passivation capable, but bean : " + beanObj.toString() + " is not passivation capable");
                }
                validate = true;
            }
            validate = true;
        }
        if (validate) {
            ((OwbBean)beanObj).validatePassivationDependencies();
        }
    }

    protected void checkStereoTypes(ScannerService scanner) {
        logger.fine("Checking StereoType constraints has started.");
        this.addDefaultStereoTypes();
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        Set beanClasses = scanner.getBeanClasses();
        if (beanClasses != null && beanClasses.size() > 0) {
            for (Class beanClass : beanClasses) {
                Class stereoClass;
                if (!beanClass.isAnnotation() || !annotationManager.isStereoTypeAnnotation(stereoClass = beanClass)) continue;
                this.webBeansContext.getAnnotationManager().checkStereoTypeClass(stereoClass, stereoClass.getDeclaredAnnotations());
                StereoTypeModel model = new StereoTypeModel(this.webBeansContext, stereoClass);
                this.webBeansContext.getStereoTypeManager().addStereoTypeModel(model);
            }
        }
        logger.fine("Checking StereoType constraints has ended.");
    }

    protected void addDefaultStereoTypes() {
        StereoTypeModel model = new StereoTypeModel(this.webBeansContext, Model.class);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel(model);
    }

    protected <T> boolean defineManagedBean(Class<T> clazz, ProcessAnnotatedTypeImpl<T> processAnnotatedEvent) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        AnnotatedType<T> annotatedType = processAnnotatedEvent.getAnnotatedType();
        GProcessInjectionTarget processInjectionTargetEvent = null;
        if (this.webBeansContext.getWebBeansUtil().supportsJavaEeComponentInjections(clazz)) {
            processInjectionTargetEvent = this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEventForJavaEeComponents(clazz);
            this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessInjectionTarget event observers. Look at logs for further details");
            if (processInjectionTargetEvent.isSet()) {
                manager.putInjectionTargetWrapperForJavaEeComponents(clazz, new InjectionTargetWrapper(processInjectionTargetEvent.getInjectionTarget()));
            }
            this.webBeansContext.getAnnotationManager().checkInjectionPointForInjectInjectionPoint(clazz);
        }
        if (this.webBeansContext.getManagedBeanConfigurator().isManagedBean(clazz)) {
            this.webBeansContext.getManagedBeanConfigurator().checkManagedBeanCondition(clazz);
            ManagedBean<T> managedBean = new ManagedBean<T>(clazz, this.webBeansContext);
            ManagedBeanCreatorImpl<T> managedBeanCreator = new ManagedBeanCreatorImpl<T>(managedBean);
            boolean annotationTypeSet = false;
            if (processAnnotatedEvent.isModifiedAnnotatedType()) {
                annotationTypeSet = true;
                managedBean.setAnnotatedType(annotatedType);
                managedBeanCreator.setAnnotatedType(annotatedType);
                managedBeanCreator.setMetaDataProvider(BeanCreator.MetaDataProvider.THIRDPARTY);
            }
            GProcessInjectionTarget processInjectionTarget = null;
            if (processInjectionTargetEvent == null) {
                processInjectionTargetEvent = processInjectionTarget = this.webBeansContext.getWebBeansUtil().createProcessInjectionTargetEvent(managedBean);
            }
            if (WebBeansUtil.isAnnotatedTypeDecorator(annotatedType)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Found Managed Bean Decorator with class name : [{0}]", annotatedType.getJavaClass().getName());
                }
                if (annotationTypeSet) {
                    this.webBeansContext.getWebBeansUtil().defineDecorator(annotatedType);
                } else {
                    this.webBeansContext.getWebBeansUtil().defineDecorator(managedBeanCreator, processInjectionTargetEvent);
                }
            } else if (WebBeansUtil.isAnnotatedTypeInterceptor(annotatedType)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Found Managed Bean Interceptor with class name : [{0}]", annotatedType.getJavaClass().getName());
                }
                if (annotationTypeSet) {
                    this.webBeansContext.getWebBeansUtil().defineInterceptor(annotatedType);
                } else {
                    this.webBeansContext.getWebBeansUtil().defineInterceptor(managedBeanCreator, processInjectionTargetEvent);
                }
            } else {
                if (this.webBeansContext.getBeanManagerImpl().containsCustomDecoratorClass(annotatedType.getJavaClass()) || this.webBeansContext.getBeanManagerImpl().containsCustomInterceptorClass(annotatedType.getJavaClass())) {
                    return false;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Found Managed Bean with class name : [{0}]", annotatedType.getJavaClass().getName());
                }
                this.webBeansContext.getWebBeansUtil().defineManagedBean(managedBeanCreator, processInjectionTargetEvent, true);
            }
            if (processInjectionTarget != null && processInjectionTargetEvent != null) {
                InjectionTarget originalInjectionTarget = processInjectionTargetEvent.getInjectionTarget();
                InjectionTarget updatedInjectionTarget = this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEvent(processInjectionTarget).getInjectionTarget();
                if (updatedInjectionTarget != originalInjectionTarget) {
                    this.webBeansContext.getBeanManagerImpl().putInjectionTargetWrapper(managedBean, new InjectionTargetWrapper(updatedInjectionTarget));
                }
            }
            return true;
        }
        return false;
    }

    protected <T> void defineEnterpriseWebBean(Class<T> clazz, ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        InjectionTargetBean bean = (InjectionTargetBean)EJBWebBeansConfigurator.defineEjbBean(clazz, processAnnotatedTypeEvent, this.webBeansContext);
        this.webBeansContext.getWebBeansUtil().setInjectionTargetBeanEnableFlag(bean);
    }
}

