/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.WebBeansAnnotation;
import org.apache.webbeans.component.xml.XMLProducerBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.exception.definition.NonexistentTypeException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.inject.xml.XMLInjectionPointModel;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.xml.WebBeansErrorHandler;
import org.apache.webbeans.xml.WebBeansNameSpaceContainer;
import org.apache.webbeans.xml.WebBeansResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    private static WebBeansLogger log = WebBeansLogger.getLogger(XMLUtil.class);

    private XMLUtil() {
    }

    protected static boolean verifyNameSpace(Element element) {
        if (element.getNamespaceURI() == null) {
            return false;
        }
        NodeList ns = element.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            boolean ret;
            Node node = ns.item(i);
            if (!(node instanceof Element) || (ret = XMLUtil.verifyNameSpace((Element)node))) continue;
            return false;
        }
        return true;
    }

    protected static void updateNameSpacePackageMapping(Element root) {
        if (!XMLUtil.verifyNameSpace(root)) {
            throw new WebBeansConfigurationException(log.getTokenString("EXCEPT_0012"));
        }
        if (root.getNamespaceURI() != null) {
            WebBeansNameSpaceContainer.getInstance().addNewPackageNameSpace(root.getNamespaceURI());
        } else {
            String attr = root.getAttribute("xmlns");
            if (attr != null) {
                WebBeansNameSpaceContainer.getInstance().addNewPackageNameSpace(root.getNamespaceURI());
            }
        }
        NamedNodeMap attrs = root.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().toLowerCase().startsWith("xmlns")) continue;
            WebBeansNameSpaceContainer.getInstance().addNewPackageNameSpace(attr.getValue());
        }
    }

    public static Element getRootElement(InputStream stream) throws WebBeansException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(false);
            factory.setExpandEntityReferences(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new WebBeansErrorHandler());
            documentBuilder.setEntityResolver(new WebBeansResolver());
            Document doc = documentBuilder.parse(stream);
            Element root = doc.getDocumentElement();
            XMLUtil.updateNameSpacePackageMapping(root);
            return root;
        }
        catch (Exception e) {
            log.fatal("FATAL_0002", e);
            throw new WebBeansException(log.getTokenString("EXCEPT_0013"), e);
        }
    }

    public static Element getSpecStrictRootElement(InputStream stream) throws WebBeansException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(false);
            factory.setExpandEntityReferences(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new WebBeansErrorHandler());
            documentBuilder.setEntityResolver(new WebBeansResolver());
            Element root = documentBuilder.parse(stream).getDocumentElement();
            return root;
        }
        catch (Exception e) {
            log.fatal("FATAL_0002", e);
            throw new WebBeansException(log.getTokenString("EXCEPT_0013"), e);
        }
    }

    public static boolean isElementInNamespace(Element element, String namespace) {
        Asserts.assertNotNull(element, "element parameter can not be null");
        Asserts.assertNotNull(namespace, "namespace parameter can not be null");
        String nsURI = element.getNamespaceURI();
        return nsURI.equals(namespace);
    }

    public static boolean isElementInWebBeansNameSpace(Element element) {
        XMLUtil.nullCheckForElement(element);
        String ns = XMLUtil.getElementNameSpace(element);
        return ns != null && ns.equals("urn:java:ee");
    }

    public static boolean isElementInWebBeansNameSpaceWithName(Element element, String name) {
        String txtName;
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementInWebBeansNameSpace(element) && name.equals(txtName = element.getLocalName());
    }

    public static String getElementNameSpace(Element element) {
        XMLUtil.nullCheckForElement(element);
        return element.getNamespaceURI();
    }

    public static boolean isElementWebBeanDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return !XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Deploy") && !XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Interceptors") && !XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Decorators") && !XMLUtil.hasChildElement(element, "BindingType") && !XMLUtil.hasChildElement(element, "InterceptorBindingType") && !XMLUtil.hasChildElement(element, "StereoType");
    }

    public static boolean isElementBindingTypeDecleration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.hasChildElementWithWebBeansNameSpace(element, "BindingType");
    }

    public static boolean isElementInterceptorBindingTypeDecleration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.hasChildElementWithWebBeansNameSpace(element, "InterceptorBindingType");
    }

    public static boolean isElementStereoTypeDecleration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.hasChildElementWithWebBeansNameSpace(element, "StereoType");
    }

    public static boolean isElementDeployDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Deploy");
    }

    public static boolean isElementInterceptorsDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Interceptors");
    }

    public static boolean isElementDecoratosDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Decorators");
    }

    public static boolean isElementJMSDeclaration(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.isElementWebBeanDeclaration(element) && (XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Queue") || XMLUtil.isElementInWebBeansNameSpaceWithName(element, "Topic"));
    }

    public static boolean isElementHasDecoratesChild(Element element) {
        XMLUtil.nullCheckForElement(element);
        return XMLUtil.hasChildElementWithWebBeansNameSpace(element, "Decorates");
    }

    public static boolean isElementField(Element element) {
        XMLUtil.nullCheckForElement(element);
        NodeList ns = element.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (!(XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Inject") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Destructor") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Produces") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Disposes") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Observers") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Decorates"))) {
                Class<?> clazz = XMLUtil.getElementJavaType(child);
                if (clazz == null || !clazz.isAnnotation() || !AnnotationUtil.isInterceptorBindingAnnotation(clazz)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isElementMethod(Element element) {
        XMLUtil.nullCheckForElement(element);
        NodeList ns = element.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Inject") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Destructor") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Produces") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Disposes") || XMLUtil.isElementInWebBeansNameSpaceWithName(child, "Observers")) {
                return true;
            }
            Class<?> clazz = XMLUtil.getElementJavaType(child);
            if (clazz == null || !clazz.isAnnotation() || !AnnotationUtil.isInterceptorBindingAnnotation(clazz)) continue;
            return true;
        }
        return false;
    }

    public static String getName(Element element) {
        XMLUtil.nullCheckForElement(element);
        return element.getLocalName();
    }

    public static Class<?> getElementJavaType(Element element) {
        String ns = XMLUtil.getElementNameSpace(element);
        List<String> packageNames = WebBeansNameSpaceContainer.getInstance().getPackageNameFromNameSpace(ns);
        Class<?> clazz = null;
        Class<?> foundClazz = null;
        if (packageNames != null) {
            boolean found = false;
            for (String packageName : packageNames) {
                String className = packageName + XMLUtil.getName(element);
                clazz = ClassUtil.getClassFromName(className);
                if (clazz == null) continue;
                if (found) {
                    throw new DefinitionException(log.getTokenString("EXCEPT_0014") + clazz.getName());
                }
                foundClazz = clazz;
                found = true;
            }
        }
        return foundClazz;
    }

    public static String getElementJavaClassName(Element element) {
        Class<?> clazz = XMLUtil.getElementJavaType(element);
        if (clazz != null) {
            return clazz.getName();
        }
        return XMLUtil.getName(element);
    }

    private static void nullCheckForElement(Element element) {
        Asserts.assertNotNull(element, "element argument can not be null");
    }

    public static boolean hasChildElement(Element parent, String childName) {
        Asserts.assertNotNull(parent, "parent parameter can not be null");
        Asserts.assertNotNull(childName, "childName parameter can not be null");
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(childName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChildElementWithWebBeansNameSpace(Element parent, String childName) {
        Asserts.assertNotNull(parent, "parent parameter can not be null");
        Asserts.assertNotNull(childName, "childName parameter can not be null");
        Element child = null;
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(childName)) continue;
            child = (Element)node;
        }
        if (child == null) {
            return false;
        }
        return XMLUtil.isElementInWebBeansNameSpace(child);
    }

    public static XMLInjectionPointModel getInjectionPointModel(Element typeElement, String errorMessage) {
        Asserts.assertNotNull(typeElement, "typeElement parameter can not be null");
        if (typeElement.getLocalName().equals("Array")) {
            return XMLUtil.getArrayInjectionPointModel(typeElement, errorMessage);
        }
        return XMLUtil.getTypeInjectionPointModel(typeElement, errorMessage);
    }

    private static XMLInjectionPointModel getTypeInjectionPointModel(Element typeElement, String errorMessage) {
        int i;
        XMLInjectionPointModel model = null;
        Class<?> clazz = XMLUtil.getElementJavaType(typeElement);
        if (clazz == null) {
            throw new NonexistentTypeException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " is not found in the deployment");
        }
        if (clazz.isAnnotation() || clazz.isArray() || clazz.isEnum()) {
            throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " must be class or interface type");
        }
        TypeVariable<Class<?>>[] typeVariables = clazz.getTypeParameters();
        int actualTypeArgument = typeVariables.length;
        ArrayList typeArguments = new ArrayList();
        ArrayList<Annotation> bindingAnnots = new ArrayList<Annotation>();
        Class<?> definedBindingType = null;
        NodeList ns = typeElement.getChildNodes();
        for (i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            Class<?> actualType = XMLUtil.getElementJavaType(childElement);
            if (actualType == null) {
                throw new NonexistentTypeException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " is not found in the deployment");
            }
            if (actualType.isArray() || actualType.isEnum()) {
                throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " must be class or interface type");
            }
            if (actualType.isAnnotation()) {
                Class<?> clazz2 = actualType;
                if (!AnnotationUtil.isQualifierAnnotation(clazz2)) {
                    throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " is not a @Qualifier");
                }
                if (definedBindingType == null) {
                    definedBindingType = clazz2;
                } else if (definedBindingType.equals(clazz2)) {
                    throw new IllegalArgumentException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " is duplicated");
                }
                bindingAnnots.add(XMLUtil.getXMLDefinedAnnotationMember(childElement, clazz2, errorMessage));
                continue;
            }
            typeArguments.add(actualType);
        }
        if (actualTypeArgument != typeArguments.size()) {
            throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " actual type parameters size are not equals defined in the xml");
        }
        i = 0;
        for (Type type : typeArguments) {
            TypeVariable<Class<?>> typeVariable = typeVariables[i];
            Type[] bounds = typeVariable.getBounds();
            Class clazzBound = (Class)bounds[0];
            if (clazzBound.isAssignableFrom((Class)type)) continue;
            throw new WebBeansConfigurationException(errorMessage + log.getTokenString("TEXT_JAVA_TYPENAME") + XMLUtil.getElementJavaClassName(typeElement) + " actual type parameter bounded exception");
        }
        Type[] typeArray = new Type[typeArguments.size()];
        typeArray = typeArguments.toArray(typeArray);
        model = new XMLInjectionPointModel(clazz, typeArray);
        if (bindingAnnots.isEmpty()) {
            model.addBindingType((Annotation)((Object)new DefaultLiteral()));
        }
        for (Annotation annot : bindingAnnots) {
            model.addBindingType(annot);
        }
        return model;
    }

    public static Annotation getXMLDefinedAnnotationMember(Element annotationElement, Class<? extends Annotation> annotClazz, String errorMessage) {
        Method[] members;
        String value = annotationElement.getTextContent().trim();
        NamedNodeMap attrs = annotationElement.getAttributes();
        ArrayList<String> attrsNames = new ArrayList<String>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            attrsNames.add(attr.getName());
        }
        if (value != null && !value.equals("")) {
            if (attrsNames.contains("value")) {
                throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " can not have both element 'value' attribute and body text");
            }
        } else if (attrsNames.contains("value")) {
            try {
                SecurityUtil.doPrivilegedGetDeclaredMethod(annotClazz, "value", new Class[0]);
            }
            catch (SecurityException e) {
                throw new WebBeansException(e);
            }
            catch (NoSuchMethodException e) {
                throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " must have 'value' method");
            }
        }
        for (String attrName : attrsNames) {
            try {
                SecurityUtil.doPrivilegedGetDeclaredMethod(annotClazz, attrName, new Class[0]);
            }
            catch (SecurityException e) {
                throw new WebBeansException(e);
            }
            catch (NoSuchMethodException e) {
                throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " does not have member with name : " + attrName);
            }
        }
        for (Method member : members = ClassUtil.getDeclaredMethods(annotClazz)) {
            if (member.getDefaultValue() != null || value != null || attrsNames.contains(member.getName())) continue;
            throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " with non-default member method with name : " + member.getName() + " has to defined in the xml element attribute.");
        }
        return XMLUtil.createInjectionPointAnnotation(attrs, annotClazz, value, errorMessage);
    }

    private static WebBeansAnnotation createInjectionPointAnnotation(NamedNodeMap attrs, Class<? extends Annotation> annotClazz, String valueText, String errorMessage) {
        WebBeansAnnotation annotation = JavassistProxyFactory.createNewAnnotationProxy(annotClazz);
        boolean isValueAttrDefined = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            if (!isValueAttrDefined && attrName.equals("value")) {
                isValueAttrDefined = true;
            }
            Class<?> returnType = null;
            try {
                returnType = SecurityUtil.doPrivilegedGetDeclaredMethod(annotClazz, attrName, new Class[0]).getReturnType();
                Object value = null;
                if (returnType.isPrimitive()) {
                    value = ClassUtil.isValueOkForPrimitiveOrWrapper(returnType, attrValue);
                } else if (returnType.equals(String.class)) {
                    value = attrValue;
                } else if (returnType.equals(Class.class)) {
                    value = ClassUtil.getClassFromName(attrValue);
                } else if (returnType.isEnum()) {
                    value = ClassUtil.isValueOkForEnum(returnType, attrValue);
                } else {
                    throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " with member : " + attrName + " does not have sutiable member return type");
                }
                if (value == null) {
                    throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " with member : " + attrName + " value does not defined correctly");
                }
                annotation.setMemberValue(attrName, value);
                continue;
            }
            catch (SecurityException e) {
                throw new WebBeansException(e);
            }
            catch (NoSuchMethodException e) {
                throw new WebBeansConfigurationException(errorMessage + "Annotation with type : " + annotClazz.getName() + " does not have member with name : " + attrName);
            }
        }
        if (!isValueAttrDefined && valueText != null && !valueText.equals("")) {
            annotation.setMemberValue("value", valueText);
        }
        return annotation;
    }

    public static XMLInjectionPointModel getArrayInjectionPointModel(Element typeElement, String errorMessage) {
        XMLInjectionPointModel model = null;
        boolean isElementTypeDefined = false;
        HashSet<Annotation> anns = new HashSet<Annotation>();
        NodeList ns = typeElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            Class<?> clazz = XMLUtil.getElementJavaType(childElement);
            if (clazz == null) {
                throw new NonexistentTypeException(errorMessage + "Class with name : " + XMLUtil.getElementJavaClassName(childElement) + " is not found for Array element type");
            }
            if (clazz.isAnnotation()) {
                anns.add(XMLUtil.getXMLDefinedAnnotationMember(childElement, clazz, errorMessage));
                continue;
            }
            if (clazz.isArray() || clazz.isEnum()) {
                throw new WebBeansConfigurationException(errorMessage + "<Array> element child with Java type : " + XMLUtil.getElementJavaClassName(typeElement) + " must be class or interface type");
            }
            if (isElementTypeDefined) {
                throw new WebBeansConfigurationException(errorMessage + "<Array> element can not have more than one child element. It has one child element that declares its type");
            }
            model = new XMLInjectionPointModel(clazz);
            isElementTypeDefined = true;
        }
        if (anns.size() == 0) {
            model.addBindingType((Annotation)((Object)new DefaultLiteral()));
        }
        for (Annotation ann : anns) {
            model.addBindingType(ann);
        }
        return model;
    }

    public static <T> void defineXMLProducerApiTypeFromArrayElement(XMLProducerBean<T> component, Element typeElement, String errorMessage) {
        boolean isElementTypeDefined = false;
        HashSet<Annotation> anns = new HashSet<Annotation>();
        NodeList ns = typeElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            Class<?> clazz = XMLUtil.getElementJavaType(childElement);
            if (clazz == null) {
                throw new NonexistentTypeException(errorMessage + "Class with name : " + XMLUtil.getElementJavaClassName(childElement) + " is not found for Array element type");
            }
            if (clazz.isAnnotation()) {
                anns.add(XMLUtil.getXMLDefinedAnnotationMember(childElement, clazz, errorMessage));
                continue;
            }
            if (clazz.isArray() || clazz.isEnum()) {
                throw new WebBeansConfigurationException(errorMessage + "<Array> element child with Java type : " + XMLUtil.getElementJavaClassName(typeElement) + " must be class or interface type");
            }
            if (isElementTypeDefined) {
                throw new WebBeansConfigurationException(errorMessage + "<Array> element can not have more than one child element. It has one child element that declares its type");
            }
            isElementTypeDefined = true;
            component.addApiType(Array.newInstance(clazz, 0).getClass());
        }
        if (anns.size() == 0) {
            component.addQualifier((Annotation)((Object)new DefaultLiteral()));
        }
        for (Annotation ann : anns) {
            component.addQualifier(ann);
        }
    }
}

