/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jms;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.jms.JMSModel;
import org.apache.webbeans.util.Asserts;

public class JMSManager {
    private final Set<JMSModel> jmsModels = new CopyOnWriteArraySet<JMSModel>();

    public void clear() {
        this.jmsModels.clear();
    }

    public static JMSManager getInstance() {
        return (JMSManager)WebBeansFinder.getSingletonInstance(JMSManager.class.getName());
    }

    public void addJmsModel(JMSModel model) {
        Asserts.assertNotNull(model, "model parameter can not be null");
        this.jmsModels.add(model);
    }

    public JMSModel getModel(JMSModel.JMSType type, Annotation ... bindingTypes) {
        for (JMSModel model : this.jmsModels) {
            if (!model.getJmsType().equals((Object)type) || !Arrays.equals(bindingTypes, model.getBindings())) continue;
            return model;
        }
        return null;
    }
}

