/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.instance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.container.ResolutionUtil;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;

class InstanceImpl<T>
implements Instance<T>,
Serializable {
    private static final long serialVersionUID = -8401944412490389024L;
    private Type injectionClazz;
    private Set<Annotation> qualifierAnnotations = new HashSet<Annotation>();

    InstanceImpl(Type injectionClazz, Annotation ... annotations) {
        this.injectionClazz = injectionClazz;
        for (Annotation ann : annotations) {
            this.qualifierAnnotations.add(ann);
        }
    }

    public T get() {
        T instance = null;
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        Set<Bean<?>> beans = this.resolveBeans();
        ResolutionUtil.checkResolvedBeans(beans, ClassUtil.getClazz(this.injectionClazz), anns);
        Bean<?> bean = beans.iterator().next();
        instance = (T)BeanManagerImpl.getManager().getInstance(bean, null);
        return instance;
    }

    private Set<Bean<?>> resolveBeans() {
        Annotation[] anns = new Annotation[this.qualifierAnnotations.size()];
        anns = this.qualifierAnnotations.toArray(anns);
        InjectionResolver resolver = InjectionResolver.getInstance();
        Set<Bean<?>> beans = resolver.implResolveByType(this.injectionClazz, anns);
        return beans;
    }

    public boolean isAmbiguous() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() > 1;
    }

    public boolean isUnsatisfied() {
        Set<Bean<?>> beans = this.resolveBeans();
        return beans.size() == 0;
    }

    public Instance<T> select(Annotation ... qualifiers) {
        Annotation[] newQualifiersArray = this.getAdditionalQualifiers(qualifiers);
        InstanceImpl<T> newInstance = new InstanceImpl<T>(this.injectionClazz, newQualifiersArray);
        return newInstance;
    }

    private Annotation[] getAdditionalQualifiers(Annotation[] qualifiers) {
        AnnotationUtil.checkQualifierConditions(qualifiers);
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.qualifierAnnotations);
        if (qualifiers != null && qualifiers.length > 0) {
            for (Annotation annot : qualifiers) {
                if (newQualifiers.contains(annot)) {
                    throw new IllegalArgumentException("Duplicate Qualifier Exception, " + this.toString());
                }
                newQualifiers.add(annot);
            }
        }
        Annotation[] newQualifiersArray = new Annotation[newQualifiers.size()];
        newQualifiersArray = newQualifiers.toArray(newQualifiersArray);
        return newQualifiersArray;
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        AnnotationUtil.checkQualifierConditions(qualifiers);
        Type sub = subtype;
        if (sub == null) {
            sub = this.injectionClazz;
        }
        Annotation[] newQualifiers = this.getAdditionalQualifiers(qualifiers);
        InstanceImpl<T> newInstance = new InstanceImpl<T>(sub, newQualifiers);
        return newInstance;
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.select(subtype.getRawType(), qualifiers);
    }

    public Iterator<T> iterator() {
        Set<Bean<?>> beans = this.resolveBeans();
        HashSet instances = new HashSet();
        for (Bean<?> bean : beans) {
            Object instance = BeanManagerImpl.getManager().getInstance(bean, null);
            instances.add(instance);
        }
        return instances.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Instance<");
        builder.append(ClassUtil.getClazz(this.injectionClazz).getName());
        builder.append(">");
        builder.append(",with qualifier annotations {");
        boolean i = false;
        for (Annotation qualifier : this.qualifierAnnotations) {
            if (i) {
                builder.append(",");
            }
            builder.append(((Object)qualifier).toString());
        }
        builder.append("}");
        return builder.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.injectionClazz = (Type)in.readObject();
        int q = in.readByte();
        if (q != 0) {
            this.qualifierAnnotations = new HashSet<Annotation>();
            for (int i = 0; i < q; ++i) {
                this.qualifierAnnotations.add((Annotation)in.readObject());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.injectionClazz);
        out.writeByte(this.qualifierAnnotations.size());
        for (Annotation ann : this.qualifierAnnotations) {
            out.writeObject(ann);
        }
    }
}

