/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;

public class AlternativesManager {
    private final Set<Class<?>> alternatives = new HashSet();
    private final Set<Class<? extends Annotation>> stereoAlternatives = new HashSet<Class<? extends Annotation>>();

    public static AlternativesManager getInstance() {
        return (AlternativesManager)WebBeansFinder.getSingletonInstance(AlternativesManager.class.getName());
    }

    public void addStereoTypeAlternative(Class<?> alternative) {
        if (Annotation.class.isAssignableFrom(alternative)) {
            Class<?> stereo = alternative;
            boolean ok = false;
            if (AnnotationUtil.isStereoTypeAnnotation(stereo) && AnnotationUtil.hasClassAnnotation(stereo, Alternative.class)) {
                if (this.stereoAlternatives.contains(stereo)) {
                    throw new WebBeansConfigurationException("Given alternative class : " + alternative.getName() + " is already added as @Alternative");
                }
                ok = true;
                this.stereoAlternatives.add(stereo);
            }
            if (!ok) {
                throw new WebBeansConfigurationException("Given stereotype class : " + alternative.getName() + " is not annotated with @Alternative");
            }
        } else {
            throw new WebBeansConfigurationException("Given stereotype class : " + alternative.getName() + " is not an annotation");
        }
    }

    public void addClazzAlternative(Class<?> alternative) {
        if (AnnotationUtil.hasClassAnnotation(alternative, Alternative.class)) {
            if (this.alternatives.contains(alternative)) {
                throw new WebBeansConfigurationException("Given class : " + alternative.getName() + " is already added as @Alternative");
            }
        } else {
            throw new WebBeansConfigurationException("Given class : " + alternative.getName() + " is not annotated with @Alternative");
        }
        this.alternatives.add(alternative);
    }

    public boolean isClassAlternative(Class<?> clazz) {
        return this.alternatives.contains(clazz);
    }

    public boolean isStereoAlternative(Class<? extends Annotation> stereo) {
        return this.stereoAlternatives.contains(stereo);
    }

    public boolean isBeanHasAlternative(Bean<?> bean) {
        Class returnType = bean.getBeanClass();
        if (this.alternatives.contains(returnType)) {
            return true;
        }
        Set set = bean.getStereotypes();
        for (Class ann : set) {
            if (!this.stereoAlternatives.contains(ann)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.alternatives.clear();
        this.stereoAlternatives.clear();
    }
}

