/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class ObserverMethodImpl<T>
implements ObserverMethod<T> {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(ObserverMethodImpl.class);
    private final InjectionTargetBean<?> bean;
    private final Method observerMethod;
    private final boolean ifExist;
    private final Set<Annotation> observedQualifiers;
    private final Type observedEventType;
    private final TransactionPhase phase;
    private AnnotatedMethod<T> annotatedMethod = null;

    public ObserverMethodImpl(InjectionTargetBean<?> bean, Method observerMethod, boolean ifExist) {
        this.bean = bean;
        this.observerMethod = observerMethod;
        this.ifExist = ifExist;
        Annotation[] qualifiers = AnnotationUtil.getMethodFirstParameterQualifierWithGivenAnnotation(observerMethod, Observes.class);
        AnnotationUtil.checkQualifierConditions(qualifiers);
        this.observedQualifiers = new HashSet<Annotation>(qualifiers.length);
        for (Annotation qualifier : qualifiers) {
            this.observedQualifiers.add(qualifier);
        }
        this.observedEventType = AnnotationUtil.getTypeOfParameterWithGivenAnnotation(observerMethod, Observes.class);
        this.phase = EventUtil.getObserverMethodTransactionType(observerMethod);
    }

    public ObserverMethodImpl(InjectionTargetBean<?> bean, Method observerMethod, boolean ifExist, Annotation[] qualifiers, Type observedEventType) {
        this.bean = bean;
        this.observerMethod = observerMethod;
        this.ifExist = ifExist;
        this.observedQualifiers = new HashSet<Annotation>(qualifiers.length);
        for (Annotation qualifier : qualifiers) {
            this.observedQualifiers.add(qualifier);
        }
        this.observedEventType = observedEventType;
        this.phase = EventUtil.getObserverMethodTransactionType(observerMethod);
    }

    public void setAnnotatedMethod(AnnotatedMethod<T> annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
    }

    public void notify(T event) {
        block20: {
            this.logger.trace("Notifying with event payload : [{0}]", event);
            AbstractOwbBean baseComponent = (AbstractOwbBean)((Object)this.bean);
            AbstractOwbBean specializedComponent = null;
            Object object = null;
            CreationalContext creationalContext = null;
            List<ObserverParams> methodArgsMap = null;
            methodArgsMap = this.annotatedMethod == null ? this.getMethodArguments(event) : this.getAnnotatedMethodArguments(event);
            ObserverParams[] obargs = null;
            try {
                if (!this.observerMethod.isAccessible()) {
                    SecurityUtil.doPrivilegedSetAccessible(this.observerMethod, true);
                }
                obargs = new ObserverParams[methodArgsMap.size()];
                obargs = methodArgsMap.toArray(obargs);
                Object[] args = new Object[obargs.length];
                int i = 0;
                for (ObserverParams param : obargs) {
                    args[i++] = param.instance;
                }
                if (Modifier.isStatic(this.observerMethod.getModifiers())) {
                    this.observerMethod.invoke(object, args);
                    break block20;
                }
                BeanManagerImpl manager = BeanManagerImpl.getManager();
                specializedComponent = (AbstractOwbBean)WebBeansUtil.getMostSpecializedBean(manager, baseComponent);
                Context context = null;
                try {
                    context = manager.getContext(specializedComponent.getScope());
                }
                catch (ContextNotActiveException cnae) {
                    this.logger.info("INFO_0010", this.bean);
                    if (baseComponent.getScope().equals(Dependent.class) && object != null) {
                        baseComponent.destroy(object, creationalContext);
                    }
                    if (methodArgsMap != null) {
                        for (ObserverParams param : obargs) {
                            if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                            param.bean.destroy(param.instance, param.creational);
                        }
                    }
                    return;
                }
                creationalContext = manager.createCreationalContext(specializedComponent);
                if (this.ifExist && context.get((Contextual)specializedComponent) == null) {
                    return;
                }
                object = manager.getReference(specializedComponent, specializedComponent.getBeanClass(), creationalContext);
                if (object != null) {
                    this.observerMethod.invoke(object, args);
                }
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
            finally {
                if (baseComponent.getScope().equals(Dependent.class) && object != null) {
                    baseComponent.destroy(object, creationalContext);
                }
                if (methodArgsMap != null) {
                    for (ObserverParams param : obargs) {
                        if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                        param.bean.destroy(param.instance, param.creational);
                    }
                }
            }
        }
    }

    protected List<ObserverParams> getMethodArguments(Object event) {
        AnnotatedElementFactory annotatedElementFactory = AnnotatedElementFactory.getInstance();
        AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(this.bean.getReturnType());
        AnnotatedMethod annotatedMethod = annotatedElementFactory.newAnnotatedMethod(this.observerMethod, annotatedType);
        Type[] types = this.observerMethod.getGenericParameterTypes();
        Annotation[][] annots = this.observerMethod.getParameterAnnotations();
        ArrayList<ObserverParams> list = new ArrayList<ObserverParams>();
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        ObserverParams param = null;
        if (types.length > 0) {
            int i = 0;
            for (Type type : types) {
                Annotation[] annot = annots[i];
                boolean observesAnnotation = false;
                if (annot.length == 0) {
                    annot = new Annotation[]{new DefaultLiteral()};
                } else {
                    for (Annotation observersAnnot : annot) {
                        if (!observersAnnot.annotationType().equals(Observes.class)) continue;
                        param = new ObserverParams();
                        param.instance = event;
                        list.add(param);
                        observesAnnotation = true;
                        break;
                    }
                }
                if (!observesAnnotation) {
                    Annotation[] bindingTypes = AnnotationUtil.getQualifierAnnotations(annot);
                    AnnotatedParameter annotatedParameter = (AnnotatedParameter)annotatedMethod.getParameters().get(i);
                    InjectionPoint point = InjectionPointFactory.getPartialInjectionPoint(this.bean, type, this.observerMethod, (Annotated)annotatedParameter, bindingTypes);
                    Bean<?> injectedBean = InjectionResolver.getInstance().getInjectionPointBean(point);
                    if (WebBeansUtil.isDependent(injectedBean) && !InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(point.getType()))) {
                        InjectionPointBean.local.set(point);
                    }
                    CreationalContext<?> creational = manager.createCreationalContext(injectedBean);
                    Object instance = manager.getInstance(injectedBean, creational);
                    param = new ObserverParams();
                    param.isBean = true;
                    param.creational = creational;
                    param.instance = instance;
                    param.bean = injectedBean;
                    list.add(param);
                }
                ++i;
            }
        }
        return list;
    }

    protected List<ObserverParams> getAnnotatedMethodArguments(Object event) {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        ArrayList<ObserverParams> list = new ArrayList<ObserverParams>();
        List parameters = this.annotatedMethod.getParameters();
        ObserverParams param = null;
        for (AnnotatedParameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Observes.class)) {
                param = new ObserverParams();
                param.instance = event;
                list.add(param);
                continue;
            }
            Annotation[] bindingTypes = AnnotationUtil.getQualifierAnnotations(AnnotationUtil.getAnnotationsFromSet(parameter.getAnnotations()));
            InjectionPoint point = InjectionPointFactory.getPartialInjectionPoint(this.bean, parameter.getBaseType(), parameter.getDeclaringCallable().getJavaMember(), (Annotated)parameter, bindingTypes);
            Bean<?> injectedBean = InjectionResolver.getInstance().getInjectionPointBean(point);
            if (WebBeansUtil.isDependent(injectedBean) && !InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(point.getType()))) {
                InjectionPointBean.local.set(point);
            }
            CreationalContext<?> creational = manager.createCreationalContext(injectedBean);
            Object instance = manager.getInstance(injectedBean, creational);
            param = new ObserverParams();
            param.isBean = true;
            param.creational = creational;
            param.instance = instance;
            param.bean = injectedBean;
            list.add(param);
        }
        return list;
    }

    public Class<?> getBeanClass() {
        AbstractInjectionTargetBean abs = (AbstractInjectionTargetBean)this.bean;
        return abs.getBeanClass();
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.observedQualifiers;
    }

    public Type getObservedType() {
        return this.observedEventType;
    }

    public Reception getReception() {
        return this.ifExist ? Reception.IF_EXISTS : Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return this.phase;
    }

    public Method getObserverMethod() {
        return this.observerMethod;
    }

    private static class ObserverParams {
        private Bean<Object> bean;
        private Object instance;
        private CreationalContext<Object> creational;
        private boolean isBean = false;

        private ObserverParams() {
        }
    }
}

