/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.CustomContextImpl;
import org.apache.webbeans.context.CustomPassivatingContextImpl;
import org.apache.webbeans.context.type.ContextTypes;
import org.apache.webbeans.corespi.ServiceLoader;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.util.WebBeansUtil;

public final class ContextFactory {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(ContextFactory.class);
    private static ConcurrentHashMap<ClassLoader, ContextsService> contextServices = new ConcurrentHashMap();

    private ContextFactory() {
        throw new UnsupportedOperationException();
    }

    public static void cleanUpContextFactory() {
        ClassLoader cl = WebBeansUtil.getCurrentClassLoader();
        contextServices.remove(cl);
    }

    private static ContextsService getContextsService() {
        ClassLoader cl = WebBeansUtil.getCurrentClassLoader();
        ContextsService cs = contextServices.get(cl);
        if (cs == null) {
            cs = ServiceLoader.getService(ContextsService.class);
            contextServices.put(cl, cs);
        }
        return cs;
    }

    public static void initRequestContext(Object request) {
        try {
            ContextsService contextService = ContextFactory.getContextsService();
            contextService.startContext(RequestScoped.class, request);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public static Context getCustomContext(Context context) {
        if (BeanManagerImpl.getManager().isPassivatingScope(context.getScope())) {
            return new CustomPassivatingContextImpl(context);
        }
        return new CustomContextImpl(context);
    }

    public static void destroyRequestContext(Object request) {
        ContextsService contextService = ContextFactory.getContextsService();
        contextService.endContext(RequestScoped.class, request);
    }

    public static void initSessionContext(Object session) {
        try {
            ContextsService contextService = ContextFactory.getContextsService();
            contextService.startContext(SessionScoped.class, session);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public static void destroySessionContext(Object session) {
        ContextsService contextService = ContextFactory.getContextsService();
        contextService.endContext(SessionScoped.class, session);
    }

    public static void initApplicationContext(Object parameter) {
        try {
            ContextsService contextService = ContextFactory.getContextsService();
            contextService.startContext(ApplicationScoped.class, parameter);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public static void destroyApplicationContext(Object parameter) {
        ContextsService contextService = ContextFactory.getContextsService();
        contextService.endContext(ApplicationScoped.class, parameter);
    }

    public static void initSingletonContext(Object parameter) {
        try {
            ContextsService contextService = ContextFactory.getContextsService();
            contextService.startContext(Singleton.class, parameter);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public static void destroySingletonContext(Object parameter) {
        ContextsService contextService = ContextFactory.getContextsService();
        contextService.endContext(Singleton.class, parameter);
    }

    public static void initConversationContext(Object context) {
        try {
            ContextsService contextService = ContextFactory.getContextsService();
            contextService.startContext(ConversationScoped.class, context);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public static void destroyConversationContext() {
        ContextsService contextService = ContextFactory.getContextsService();
        contextService.endContext(ConversationScoped.class, null);
    }

    public static Context getStandardContext(ContextTypes type) throws ContextNotActiveException {
        ContextsService contextService = ContextFactory.getContextsService();
        return ContextFactory.getStandardContext(contextService, type);
    }

    public static Context getStandardContext(ContextsService contextService, ContextTypes type) throws ContextNotActiveException {
        Context context = null;
        switch (type.getCardinal()) {
            case 0: {
                context = contextService.getCurrentContext(RequestScoped.class);
                break;
            }
            case 1: {
                context = contextService.getCurrentContext(SessionScoped.class);
                break;
            }
            case 2: {
                context = contextService.getCurrentContext(ApplicationScoped.class);
                break;
            }
            case 3: {
                context = contextService.getCurrentContext(ConversationScoped.class);
                break;
            }
            case 4: {
                context = contextService.getCurrentContext(Dependent.class);
                break;
            }
            case 5: {
                context = contextService.getCurrentContext(Singleton.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("There is no such a standard context with context id=" + type.getCardinal());
            }
        }
        return context;
    }

    public static Context getStandardContext(Class<? extends Annotation> scopeType) {
        ContextsService contextService = ContextFactory.getContextsService();
        return contextService.getCurrentContext(scopeType);
    }

    public static void activateContext(Class<? extends Annotation> scopeType) {
        ContextsService contextService = ContextFactory.getContextsService();
        contextService.activateContext(scopeType);
    }

    public static void deActivateContext(Class<? extends Annotation> scopeType) {
        ContextsService contextService = ContextFactory.getContextsService();
        contextService.deActivateContext(scopeType);
    }
}

