/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import org.apache.webbeans.corespi.DefaultSingletonService;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.spi.SingletonService;
import org.apache.webbeans.util.WebBeansUtil;

public final class WebBeansFinder {
    private static SingletonService singletonService = new DefaultSingletonService();
    private static boolean customSingletonServiceUsed = false;

    private WebBeansFinder() {
    }

    public static Object getSingletonInstance(String singletonName) {
        return WebBeansFinder.getSingletonInstance(singletonName, WebBeansUtil.getCurrentClassLoader());
    }

    public static Object getSingletonInstance(String singletonName, Object key) {
        return singletonService.get(key, singletonName);
    }

    public static Object getExistingSingletonInstance(String singletonName, Object key) {
        return singletonService.getExist(key, singletonName);
    }

    public static void clearInstances(Object key) {
        singletonService.clear(key);
    }

    public static Object getSingletonClassLoader(Object singletonInstance) {
        return singletonService.getKey(singletonInstance);
    }

    public static void setSingletonService(SingletonService singletonSvc) {
        if (customSingletonServiceUsed && !singletonService.equals(singletonSvc)) {
            throw new WebBeansConfigurationException("Already using another custom SingletonService!");
        }
        singletonService = singletonSvc;
        customSingletonServiceUsed = true;
    }
}

