/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwebbeans.gradle.shadow;

import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.transformers.Transformer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.file.FileTreeElement;

public class OpenWebBeansPropertiesTransformer
implements Transformer {
    private final List<Properties> configurations = new ArrayList<Properties>();
    private String resource = "META-INF/openwebbeans/openwebbeans.properties";
    private String ordinalKey = "configuration.ordinal";
    private int defaultOrdinal = 100;
    private boolean reverseOrder = false;

    public boolean canTransformResource(FileTreeElement s) {
        return this.resource.equals(s.getPath());
    }

    public void transform(String s, InputStream inputStream, List<Relocator> list) {
        Properties p = new Properties();
        try {
            p.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.configurations.add(p);
    }

    public boolean hasTransformedResource() {
        return !this.configurations.isEmpty();
    }

    public void modifyOutputStream(ZipOutputStream zipOutputStream) {
        Properties out = OpenWebBeansPropertiesTransformer.mergeProperties(this.sortProperties(this.configurations));
        try {
            zipOutputStream.putNextEntry(new ZipEntry(this.resource));
            out.store((OutputStream)zipOutputStream, "# gradle " + this.resource + " merge");
            zipOutputStream.closeEntry();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setOrdinalKey(String ordinalKey) {
        this.ordinalKey = ordinalKey;
    }

    public void setDefaultOrdinal(int defaultOrdinal) {
        this.defaultOrdinal = defaultOrdinal;
    }

    private List<Properties> sortProperties(List<Properties> allProperties) {
        ArrayList<Properties> sortedProperties = new ArrayList<Properties>();
        for (Properties p : allProperties) {
            int i;
            int configOrder = this.getConfigurationOrdinal(p);
            for (i = 0; i < sortedProperties.size(); ++i) {
                int listConfigOrder = this.getConfigurationOrdinal((Properties)sortedProperties.get(i));
                if (!this.reverseOrder && listConfigOrder > configOrder || this.reverseOrder && listConfigOrder < configOrder) break;
            }
            sortedProperties.add(i, p);
        }
        return sortedProperties;
    }

    private int getConfigurationOrdinal(Properties p) {
        String configOrderString = p.getProperty(this.ordinalKey);
        if (configOrderString != null && configOrderString.length() > 0) {
            return Integer.parseInt(configOrderString);
        }
        return this.defaultOrdinal;
    }

    private static Properties mergeProperties(List<Properties> sortedProperties) {
        Properties mergedProperties = new Properties();
        for (Properties p : sortedProperties) {
            mergedProperties.putAll((Map<?, ?>)p);
        }
        return mergedProperties;
    }
}

