/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Remove;
import javax.enterprise.context.spi.CreationalContext;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;

public class OpenEjbBean<T>
extends BaseEjbBean<T> {
    private DeploymentInfo deploymentInfo;

    public OpenEjbBean(Class<T> ejbClassType) {
        super(ejbClassType);
    }

    public void setDeploymentInfo(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    protected T getInstance(CreationalContext<T> creationalContext) {
        T instance = null;
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        Context jndiContext = containerSystem.getJNDIContext();
        DeploymentInfo deploymentInfo = this.getDeploymentInfo();
        try {
            if (this.iface != null) {
                InterfaceType type = deploymentInfo.getInterfaceType(this.iface);
                if (!type.equals((Object)InterfaceType.BUSINESS_LOCAL)) {
                    throw new IllegalArgumentException("Interface type is not legal business local interface for session bean class : " + this.getReturnType().getName());
                }
            } else {
                this.iface = this.deploymentInfo.getBusinessLocalInterface();
            }
            String jndiName = "java:openejb/Deployment/" + JndiBuilder.format((Object)deploymentInfo.getDeploymentID(), (String)this.iface.getName());
            instance = this.iface.cast(jndiContext.lookup(jndiName));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return instance;
    }

    public String getEjbName() {
        return this.deploymentInfo.getEjbName();
    }

    public List<Class<?>> getBusinessLocalInterfaces() {
        ArrayList clazzes = new ArrayList();
        List cl = this.deploymentInfo.getBusinessLocalInterfaces();
        if (cl != null && !cl.isEmpty()) {
            for (Class c : cl) {
                clazzes.add(c);
            }
        }
        return clazzes;
    }

    public List<Method> getRemoveMethods() {
        return this.findRemove(this.deploymentInfo.getBeanClass(), this.deploymentInfo.getBusinessLocalInterface());
    }

    private final List<Method> findRemove(Class beanClass, Class beanInterface) {
        Method[] methods;
        ArrayList<Method> toReturn = new ArrayList<Method>();
        for (Method method : methods = beanClass.getMethods()) {
            Remove annotation = method.getAnnotation(Remove.class);
            if (annotation == null) continue;
            try {
                Method interfaceMethod = beanInterface.getMethod(method.getName(), method.getParameterTypes());
                toReturn.add(interfaceMethod);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return toReturn;
    }
}

