/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.resource;

import java.lang.annotation.Annotation;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.api.ResourceReference;
import org.apache.webbeans.ejb.resource.ResourceInjectionProcessor;
import org.apache.webbeans.logger.WebBeansLogger;

public class ResourceFactory {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(ResourceFactory.class);
    private static ResourceFactory factory = null;
    private ResourceInjectionProcessor processor = null;
    private static Context context = null;

    public static ResourceFactory getInstance() {
        if (factory == null) {
            factory = new ResourceFactory();
            ResourceFactory.factory.processor = new ResourceInjectionProcessor(context);
        }
        return factory;
    }

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) throws Exception {
        return this.processor.getResourceReference(resourceReference);
    }

    public void close() {
        try {
            context.close();
            factory = null;
            this.processor = null;
        }
        catch (NamingException e) {
            logger.warn("Unable to clear ResourceFactory", (Throwable)e);
        }
    }

    static {
        try {
            context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
        }
        catch (Exception e) {
            context = null;
        }
    }
}

