/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.proxy;

import java.lang.reflect.Method;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.ejb.component.EjbBean;
import org.apache.webbeans.ejb.interceptor.OpenWebBeansEjbInterceptor;

public class EjbBeanProxyHandler
implements MethodHandler {
    private EjbBean<?> ejbBean;
    private CreationalContext<?> creationalContext;

    public EjbBeanProxyHandler(EjbBean<?> ejbBean, CreationalContext<?> creationalContext) {
        this.ejbBean = ejbBean;
        this.creationalContext = creationalContext;
    }

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments) throws Exception {
        if (this.ejbBean.getEjbType().equals((Object)SessionBeanType.STATEFUL) && this.checkEjbRemoveMethod(method)) {
            this.ejbBean.setRemoveStatefulInstance(true);
        }
        OpenWebBeansEjbInterceptor.setThreadLocal(this.ejbBean, this.creationalContext);
        Context webbeansContext = BeanManagerImpl.getManager().getContext(this.ejbBean.getScope());
        Object webbeansInstance = webbeansContext.get(this.ejbBean, this.creationalContext);
        Object result = method.invoke(webbeansInstance, arguments);
        OpenWebBeansEjbInterceptor.unsetThreadLocal();
        return result;
    }

    private boolean checkEjbRemoveMethod(Method method) {
        List removeMethods = this.ejbBean.getDeploymentInfo().getRemoveMethods();
        if (removeMethods.contains(method)) {
            if (this.ejbBean.getScope() != Dependent.class) {
                throw new UnsupportedOperationException("Can not call EJB Statefull Bean Remove Method without scoped @Dependent");
            }
            return true;
        }
        return false;
    }
}

