/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.arquillian.standalone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.webbeans.arquillian.standalone.OwbArquillianScannerService;
import org.apache.webbeans.arquillian.standalone.OwbArquillianSingletonService;
import org.apache.webbeans.arquillian.standalone.OwbSWClassLoader;
import org.apache.webbeans.arquillian.standalone.OwbStandaloneConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.SingletonService;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class OwbStandaloneContainer
implements DeployableContainer<OwbStandaloneConfiguration> {
    private static final Logger LOG = Logger.getLogger(OwbStandaloneContainer.class.getName());
    @Inject
    @DeploymentScoped
    private InstanceProducer<ContainerLifecycle> lifecycleProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<BeanManager> beanManagerProducer;
    private OwbArquillianSingletonService singletonService;
    private WebBeansContext webBeansContext;
    private final ThreadLocal<ClassLoader> originalLoader = new ThreadLocal();
    private boolean useOnlyArchiveResources;
    private Collection<String> useOnlyArchiveResourcesExcludes = new ArrayList<String>();

    public Class<OwbStandaloneConfiguration> getConfigurationClass() {
        return OwbStandaloneConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public void setup(OwbStandaloneConfiguration owbStandaloneConfiguration) {
        LOG.fine("OpenWebBeans Arquillian setup started");
        this.singletonService = new OwbArquillianSingletonService(owbStandaloneConfiguration.properties());
        WebBeansFinder.setSingletonService((SingletonService)this.singletonService);
        this.useOnlyArchiveResources = owbStandaloneConfiguration.isUseOnlyArchiveResources();
        if (this.useOnlyArchiveResources && owbStandaloneConfiguration.getUseOnlyArchiveResourcesExcludes() != null) {
            this.useOnlyArchiveResourcesExcludes = Arrays.asList(owbStandaloneConfiguration.getUseOnlyArchiveResourcesExcludes().split(","));
        }
    }

    public void start() throws LifecycleException {
        LOG.fine("OpenWebBeans Arquillian starting");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        this.singletonService.initOwb();
        this.webBeansContext = WebBeansContext.getInstance();
        LOG.fine("OpenWebBeans Arquillian starting deployment");
        ContainerLifecycle lifecycle = (ContainerLifecycle)this.webBeansContext.getService(ContainerLifecycle.class);
        this.lifecycleProducer.set((Object)lifecycle);
        OwbArquillianScannerService dummyScannerService = (OwbArquillianScannerService)this.webBeansContext.getScannerService();
        dummyScannerService.setArchive(archive);
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        this.originalLoader.set(parentLoader);
        Thread.currentThread().setContextClassLoader(new OwbSWClassLoader(parentLoader, archive, this.useOnlyArchiveResources, this.useOnlyArchiveResourcesExcludes));
        lifecycle.startApplication(null);
        this.beanManagerProducer.set((Object)lifecycle.getBeanManager());
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        ClassLoader current;
        LOG.fine("OpenWebBeans Arquillian undeploying");
        OwbArquillianScannerService dummyScannerService = (OwbArquillianScannerService)this.webBeansContext.getScannerService();
        dummyScannerService.clear();
        ContainerLifecycle lifecycle = (ContainerLifecycle)this.lifecycleProducer.get();
        if (lifecycle != null) {
            lifecycle.stopApplication(null);
        }
        if (OwbSWClassLoader.class.isInstance(current = Thread.currentThread().getContextClassLoader())) {
            try {
                ((OwbSWClassLoader)OwbSWClassLoader.class.cast(current)).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Thread.currentThread().setContextClassLoader(this.originalLoader.get());
        this.originalLoader.remove();
    }

    public void stop() throws LifecycleException {
        LOG.fine("OpenWebBeans Arquillian stopping");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Deployment of Descriptors is not supported in owb-arquillian-standalone!");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Deployment of Descriptors is not supported in owb-arquillian-standalone!");
    }
}

