/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.arquillian.standalone;

import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.webbeans.arquillian.standalone.OwbArquillianScannerService;
import org.apache.webbeans.arquillian.standalone.OwbArquillianSingletonService;
import org.apache.webbeans.arquillian.standalone.OwbStandaloneConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.SingletonService;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwbStandaloneContainer
implements DeployableContainer<OwbStandaloneConfiguration> {
    private static final Logger LOG = Logger.getLogger(OwbStandaloneContainer.class.getName());
    @Inject
    @DeploymentScoped
    private InstanceProducer<ContainerLifecycle> lifecycleProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<BeanManager> beanManagerProducer;
    private OwbArquillianSingletonService singletonService;
    private WebBeansContext webBeansContext;

    public Class<OwbStandaloneConfiguration> getConfigurationClass() {
        return OwbStandaloneConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public void setup(OwbStandaloneConfiguration owbStandaloneConfiguration) {
        LOG.fine("OpenWebBeans Arquillian setup started");
        this.singletonService = new OwbArquillianSingletonService();
        WebBeansFinder.setSingletonService((SingletonService)this.singletonService);
    }

    public void start() throws LifecycleException {
        LOG.fine("OpenWebBeans Arquillian starting");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        this.singletonService.initOwb();
        this.webBeansContext = WebBeansContext.getInstance();
        LOG.fine("OpenWebBeans Arquillian starting deployment");
        ContainerLifecycle lifecycle = (ContainerLifecycle)this.webBeansContext.getService(ContainerLifecycle.class);
        this.lifecycleProducer.set((Object)lifecycle);
        this.beanManagerProducer.set((Object)lifecycle.getBeanManager());
        OwbArquillianScannerService dummyScannerService = (OwbArquillianScannerService)this.webBeansContext.getScannerService();
        dummyScannerService.setArchive(archive);
        lifecycle.startApplication(null);
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        LOG.fine("OpenWebBeans Arquillian undeploying");
        OwbArquillianScannerService dummyScannerService = (OwbArquillianScannerService)this.webBeansContext.getScannerService();
        dummyScannerService.clear();
        ContainerLifecycle lifecycle = (ContainerLifecycle)this.lifecycleProducer.get();
        if (lifecycle != null) {
            lifecycle.stopApplication(null);
        }
    }

    public void stop() throws LifecycleException {
        LOG.fine("OpenWebBeans Arquillian stopping");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Deployment of Descriptors is not supported in owb-arquillian-standalone!");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Deployment of Descriptors is not supported in owb-arquillian-standalone!");
    }
}

