/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.arquillian.standalone;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwbArquillianScannerService
implements ScannerService {
    private static final String WEB_INF_CLASS_FOLDER = "/WEB-INF/classes/";
    private boolean beansXmlBdaScanningEnabled = false;
    private Archive archive;
    private Set<URL> beansXmls = new HashSet<URL>();
    private Set<Class<?>> beanClasses = new HashSet();

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }

    public void init(Object object) {
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    @Deprecated
    public Set<String> getAllAnnotations(String className) {
        return Collections.EMPTY_SET;
    }

    public void scan() {
        if (this.archive == null) {
            return;
        }
        if (this.archive instanceof JavaArchive) {
            this.scanJarArchive((JavaArchive)this.archive);
        } else if (this.archive instanceof WebArchive) {
            this.scanWebArchive((WebArchive)this.archive);
        } else {
            throw new IllegalStateException("Scanning of Archive " + this.archive.getClass().getName() + "Not yet implemented");
        }
    }

    public Set<URL> getBeanXmls() {
        return this.beansXmls;
    }

    public Set<Class<?>> getBeanClasses() {
        return this.beanClasses;
    }

    public void release() {
        this.beansXmls.clear();
        this.beanClasses.clear();
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.beansXmlBdaScanningEnabled;
    }

    private void scanWebArchive(WebArchive archive) {
        URL metainfBeansXmlUrl;
        URL webBeansXmlUrl = this.getBeanXmlUrl((Archive)archive, "WEB-INF/beans.xml");
        if (webBeansXmlUrl != null) {
            this.beansXmls.add(webBeansXmlUrl);
        }
        if ((metainfBeansXmlUrl = this.getBeanXmlUrl((Archive)archive, "/WEB-INF/classes/META-INF/beans.xml")) != null) {
            this.beansXmls.add(webBeansXmlUrl);
        }
        if (metainfBeansXmlUrl != null || webBeansXmlUrl != null) {
            Map classes = archive.getContent(Filters.include((String)"/WEB-INF/classes/.*\\.class"));
            this.scanClasses(classes, WEB_INF_CLASS_FOLDER);
        }
        Map jars = archive.getContent(Filters.include((String)"/WEB-INF/lib/.*\\.jar"));
        for (Map.Entry jarEntry : jars.entrySet()) {
            ArchiveAsset archiveAsset = (ArchiveAsset)((Node)jarEntry.getValue()).getAsset();
            JavaArchive jarArchive = (JavaArchive)archiveAsset.getArchive();
            this.scanJarArchive(jarArchive);
        }
    }

    private void scanJarArchive(JavaArchive archive) {
        URL beansXmlUrl = this.getBeanXmlUrl((Archive)archive, "META-INF/beans.xml");
        if (beansXmlUrl == null) {
            return;
        }
        this.beansXmls.add(beansXmlUrl);
        Map classes = archive.getContent(Filters.include((String)".*\\.class"));
        this.scanClasses(classes, null);
    }

    private void scanClasses(Map<ArchivePath, Node> classes, String classBasePath) {
        for (Map.Entry<ArchivePath, Node> classEntry : classes.entrySet()) {
            String className = classEntry.getKey().get();
            if (classBasePath != null && className.startsWith(WEB_INF_CLASS_FOLDER)) {
                className = className.substring(WEB_INF_CLASS_FOLDER.length());
            }
            if (className.startsWith("/")) {
                className = className.substring(1);
            }
            className = className.substring(0, className.length() - ".class".length());
            className = className.replace('/', '.');
            try {
                Class<?> beanClass = Class.forName(className);
                this.beanClasses.add(beanClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not scan class", cnfe);
            }
        }
    }

    private URL getBeanXmlUrl(Archive archive, String beansXmlPath) {
        final Node beansXml = archive.get(beansXmlPath);
        if (beansXml == null) {
            return null;
        }
        try {
            String urlLocation = "archive://" + archive.getName() + "/" + beansXmlPath;
            return new URL(null, urlLocation, new URLStreamHandler(){

                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        public void connect() throws IOException {
                        }

                        public InputStream getInputStream() throws IOException {
                            return beansXml.getAsset().openStream();
                        }
                    };
                }
            });
        }
        catch (Exception e) {
            RuntimeException runtimeException = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("Error while parsing beans.xml location", e);
            throw runtimeException;
        }
    }

    public void clear() {
        this.archive = null;
        this.beansXmls = new HashSet<URL>();
        this.beanClasses = new HashSet();
    }
}

