/*
 * Decompiled with CFR 0.152.
 */
package opennlp.dl.doccat;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record DocumentCategorizerConfig(Map<String, String> id2label) {
    private final Map<String, String> id2label;
    private static final Pattern ID_TO_LABEL_PATTERN = Pattern.compile("\"id2label\"\\s*:\\s*\\{(.*?)\\}", 32);
    private static final Pattern ENTRY_PATTERN = Pattern.compile("\"([^\"]+)\"\\s*:\\s*\"(.*?)\"");

    public Map<String, String> id2label() {
        return Collections.unmodifiableMap(this.id2label);
    }

    public static DocumentCategorizerConfig fromJson(String json) {
        Objects.requireNonNull(json, "json must not be null");
        HashMap<String, String> id2label = new HashMap<String, String>();
        Matcher matcher = ID_TO_LABEL_PATTERN.matcher(json);
        if (matcher.find()) {
            String id2labelContent = matcher.group(1);
            Matcher entryMatcher = ENTRY_PATTERN.matcher(id2labelContent);
            while (entryMatcher.find()) {
                String key = entryMatcher.group(1);
                String value = entryMatcher.group(2);
                id2label.put(key, value);
            }
        }
        return new DocumentCategorizerConfig(id2label);
    }
}

