/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.control;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.client.Options;
import org.apache.openejb.loader.Files;
import org.apache.openejb.server.control.Context;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.OutputScanner;
import org.apache.openejb.util.Pipe;

public class StandaloneServer {
    private final File home;
    private final File base;
    private final File java;
    private final File openejbJar;
    private boolean debug;
    private int debugPort = 5005;
    private boolean profile;
    private volatile Process process;
    private final List<String> jvmOpts = new ArrayList<String>();
    private final Properties properties = new Properties();
    private boolean verbose = false;
    private OutputStream out = System.out;
    private Options options = new Options(this.properties);
    private Context context = new Context();
    static final List<StandaloneServer> kill = new ArrayList<StandaloneServer>();

    public StandaloneServer(File home) {
        this(home, home);
    }

    public StandaloneServer(File home, File base) {
        this.home = home;
        this.base = base;
        File lib = Files.readable((File)Files.dir((File)Files.exists((File)new File(home, "lib"))));
        this.openejbJar = Files.readable((File)Files.file((File)Files.select((File)lib, (String)"openejb-core.*.jar")));
        File javaagentJar = Files.readable((File)Files.file((File)Files.select((File)lib, (String)"openejb-javaagent.*.jar")));
        File javaHome = Files.readable((File)Files.dir((File)Files.exists((File)new File(System.getProperty("java.home")))));
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        this.java = Files.readable((File)Files.file((File)Files.path((File)javaHome, (String[])new String[]{"bin", isWindows ? "java.exe" : "java"})));
        this.jvmOpts.add("-XX:+HeapDumpOnOutOfMemoryError");
        this.jvmOpts.add("-javaagent:" + javaagentJar.getAbsolutePath());
        this.jvmOpts.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
        this.jvmOpts.add("--add-opens=java.base/java.io=ALL-UNNAMED");
        this.jvmOpts.add("--add-opens=java.base/java.util=ALL-UNNAMED");
        this.jvmOpts.add("--add-opens=java.base/java.util.concurrent=ALL-UNNAMED");
        this.jvmOpts.add("--add-opens=java.rmi/sun.rmi.transport=ALL-UNNAMED");
        this.jvmOpts.add("--add-opens=java.base/jdk.internal.loader=ALL-UNNAMED");
        this.jvmOpts.add("--add-opens=java.base/java.net=ALL-UNNAMED");
    }

    public Context getContext() {
        return this.context;
    }

    public ServerService getServerService(String string) {
        return new ServerService(string);
    }

    public File getHome() {
        return this.home;
    }

    public File getBase() {
        return this.base;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public void ignoreOut() {
        this.setOut(new DevNull());
    }

    public List<String> getJvmOpts() {
        return this.jvmOpts;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object setProperty(String key, String value) {
        return this.getProperties().setProperty(key, value);
    }

    public void start() {
        this.start(0, TimeUnit.MILLISECONDS);
    }

    public void start(int timeout, TimeUnit minutes) {
        if (this.process != null) {
            throw new ServerRunningException(this.home, "Server already running");
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.java.getAbsolutePath());
            args.addAll(this.jvmOpts);
            Set<Map.Entry<Object, Object>> collection = this.properties.entrySet();
            args.addAll(Join.strings(collection, (Join.NameCallback)new SystemPropertiesCallback()));
            if (this.debug) {
                args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + this.debugPort);
            }
            args.add("-jar");
            args.add(this.openejbJar.getAbsolutePath());
            args.add("start");
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.redirectErrorStream(true);
            if (this.verbose) {
                System.out.println(Join.join((String)"\n", args));
            }
            this.process = builder.start();
            if (timeout > 0) {
                OutputScanner scanner = new OutputScanner(this.out, "Ready!");
                Pipe.pipe((InputStream)this.process.getInputStream(), (OutputStream)scanner);
                scanner.await((long)timeout, minutes);
            } else {
                this.out = System.out;
                Pipe.pipe((InputStream)this.process.getInputStream(), (OutputStream)this.out);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IllegalStateException("Server failed to start in the expected time");
        }
        catch (IOException e) {
            throw new IllegalStateException("Server did not start correctly", e);
        }
    }

    private void edit() {
        if (this.process != null) {
            throw new ServerRunningException(this.home, "Cannot change settings while server is running");
        }
    }

    public void kill() {
        if (this.process == null) {
            return;
        }
        this.process.destroy();
        this.waitForExit();
    }

    private void waitForExit() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.process = null;
    }

    private int command(String ... strings) {
        return this.command(Arrays.asList(strings));
    }

    private int command(List<String> strings) {
        if (this.process == null) {
            throw new ServerNotRunningException(this.home);
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.java.getAbsolutePath());
            args.add("-jar");
            args.add(this.openejbJar.getAbsolutePath());
            args.addAll(strings);
            ProcessBuilder builder = new ProcessBuilder(args);
            Process command = builder.start();
            Pipe.read((Process)command);
            return command.waitFor();
        }
        catch (IOException e) {
            throw new ServerException(this.home, Join.join((String)" ", strings), e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return -1;
        }
    }

    public void deploy(String path) {
        int code = this.command("deploy", this.getServerUrl(), path);
        if (code != 0) {
            throw new DeployException(this.home, code, path);
        }
    }

    public void undeploy(String path) {
        int code = this.command("undeploy", this.getServerUrl(), path);
        if (code != 0) {
            throw new UndeployException(this.home, code, path);
        }
    }

    public void stop() {
        int code = this.command("stop");
        if (code != 0) {
            throw new StopException(this.home, code, new String[0]);
        }
        this.waitForExit();
    }

    public void killOnExit() {
        if (kill.contains(this)) {
            return;
        }
        kill.add(this);
    }

    private String getServerUrl() {
        String host;
        ServerService ejbd = this.getServerService("ejbd");
        int port = ejbd.getPort();
        if (port == 0) {
            port = Integer.parseInt(System.getProperty("ejbd.port", "4201"));
        }
        if ((host = ejbd.getBind()) == null || host.length() == 0) {
            host = "localhost";
        }
        return String.format("--server-url=ejbd://%s:%s", host, port);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (StandaloneServer server : kill) {
                    try {
                        if (server.process == null) continue;
                        server.process.destroy();
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    public class ServerService {
        private final String name;

        public ServerService(String name) {
            this.name = name;
        }

        public int getPort() {
            return StandaloneServer.this.options.get(this.name + ".port", -1);
        }

        public void setPort(int i) {
            StandaloneServer.this.properties.put(this.name + ".port", "" + i);
        }

        public boolean isDisabled() {
            return StandaloneServer.this.options.get(this.name + ".disabled", true);
        }

        public boolean isEnabled() {
            return !this.isDisabled();
        }

        public void setDisabled(boolean b) {
            StandaloneServer.this.properties.put(this.name + ".disabled", "" + b);
        }

        public void setEnabled(boolean b) {
            this.setDisabled(!b);
        }

        public String getBind() {
            return StandaloneServer.this.options.get(this.name + ".bind", "");
        }

        public void setBind(String bind) {
            StandaloneServer.this.properties.put(this.name + ".bind", bind);
        }

        public int getThreads() {
            return StandaloneServer.this.options.get(this.name + ".threads", -1);
        }

        public void setThreads(int threads) {
            StandaloneServer.this.properties.put(this.name + ".threads", "" + threads);
        }

        public ServerService set(String name, String value) {
            StandaloneServer.this.properties.put(this.name + "." + name, value);
            return this;
        }

        public Object get(String name) {
            return StandaloneServer.this.properties.get(this.name + "." + name);
        }

        public ServerService threads(int threads) {
            this.setThreads(threads);
            return this;
        }

        public ServerService port(int port) {
            this.setPort(port);
            return this;
        }

        public ServerService enable() {
            this.setEnabled(true);
            return this;
        }

        public ServerService disable() {
            this.setDisabled(true);
            return this;
        }

        public ServerService bind(String host) {
            this.setBind(host);
            return this;
        }
    }

    public static class DevNull
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
        }
    }

    public static class ServerRunningException
    extends ServerException {
        public ServerRunningException(File home) {
            super(home);
        }

        public ServerRunningException(File home, String message) {
            super(home, message);
        }
    }

    private static class SystemPropertiesCallback
    implements Join.NameCallback<Map.Entry<Object, Object>> {
        private SystemPropertiesCallback() {
        }

        public String getName(Map.Entry<Object, Object> e) {
            return String.format("-D%s=%s", e.getKey().toString(), e.getValue().toString());
        }
    }

    public static class ServerNotRunningException
    extends ServerException {
        public ServerNotRunningException(File home) {
            super(home);
        }
    }

    public static class ServerException
    extends RuntimeException {
        private final File home;

        public ServerException(File home) {
            this.home = home;
        }

        public ServerException(File home, String message) {
            super(message);
            this.home = home;
        }

        public ServerException(File home, String message, Throwable cause) {
            super(message, cause);
            this.home = home;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + String.format("server path `%s`", this.home.getAbsolutePath());
        }
    }

    public static class DeployException
    extends ServerCommandException {
        public DeployException(File home, int returnCode, String ... args) {
            super(home, returnCode, args);
        }
    }

    public static class UndeployException
    extends ServerCommandException {
        public UndeployException(File home, int returnCode, String ... args) {
            super(home, returnCode, args);
        }
    }

    public static class StopException
    extends ServerCommandException {
        public StopException(File home, int returnCode, String ... args) {
            super(home, returnCode, args);
        }
    }

    public static class ServerCommandException
    extends ServerException {
        private final int returnCode;
        private final String[] args;

        public ServerCommandException(File home, int returnCode, String ... args) {
            super(home);
            this.returnCode = returnCode;
            this.args = args;
        }
    }
}

