/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.api.communication.header;

import java.util.Arrays;
import java.util.List;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public enum HeaderName {
    accept("Accept", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    acceptCharset("Accept-Charset", Arrays.asList(ODataServiceVersion.V40)),
    acceptLanguage("Accept-Language", Arrays.asList(ODataServiceVersion.V40)),
    contentType("Content-Type", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    dataServiceVersion("DataServiceVersion", Arrays.asList(ODataServiceVersion.V30)),
    odataVersion("OData-Version", Arrays.asList(ODataServiceVersion.V40)),
    odataEntityId("OData-EntityId", Arrays.asList(ODataServiceVersion.V40)),
    etag("ETag", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    ifMatch("If-Match", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    ifNoneMatch("If-None-Match", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    odataMaxVersion("OData-MaxVersion", Arrays.asList(ODataServiceVersion.V40)),
    maxDataServiceVersion("MaxDataServiceVersion", Arrays.asList(ODataServiceVersion.V30)),
    minDataServiceVersion("MinDataServiceVersion", Arrays.asList(ODataServiceVersion.V30)),
    odataIsolation("OData-Isolation", Arrays.asList(ODataServiceVersion.V40)),
    prefer("Prefer", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    preferenceApplied("Preference-Applied", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    dataServiceId("DataServiceId", Arrays.asList(ODataServiceVersion.V30)),
    location("Location", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    retryAfter("Retry-After", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
    dataServiceUrlConventions("DataServiceUrlConventions", Arrays.asList(ODataServiceVersion.V30)),
    slug("Slug", Arrays.asList(ODataServiceVersion.V30)),
    xHttpMethod("X-HTTP-METHOD", Arrays.asList(ODataServiceVersion.V30));

    private final String headerName;
    private final List<ODataServiceVersion> supportedVersions;

    private HeaderName(String headerName, List<ODataServiceVersion> supportedVersions) {
        this.headerName = headerName;
        this.supportedVersions = supportedVersions;
    }

    final void isSupportedBy(ODataServiceVersion serviceVersion) {
        if (!this.supportedVersions.contains(serviceVersion)) {
            throw new ODataRuntimeException("Unsupported header " + this.toString());
        }
    }

    public String toString() {
        return this.headerName;
    }
}

